/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.ChannelParticipant;
import telegram4j.tl.ChannelParticipantCreator;
import telegram4j.tl.ChatAdminRights;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelParticipantCreator
implements ChannelParticipantCreator {
    private final int identifier;
    private final int flags;
    private final long userId;
    private final ChatAdminRights adminRights;
    @Nullable
    private final String rank;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableChannelParticipantCreator(long userId, ChatAdminRights adminRights) {
        this.userId = userId;
        this.adminRights = Objects.requireNonNull(adminRights, "adminRights");
        this.rank = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableChannelParticipantCreator(Builder builder) {
        this.userId = builder.userId;
        this.adminRights = builder.adminRights;
        this.rank = builder.rank;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableChannelParticipantCreator(int identifier, int flags, long userId, ChatAdminRights adminRights, @Nullable String rank) {
        this.identifier = identifier;
        this.flags = flags;
        this.userId = userId;
        this.adminRights = adminRights;
        this.rank = rank;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ChannelParticipantCreator.super.identifier();
    }

    private int flagsInitialize() {
        return ChannelParticipantCreator.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public ChatAdminRights adminRights() {
        return this.adminRights;
    }

    @Override
    @Nullable
    public String rank() {
        return this.rank;
    }

    public final ImmutableChannelParticipantCreator withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelParticipantCreator(value, this.flags, this.userId, this.adminRights, this.rank);
    }

    public final ImmutableChannelParticipantCreator withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableChannelParticipantCreator(this.identifier, value, this.userId, this.adminRights, this.rank);
    }

    public final ImmutableChannelParticipantCreator withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableChannelParticipantCreator(this.identifier, this.flags, value, this.adminRights, this.rank);
    }

    public final ImmutableChannelParticipantCreator withAdminRights(ChatAdminRights value) {
        if (this.adminRights == value) {
            return this;
        }
        ChatAdminRights newValue = Objects.requireNonNull(value, "adminRights");
        return new ImmutableChannelParticipantCreator(this.identifier, this.flags, this.userId, newValue, this.rank);
    }

    public final ImmutableChannelParticipantCreator withRank(@Nullable String value) {
        if (Objects.equals(this.rank, value)) {
            return this;
        }
        return new ImmutableChannelParticipantCreator(this.identifier, this.flags, this.userId, this.adminRights, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelParticipantCreator && this.equalTo(0, (ImmutableChannelParticipantCreator)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelParticipantCreator another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.userId == another.userId && this.adminRights.equals(another.adminRights) && Objects.equals(this.rank, another.rank);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.adminRights.hashCode();
        h += (h << 5) + Objects.hashCode(this.rank);
        return h;
    }

    public String toString() {
        return "ChannelParticipantCreator{identifier=" + this.identifier + ", flags=" + this.flags + ", userId=" + this.userId + ", adminRights=" + this.adminRights + ", rank=" + this.rank + "}";
    }

    public static ImmutableChannelParticipantCreator of(long userId, ChatAdminRights adminRights) {
        return new ImmutableChannelParticipantCreator(userId, adminRights);
    }

    public static ImmutableChannelParticipantCreator copyOf(ChannelParticipantCreator instance) {
        if (instance instanceof ImmutableChannelParticipantCreator) {
            return (ImmutableChannelParticipantCreator)instance;
        }
        return ImmutableChannelParticipantCreator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_ADMIN_RIGHTS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private long userId;
        private ChatAdminRights adminRights;
        private String rank;

        private Builder() {
        }

        public final Builder from(ChannelParticipantCreator instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelParticipant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChannelParticipant instance;
            long bits = 0L;
            if (object instanceof ChannelParticipantCreator) {
                String rankValue;
                instance = (ChannelParticipantCreator)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((rankValue = instance.rank()) != null) {
                    this.rank(rankValue);
                }
                this.userId(instance.userId());
                this.adminRights(instance.adminRights());
            }
            if (object instanceof ChannelParticipant) {
                instance = (ChannelParticipant)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder adminRights(ChatAdminRights adminRights) {
            this.adminRights = Objects.requireNonNull(adminRights, "adminRights");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder rank(@Nullable String rank) {
            this.rank = rank;
            return this;
        }

        public ImmutableChannelParticipantCreator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelParticipantCreator(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("adminRights");
            }
            return "Cannot build ChannelParticipantCreator, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChannelParticipantCreator.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChannelParticipantCreator.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build ChannelParticipantCreator, attribute initializers form cycle " + attributes;
        }
    }
}

