/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChannelParticipant;
import telegram4j.tl.ChannelParticipantLeft;
import telegram4j.tl.Peer;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelParticipantLeft
implements ChannelParticipantLeft {
    private final int identifier;
    private final Peer peer;

    private ImmutableChannelParticipantLeft(Peer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.identifier = ChannelParticipantLeft.super.identifier();
    }

    private ImmutableChannelParticipantLeft(Builder builder) {
        this.peer = builder.peer;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChannelParticipantLeft.super.identifier();
    }

    private ImmutableChannelParticipantLeft(int identifier, Peer peer) {
        this.identifier = identifier;
        this.peer = peer;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    public final ImmutableChannelParticipantLeft withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelParticipantLeft(value, this.peer);
    }

    public final ImmutableChannelParticipantLeft withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableChannelParticipantLeft(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelParticipantLeft && this.equalTo(0, (ImmutableChannelParticipantLeft)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelParticipantLeft another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        return h;
    }

    public String toString() {
        return "ChannelParticipantLeft{identifier=" + this.identifier + ", peer=" + this.peer + "}";
    }

    public static ImmutableChannelParticipantLeft of(Peer peer) {
        return new ImmutableChannelParticipantLeft(peer);
    }

    public static ImmutableChannelParticipantLeft copyOf(ChannelParticipantLeft instance) {
        if (instance instanceof ImmutableChannelParticipantLeft) {
            return (ImmutableChannelParticipantLeft)instance;
        }
        return ImmutableChannelParticipantLeft.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private Peer peer;

        private Builder() {
        }

        public final Builder from(ChannelParticipantLeft instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelParticipant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChannelParticipant instance;
            long bits = 0L;
            if (object instanceof ChannelParticipantLeft) {
                instance = (ChannelParticipantLeft)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
            if (object instanceof ChannelParticipant) {
                instance = (ChannelParticipant)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableChannelParticipantLeft build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelParticipantLeft(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build ChannelParticipantLeft, some of required attributes are not set " + attributes;
        }
    }
}

