/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChannelParticipant;
import telegram4j.tl.ChannelParticipantSelf;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelParticipantSelf
implements ChannelParticipantSelf {
    private final int identifier;
    private final int flags;
    private final boolean viaRequest;
    private final long userId;
    private final long inviterId;
    private final int date;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableChannelParticipantSelf(long userId, long inviterId, int date) {
        this.userId = userId;
        this.inviterId = inviterId;
        this.date = date;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.viaRequest = this.initShim.viaRequest();
        this.initShim = null;
    }

    private ImmutableChannelParticipantSelf(Builder builder) {
        this.userId = builder.userId;
        this.inviterId = builder.inviterId;
        this.date = builder.date;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.viaRequestIsSet()) {
            this.initShim.viaRequest(builder.viaRequest);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.viaRequest = this.initShim.viaRequest();
        this.initShim = null;
    }

    private ImmutableChannelParticipantSelf(int identifier, int flags, boolean viaRequest, long userId, long inviterId, int date) {
        this.identifier = identifier;
        this.flags = flags;
        this.viaRequest = viaRequest;
        this.userId = userId;
        this.inviterId = inviterId;
        this.date = date;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ChannelParticipantSelf.super.identifier();
    }

    private int flagsInitialize() {
        return ChannelParticipantSelf.super.flags();
    }

    private boolean viaRequestInitialize() {
        return ChannelParticipantSelf.super.viaRequest();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean viaRequest() {
        InitShim shim = this.initShim;
        return shim != null ? shim.viaRequest() : this.viaRequest;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public long inviterId() {
        return this.inviterId;
    }

    @Override
    public int date() {
        return this.date;
    }

    public final ImmutableChannelParticipantSelf withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelParticipantSelf(value, this.flags, this.viaRequest, this.userId, this.inviterId, this.date);
    }

    public final ImmutableChannelParticipantSelf withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableChannelParticipantSelf(this.identifier, value, this.viaRequest, this.userId, this.inviterId, this.date);
    }

    public final ImmutableChannelParticipantSelf withViaRequest(boolean value) {
        if (this.viaRequest == value) {
            return this;
        }
        return new ImmutableChannelParticipantSelf(this.identifier, this.flags, value, this.userId, this.inviterId, this.date);
    }

    public final ImmutableChannelParticipantSelf withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableChannelParticipantSelf(this.identifier, this.flags, this.viaRequest, value, this.inviterId, this.date);
    }

    public final ImmutableChannelParticipantSelf withInviterId(long value) {
        if (this.inviterId == value) {
            return this;
        }
        return new ImmutableChannelParticipantSelf(this.identifier, this.flags, this.viaRequest, this.userId, value, this.date);
    }

    public final ImmutableChannelParticipantSelf withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableChannelParticipantSelf(this.identifier, this.flags, this.viaRequest, this.userId, this.inviterId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelParticipantSelf && this.equalTo(0, (ImmutableChannelParticipantSelf)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelParticipantSelf another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.viaRequest == another.viaRequest && this.userId == another.userId && this.inviterId == another.inviterId && this.date == another.date;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.viaRequest);
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + Long.hashCode(this.inviterId);
        h += (h << 5) + this.date;
        return h;
    }

    public String toString() {
        return "ChannelParticipantSelf{identifier=" + this.identifier + ", flags=" + this.flags + ", viaRequest=" + this.viaRequest + ", userId=" + this.userId + ", inviterId=" + this.inviterId + ", date=" + this.date + "}";
    }

    public static ImmutableChannelParticipantSelf of(long userId, long inviterId, int date) {
        return new ImmutableChannelParticipantSelf(userId, inviterId, date);
    }

    public static ImmutableChannelParticipantSelf copyOf(ChannelParticipantSelf instance) {
        if (instance instanceof ImmutableChannelParticipantSelf) {
            return (ImmutableChannelParticipantSelf)instance;
        }
        return ImmutableChannelParticipantSelf.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_INVITER_ID = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_VIA_REQUEST = 4L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean viaRequest;
        private long userId;
        private long inviterId;
        private int date;

        private Builder() {
        }

        public final Builder from(ChannelParticipantSelf instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelParticipant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChannelParticipant instance;
            long bits = 0L;
            if (object instanceof ChannelParticipantSelf) {
                instance = (ChannelParticipantSelf)object;
                this.date(instance.date());
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.viaRequest(instance.viaRequest());
                this.inviterId(instance.inviterId());
                this.userId(instance.userId());
            }
            if (object instanceof ChannelParticipant) {
                instance = (ChannelParticipant)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder viaRequest(boolean viaRequest) {
            this.viaRequest = viaRequest;
            this.optBits |= 4L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder inviterId(long inviterId) {
            this.inviterId = inviterId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableChannelParticipantSelf build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelParticipantSelf(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean viaRequestIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("inviterId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build ChannelParticipantSelf, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte viaRequestBuildStage = 0;
        private boolean viaRequest;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChannelParticipantSelf.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChannelParticipantSelf.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean viaRequest() {
            if (this.viaRequestBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.viaRequestBuildStage == 0) {
                this.viaRequestBuildStage = (byte)-1;
                this.viaRequest = ImmutableChannelParticipantSelf.this.viaRequestInitialize();
                this.viaRequestBuildStage = 1;
            }
            return this.viaRequest;
        }

        void viaRequest(boolean viaRequest) {
            this.viaRequest = viaRequest;
            this.viaRequestBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.viaRequestBuildStage == -1) {
                attributes.add("viaRequest");
            }
            return "Cannot build ChannelParticipantSelf, attribute initializers form cycle " + attributes;
        }
    }
}

