/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChannelParticipantsFilter;
import telegram4j.tl.ChannelParticipantsKicked;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelParticipantsKicked
implements ChannelParticipantsKicked {
    private final int identifier;
    private final String q;

    private ImmutableChannelParticipantsKicked(String q) {
        this.q = Objects.requireNonNull(q, "q");
        this.identifier = ChannelParticipantsKicked.super.identifier();
    }

    private ImmutableChannelParticipantsKicked(Builder builder) {
        this.q = builder.q;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChannelParticipantsKicked.super.identifier();
    }

    private ImmutableChannelParticipantsKicked(int identifier, String q) {
        this.identifier = identifier;
        this.q = q;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String q() {
        return this.q;
    }

    public final ImmutableChannelParticipantsKicked withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelParticipantsKicked(value, this.q);
    }

    public final ImmutableChannelParticipantsKicked withQ(String value) {
        String newValue = Objects.requireNonNull(value, "q");
        if (this.q.equals(newValue)) {
            return this;
        }
        return new ImmutableChannelParticipantsKicked(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelParticipantsKicked && this.equalTo(0, (ImmutableChannelParticipantsKicked)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelParticipantsKicked another) {
        return this.identifier == another.identifier && this.q.equals(another.q);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.q.hashCode();
        return h;
    }

    public String toString() {
        return "ChannelParticipantsKicked{identifier=" + this.identifier + ", q=" + this.q + "}";
    }

    public static ImmutableChannelParticipantsKicked of(String q) {
        return new ImmutableChannelParticipantsKicked(q);
    }

    public static ImmutableChannelParticipantsKicked copyOf(ChannelParticipantsKicked instance) {
        if (instance instanceof ImmutableChannelParticipantsKicked) {
            return (ImmutableChannelParticipantsKicked)instance;
        }
        return ImmutableChannelParticipantsKicked.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_Q = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String q;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelParticipantsKicked instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelParticipantsFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelParticipantsKicked) {
                instance = (ChannelParticipantsKicked)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.q(instance.q());
            }
            if (object instanceof ChannelParticipantsFilter) {
                instance = (ChannelParticipantsFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder q(String q) {
            this.q = Objects.requireNonNull(q, "q");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableChannelParticipantsKicked build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelParticipantsKicked(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("q");
            }
            return "Cannot build ChannelParticipantsKicked, some of required attributes are not set " + attributes;
        }
    }
}

