/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.ChannelParticipantsFilter;
import telegram4j.tl.ChannelParticipantsMentions;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelParticipantsMentions
implements ChannelParticipantsMentions {
    private final int identifier;
    private final int flags;
    @Nullable
    private final String q;
    @Nullable
    private final Integer topMsgId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableChannelParticipantsMentions INSTANCE = ImmutableChannelParticipantsMentions.validate(new ImmutableChannelParticipantsMentions());

    private ImmutableChannelParticipantsMentions() {
        this.q = null;
        this.topMsgId = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableChannelParticipantsMentions(Builder builder) {
        this.q = builder.q;
        this.topMsgId = builder.topMsgId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableChannelParticipantsMentions(int identifier, int flags, @Nullable String q, @Nullable Integer topMsgId) {
        this.identifier = identifier;
        this.flags = flags;
        this.q = q;
        this.topMsgId = topMsgId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ChannelParticipantsMentions.super.identifier();
    }

    private int flagsInitialize() {
        return ChannelParticipantsMentions.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public String q() {
        return this.q;
    }

    @Override
    @Nullable
    public Integer topMsgId() {
        return this.topMsgId;
    }

    public final ImmutableChannelParticipantsMentions withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableChannelParticipantsMentions.validate(new ImmutableChannelParticipantsMentions(value, this.flags, this.q, this.topMsgId));
    }

    public final ImmutableChannelParticipantsMentions withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableChannelParticipantsMentions.validate(new ImmutableChannelParticipantsMentions(this.identifier, value, this.q, this.topMsgId));
    }

    public final ImmutableChannelParticipantsMentions withQ(@Nullable String value) {
        if (Objects.equals(this.q, value)) {
            return this;
        }
        return ImmutableChannelParticipantsMentions.validate(new ImmutableChannelParticipantsMentions(this.identifier, this.flags, value, this.topMsgId));
    }

    public final ImmutableChannelParticipantsMentions withTopMsgId(@Nullable Integer value) {
        if (Objects.equals(this.topMsgId, value)) {
            return this;
        }
        return ImmutableChannelParticipantsMentions.validate(new ImmutableChannelParticipantsMentions(this.identifier, this.flags, this.q, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelParticipantsMentions && this.equalTo(0, (ImmutableChannelParticipantsMentions)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelParticipantsMentions another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.q, another.q) && Objects.equals(this.topMsgId, another.topMsgId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.q);
        h += (h << 5) + Objects.hashCode(this.topMsgId);
        return h;
    }

    public String toString() {
        return "ChannelParticipantsMentions{identifier=" + this.identifier + ", flags=" + this.flags + ", q=" + this.q + ", topMsgId=" + this.topMsgId + "}";
    }

    public static ImmutableChannelParticipantsMentions of() {
        return INSTANCE;
    }

    private static ImmutableChannelParticipantsMentions validate(ImmutableChannelParticipantsMentions instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableChannelParticipantsMentions copyOf(ChannelParticipantsMentions instance) {
        if (instance instanceof ImmutableChannelParticipantsMentions) {
            return (ImmutableChannelParticipantsMentions)instance;
        }
        return ImmutableChannelParticipantsMentions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private String q;
        private Integer topMsgId;

        private Builder() {
        }

        public final Builder from(ChannelParticipantsMentions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelParticipantsFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChannelParticipantsFilter instance;
            long bits = 0L;
            if (object instanceof ChannelParticipantsMentions) {
                Integer topMsgIdValue;
                String qValue;
                instance = (ChannelParticipantsMentions)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((qValue = instance.q()) != null) {
                    this.q(qValue);
                }
                if ((topMsgIdValue = instance.topMsgId()) != null) {
                    this.topMsgId(topMsgIdValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelParticipantsFilter) {
                instance = (ChannelParticipantsFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder q(@Nullable String q) {
            this.q = q;
            return this;
        }

        public final Builder topMsgId(@Nullable Integer topMsgId) {
            this.topMsgId = topMsgId;
            return this;
        }

        public ImmutableChannelParticipantsMentions build() {
            return ImmutableChannelParticipantsMentions.validate(new ImmutableChannelParticipantsMentions(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChannelParticipantsMentions.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChannelParticipantsMentions.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build ChannelParticipantsMentions, attribute initializers form cycle " + attributes;
        }
    }
}

