/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.ChannelParticipantsFilter;
import telegram4j.tl.ChannelParticipantsRecent;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelParticipantsRecent
implements ChannelParticipantsRecent {
    private final int identifier;
    private static final ImmutableChannelParticipantsRecent INSTANCE = ImmutableChannelParticipantsRecent.validate(new ImmutableChannelParticipantsRecent());

    private ImmutableChannelParticipantsRecent() {
        this.identifier = ChannelParticipantsRecent.super.identifier();
    }

    private ImmutableChannelParticipantsRecent(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChannelParticipantsRecent.super.identifier();
    }

    private ImmutableChannelParticipantsRecent(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableChannelParticipantsRecent withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableChannelParticipantsRecent.validate(new ImmutableChannelParticipantsRecent(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelParticipantsRecent && this.equalTo(0, (ImmutableChannelParticipantsRecent)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelParticipantsRecent another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "ChannelParticipantsRecent{identifier=" + this.identifier + "}";
    }

    public static ImmutableChannelParticipantsRecent of() {
        return INSTANCE;
    }

    private static ImmutableChannelParticipantsRecent validate(ImmutableChannelParticipantsRecent instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableChannelParticipantsRecent copyOf(ChannelParticipantsRecent instance) {
        if (instance instanceof ImmutableChannelParticipantsRecent) {
            return (ImmutableChannelParticipantsRecent)instance;
        }
        return ImmutableChannelParticipantsRecent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(ChannelParticipantsRecent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelParticipantsFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChannelParticipantsFilter instance;
            long bits = 0L;
            if (object instanceof ChannelParticipantsRecent) {
                instance = (ChannelParticipantsRecent)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelParticipantsFilter) {
                instance = (ChannelParticipantsFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableChannelParticipantsRecent build() {
            return ImmutableChannelParticipantsRecent.validate(new ImmutableChannelParticipantsRecent(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

