/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChatAdminRights;
import telegram4j.tl.api.TlObject;

public final class ImmutableChatAdminRights
implements ChatAdminRights {
    private final int identifier;
    private final int flags;
    private final boolean changeInfo;
    private final boolean postMessages;
    private final boolean editMessages;
    private final boolean deleteMessages;
    private final boolean banUsers;
    private final boolean inviteUsers;
    private final boolean pinMessages;
    private final boolean addAdmins;
    private final boolean anonymous;
    private final boolean manageCall;
    private final boolean other;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableChatAdminRights INSTANCE = ImmutableChatAdminRights.validate(new ImmutableChatAdminRights());

    private ImmutableChatAdminRights() {
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.changeInfo = this.initShim.changeInfo();
        this.postMessages = this.initShim.postMessages();
        this.editMessages = this.initShim.editMessages();
        this.deleteMessages = this.initShim.deleteMessages();
        this.banUsers = this.initShim.banUsers();
        this.inviteUsers = this.initShim.inviteUsers();
        this.pinMessages = this.initShim.pinMessages();
        this.addAdmins = this.initShim.addAdmins();
        this.anonymous = this.initShim.anonymous();
        this.manageCall = this.initShim.manageCall();
        this.other = this.initShim.other();
        this.initShim = null;
    }

    private ImmutableChatAdminRights(Builder builder) {
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.changeInfoIsSet()) {
            this.initShim.changeInfo(builder.changeInfo);
        }
        if (builder.postMessagesIsSet()) {
            this.initShim.postMessages(builder.postMessages);
        }
        if (builder.editMessagesIsSet()) {
            this.initShim.editMessages(builder.editMessages);
        }
        if (builder.deleteMessagesIsSet()) {
            this.initShim.deleteMessages(builder.deleteMessages);
        }
        if (builder.banUsersIsSet()) {
            this.initShim.banUsers(builder.banUsers);
        }
        if (builder.inviteUsersIsSet()) {
            this.initShim.inviteUsers(builder.inviteUsers);
        }
        if (builder.pinMessagesIsSet()) {
            this.initShim.pinMessages(builder.pinMessages);
        }
        if (builder.addAdminsIsSet()) {
            this.initShim.addAdmins(builder.addAdmins);
        }
        if (builder.anonymousIsSet()) {
            this.initShim.anonymous(builder.anonymous);
        }
        if (builder.manageCallIsSet()) {
            this.initShim.manageCall(builder.manageCall);
        }
        if (builder.otherIsSet()) {
            this.initShim.other(builder.other);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.changeInfo = this.initShim.changeInfo();
        this.postMessages = this.initShim.postMessages();
        this.editMessages = this.initShim.editMessages();
        this.deleteMessages = this.initShim.deleteMessages();
        this.banUsers = this.initShim.banUsers();
        this.inviteUsers = this.initShim.inviteUsers();
        this.pinMessages = this.initShim.pinMessages();
        this.addAdmins = this.initShim.addAdmins();
        this.anonymous = this.initShim.anonymous();
        this.manageCall = this.initShim.manageCall();
        this.other = this.initShim.other();
        this.initShim = null;
    }

    private ImmutableChatAdminRights(int identifier, int flags, boolean changeInfo, boolean postMessages, boolean editMessages, boolean deleteMessages, boolean banUsers, boolean inviteUsers, boolean pinMessages, boolean addAdmins, boolean anonymous, boolean manageCall, boolean other) {
        this.identifier = identifier;
        this.flags = flags;
        this.changeInfo = changeInfo;
        this.postMessages = postMessages;
        this.editMessages = editMessages;
        this.deleteMessages = deleteMessages;
        this.banUsers = banUsers;
        this.inviteUsers = inviteUsers;
        this.pinMessages = pinMessages;
        this.addAdmins = addAdmins;
        this.anonymous = anonymous;
        this.manageCall = manageCall;
        this.other = other;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ChatAdminRights.super.identifier();
    }

    private int flagsInitialize() {
        return ChatAdminRights.super.flags();
    }

    private boolean changeInfoInitialize() {
        return ChatAdminRights.super.changeInfo();
    }

    private boolean postMessagesInitialize() {
        return ChatAdminRights.super.postMessages();
    }

    private boolean editMessagesInitialize() {
        return ChatAdminRights.super.editMessages();
    }

    private boolean deleteMessagesInitialize() {
        return ChatAdminRights.super.deleteMessages();
    }

    private boolean banUsersInitialize() {
        return ChatAdminRights.super.banUsers();
    }

    private boolean inviteUsersInitialize() {
        return ChatAdminRights.super.inviteUsers();
    }

    private boolean pinMessagesInitialize() {
        return ChatAdminRights.super.pinMessages();
    }

    private boolean addAdminsInitialize() {
        return ChatAdminRights.super.addAdmins();
    }

    private boolean anonymousInitialize() {
        return ChatAdminRights.super.anonymous();
    }

    private boolean manageCallInitialize() {
        return ChatAdminRights.super.manageCall();
    }

    private boolean otherInitialize() {
        return ChatAdminRights.super.other();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean changeInfo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.changeInfo() : this.changeInfo;
    }

    @Override
    public boolean postMessages() {
        InitShim shim = this.initShim;
        return shim != null ? shim.postMessages() : this.postMessages;
    }

    @Override
    public boolean editMessages() {
        InitShim shim = this.initShim;
        return shim != null ? shim.editMessages() : this.editMessages;
    }

    @Override
    public boolean deleteMessages() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deleteMessages() : this.deleteMessages;
    }

    @Override
    public boolean banUsers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.banUsers() : this.banUsers;
    }

    @Override
    public boolean inviteUsers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.inviteUsers() : this.inviteUsers;
    }

    @Override
    public boolean pinMessages() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pinMessages() : this.pinMessages;
    }

    @Override
    public boolean addAdmins() {
        InitShim shim = this.initShim;
        return shim != null ? shim.addAdmins() : this.addAdmins;
    }

    @Override
    public boolean anonymous() {
        InitShim shim = this.initShim;
        return shim != null ? shim.anonymous() : this.anonymous;
    }

    @Override
    public boolean manageCall() {
        InitShim shim = this.initShim;
        return shim != null ? shim.manageCall() : this.manageCall;
    }

    @Override
    public boolean other() {
        InitShim shim = this.initShim;
        return shim != null ? shim.other() : this.other;
    }

    public final ImmutableChatAdminRights withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableChatAdminRights.validate(new ImmutableChatAdminRights(value, this.flags, this.changeInfo, this.postMessages, this.editMessages, this.deleteMessages, this.banUsers, this.inviteUsers, this.pinMessages, this.addAdmins, this.anonymous, this.manageCall, this.other));
    }

    public final ImmutableChatAdminRights withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableChatAdminRights.validate(new ImmutableChatAdminRights(this.identifier, value, this.changeInfo, this.postMessages, this.editMessages, this.deleteMessages, this.banUsers, this.inviteUsers, this.pinMessages, this.addAdmins, this.anonymous, this.manageCall, this.other));
    }

    public final ImmutableChatAdminRights withChangeInfo(boolean value) {
        if (this.changeInfo == value) {
            return this;
        }
        return ImmutableChatAdminRights.validate(new ImmutableChatAdminRights(this.identifier, this.flags, value, this.postMessages, this.editMessages, this.deleteMessages, this.banUsers, this.inviteUsers, this.pinMessages, this.addAdmins, this.anonymous, this.manageCall, this.other));
    }

    public final ImmutableChatAdminRights withPostMessages(boolean value) {
        if (this.postMessages == value) {
            return this;
        }
        return ImmutableChatAdminRights.validate(new ImmutableChatAdminRights(this.identifier, this.flags, this.changeInfo, value, this.editMessages, this.deleteMessages, this.banUsers, this.inviteUsers, this.pinMessages, this.addAdmins, this.anonymous, this.manageCall, this.other));
    }

    public final ImmutableChatAdminRights withEditMessages(boolean value) {
        if (this.editMessages == value) {
            return this;
        }
        return ImmutableChatAdminRights.validate(new ImmutableChatAdminRights(this.identifier, this.flags, this.changeInfo, this.postMessages, value, this.deleteMessages, this.banUsers, this.inviteUsers, this.pinMessages, this.addAdmins, this.anonymous, this.manageCall, this.other));
    }

    public final ImmutableChatAdminRights withDeleteMessages(boolean value) {
        if (this.deleteMessages == value) {
            return this;
        }
        return ImmutableChatAdminRights.validate(new ImmutableChatAdminRights(this.identifier, this.flags, this.changeInfo, this.postMessages, this.editMessages, value, this.banUsers, this.inviteUsers, this.pinMessages, this.addAdmins, this.anonymous, this.manageCall, this.other));
    }

    public final ImmutableChatAdminRights withBanUsers(boolean value) {
        if (this.banUsers == value) {
            return this;
        }
        return ImmutableChatAdminRights.validate(new ImmutableChatAdminRights(this.identifier, this.flags, this.changeInfo, this.postMessages, this.editMessages, this.deleteMessages, value, this.inviteUsers, this.pinMessages, this.addAdmins, this.anonymous, this.manageCall, this.other));
    }

    public final ImmutableChatAdminRights withInviteUsers(boolean value) {
        if (this.inviteUsers == value) {
            return this;
        }
        return ImmutableChatAdminRights.validate(new ImmutableChatAdminRights(this.identifier, this.flags, this.changeInfo, this.postMessages, this.editMessages, this.deleteMessages, this.banUsers, value, this.pinMessages, this.addAdmins, this.anonymous, this.manageCall, this.other));
    }

    public final ImmutableChatAdminRights withPinMessages(boolean value) {
        if (this.pinMessages == value) {
            return this;
        }
        return ImmutableChatAdminRights.validate(new ImmutableChatAdminRights(this.identifier, this.flags, this.changeInfo, this.postMessages, this.editMessages, this.deleteMessages, this.banUsers, this.inviteUsers, value, this.addAdmins, this.anonymous, this.manageCall, this.other));
    }

    public final ImmutableChatAdminRights withAddAdmins(boolean value) {
        if (this.addAdmins == value) {
            return this;
        }
        return ImmutableChatAdminRights.validate(new ImmutableChatAdminRights(this.identifier, this.flags, this.changeInfo, this.postMessages, this.editMessages, this.deleteMessages, this.banUsers, this.inviteUsers, this.pinMessages, value, this.anonymous, this.manageCall, this.other));
    }

    public final ImmutableChatAdminRights withAnonymous(boolean value) {
        if (this.anonymous == value) {
            return this;
        }
        return ImmutableChatAdminRights.validate(new ImmutableChatAdminRights(this.identifier, this.flags, this.changeInfo, this.postMessages, this.editMessages, this.deleteMessages, this.banUsers, this.inviteUsers, this.pinMessages, this.addAdmins, value, this.manageCall, this.other));
    }

    public final ImmutableChatAdminRights withManageCall(boolean value) {
        if (this.manageCall == value) {
            return this;
        }
        return ImmutableChatAdminRights.validate(new ImmutableChatAdminRights(this.identifier, this.flags, this.changeInfo, this.postMessages, this.editMessages, this.deleteMessages, this.banUsers, this.inviteUsers, this.pinMessages, this.addAdmins, this.anonymous, value, this.other));
    }

    public final ImmutableChatAdminRights withOther(boolean value) {
        if (this.other == value) {
            return this;
        }
        return ImmutableChatAdminRights.validate(new ImmutableChatAdminRights(this.identifier, this.flags, this.changeInfo, this.postMessages, this.editMessages, this.deleteMessages, this.banUsers, this.inviteUsers, this.pinMessages, this.addAdmins, this.anonymous, this.manageCall, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChatAdminRights && this.equalTo(0, (ImmutableChatAdminRights)another);
    }

    private boolean equalTo(int synthetic, ImmutableChatAdminRights another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.changeInfo == another.changeInfo && this.postMessages == another.postMessages && this.editMessages == another.editMessages && this.deleteMessages == another.deleteMessages && this.banUsers == another.banUsers && this.inviteUsers == another.inviteUsers && this.pinMessages == another.pinMessages && this.addAdmins == another.addAdmins && this.anonymous == another.anonymous && this.manageCall == another.manageCall && this.other == another.other;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.changeInfo);
        h += (h << 5) + Boolean.hashCode(this.postMessages);
        h += (h << 5) + Boolean.hashCode(this.editMessages);
        h += (h << 5) + Boolean.hashCode(this.deleteMessages);
        h += (h << 5) + Boolean.hashCode(this.banUsers);
        h += (h << 5) + Boolean.hashCode(this.inviteUsers);
        h += (h << 5) + Boolean.hashCode(this.pinMessages);
        h += (h << 5) + Boolean.hashCode(this.addAdmins);
        h += (h << 5) + Boolean.hashCode(this.anonymous);
        h += (h << 5) + Boolean.hashCode(this.manageCall);
        h += (h << 5) + Boolean.hashCode(this.other);
        return h;
    }

    public String toString() {
        return "ChatAdminRights{identifier=" + this.identifier + ", flags=" + this.flags + ", changeInfo=" + this.changeInfo + ", postMessages=" + this.postMessages + ", editMessages=" + this.editMessages + ", deleteMessages=" + this.deleteMessages + ", banUsers=" + this.banUsers + ", inviteUsers=" + this.inviteUsers + ", pinMessages=" + this.pinMessages + ", addAdmins=" + this.addAdmins + ", anonymous=" + this.anonymous + ", manageCall=" + this.manageCall + ", other=" + this.other + "}";
    }

    public static ImmutableChatAdminRights of() {
        return INSTANCE;
    }

    private static ImmutableChatAdminRights validate(ImmutableChatAdminRights instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableChatAdminRights copyOf(ChatAdminRights instance) {
        if (instance instanceof ImmutableChatAdminRights) {
            return (ImmutableChatAdminRights)instance;
        }
        return ImmutableChatAdminRights.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CHANGE_INFO = 4L;
        private static final long OPT_BIT_POST_MESSAGES = 8L;
        private static final long OPT_BIT_EDIT_MESSAGES = 16L;
        private static final long OPT_BIT_DELETE_MESSAGES = 32L;
        private static final long OPT_BIT_BAN_USERS = 64L;
        private static final long OPT_BIT_INVITE_USERS = 128L;
        private static final long OPT_BIT_PIN_MESSAGES = 256L;
        private static final long OPT_BIT_ADD_ADMINS = 512L;
        private static final long OPT_BIT_ANONYMOUS = 1024L;
        private static final long OPT_BIT_MANAGE_CALL = 2048L;
        private static final long OPT_BIT_OTHER = 4096L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean changeInfo;
        private boolean postMessages;
        private boolean editMessages;
        private boolean deleteMessages;
        private boolean banUsers;
        private boolean inviteUsers;
        private boolean pinMessages;
        private boolean addAdmins;
        private boolean anonymous;
        private boolean manageCall;
        private boolean other;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatAdminRights instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChatAdminRights) {
                instance = (ChatAdminRights)object;
                this.deleteMessages(instance.deleteMessages());
                this.manageCall(instance.manageCall());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.other(instance.other());
                this.pinMessages(instance.pinMessages());
                this.flags(instance.flags());
                this.editMessages(instance.editMessages());
                this.inviteUsers(instance.inviteUsers());
                this.banUsers(instance.banUsers());
                this.changeInfo(instance.changeInfo());
                this.addAdmins(instance.addAdmins());
                this.anonymous(instance.anonymous());
                this.postMessages(instance.postMessages());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder changeInfo(boolean changeInfo) {
            this.changeInfo = changeInfo;
            this.optBits |= 4L;
            return this;
        }

        public final Builder postMessages(boolean postMessages) {
            this.postMessages = postMessages;
            this.optBits |= 8L;
            return this;
        }

        public final Builder editMessages(boolean editMessages) {
            this.editMessages = editMessages;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder deleteMessages(boolean deleteMessages) {
            this.deleteMessages = deleteMessages;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder banUsers(boolean banUsers) {
            this.banUsers = banUsers;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder inviteUsers(boolean inviteUsers) {
            this.inviteUsers = inviteUsers;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder pinMessages(boolean pinMessages) {
            this.pinMessages = pinMessages;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder addAdmins(boolean addAdmins) {
            this.addAdmins = addAdmins;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder anonymous(boolean anonymous) {
            this.anonymous = anonymous;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder manageCall(boolean manageCall) {
            this.manageCall = manageCall;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder other(boolean other) {
            this.other = other;
            this.optBits |= 0x1000L;
            return this;
        }

        public ImmutableChatAdminRights build() {
            return ImmutableChatAdminRights.validate(new ImmutableChatAdminRights(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean changeInfoIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean postMessagesIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean editMessagesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean deleteMessagesIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean banUsersIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean inviteUsersIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean pinMessagesIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean addAdminsIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean anonymousIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean manageCallIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean otherIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte changeInfoBuildStage = 0;
        private boolean changeInfo;
        private byte postMessagesBuildStage = 0;
        private boolean postMessages;
        private byte editMessagesBuildStage = 0;
        private boolean editMessages;
        private byte deleteMessagesBuildStage = 0;
        private boolean deleteMessages;
        private byte banUsersBuildStage = 0;
        private boolean banUsers;
        private byte inviteUsersBuildStage = 0;
        private boolean inviteUsers;
        private byte pinMessagesBuildStage = 0;
        private boolean pinMessages;
        private byte addAdminsBuildStage = 0;
        private boolean addAdmins;
        private byte anonymousBuildStage = 0;
        private boolean anonymous;
        private byte manageCallBuildStage = 0;
        private boolean manageCall;
        private byte otherBuildStage = 0;
        private boolean other;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChatAdminRights.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChatAdminRights.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean changeInfo() {
            if (this.changeInfoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.changeInfoBuildStage == 0) {
                this.changeInfoBuildStage = (byte)-1;
                this.changeInfo = ImmutableChatAdminRights.this.changeInfoInitialize();
                this.changeInfoBuildStage = 1;
            }
            return this.changeInfo;
        }

        void changeInfo(boolean changeInfo) {
            this.changeInfo = changeInfo;
            this.changeInfoBuildStage = 1;
        }

        boolean postMessages() {
            if (this.postMessagesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.postMessagesBuildStage == 0) {
                this.postMessagesBuildStage = (byte)-1;
                this.postMessages = ImmutableChatAdminRights.this.postMessagesInitialize();
                this.postMessagesBuildStage = 1;
            }
            return this.postMessages;
        }

        void postMessages(boolean postMessages) {
            this.postMessages = postMessages;
            this.postMessagesBuildStage = 1;
        }

        boolean editMessages() {
            if (this.editMessagesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.editMessagesBuildStage == 0) {
                this.editMessagesBuildStage = (byte)-1;
                this.editMessages = ImmutableChatAdminRights.this.editMessagesInitialize();
                this.editMessagesBuildStage = 1;
            }
            return this.editMessages;
        }

        void editMessages(boolean editMessages) {
            this.editMessages = editMessages;
            this.editMessagesBuildStage = 1;
        }

        boolean deleteMessages() {
            if (this.deleteMessagesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deleteMessagesBuildStage == 0) {
                this.deleteMessagesBuildStage = (byte)-1;
                this.deleteMessages = ImmutableChatAdminRights.this.deleteMessagesInitialize();
                this.deleteMessagesBuildStage = 1;
            }
            return this.deleteMessages;
        }

        void deleteMessages(boolean deleteMessages) {
            this.deleteMessages = deleteMessages;
            this.deleteMessagesBuildStage = 1;
        }

        boolean banUsers() {
            if (this.banUsersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.banUsersBuildStage == 0) {
                this.banUsersBuildStage = (byte)-1;
                this.banUsers = ImmutableChatAdminRights.this.banUsersInitialize();
                this.banUsersBuildStage = 1;
            }
            return this.banUsers;
        }

        void banUsers(boolean banUsers) {
            this.banUsers = banUsers;
            this.banUsersBuildStage = 1;
        }

        boolean inviteUsers() {
            if (this.inviteUsersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inviteUsersBuildStage == 0) {
                this.inviteUsersBuildStage = (byte)-1;
                this.inviteUsers = ImmutableChatAdminRights.this.inviteUsersInitialize();
                this.inviteUsersBuildStage = 1;
            }
            return this.inviteUsers;
        }

        void inviteUsers(boolean inviteUsers) {
            this.inviteUsers = inviteUsers;
            this.inviteUsersBuildStage = 1;
        }

        boolean pinMessages() {
            if (this.pinMessagesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pinMessagesBuildStage == 0) {
                this.pinMessagesBuildStage = (byte)-1;
                this.pinMessages = ImmutableChatAdminRights.this.pinMessagesInitialize();
                this.pinMessagesBuildStage = 1;
            }
            return this.pinMessages;
        }

        void pinMessages(boolean pinMessages) {
            this.pinMessages = pinMessages;
            this.pinMessagesBuildStage = 1;
        }

        boolean addAdmins() {
            if (this.addAdminsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.addAdminsBuildStage == 0) {
                this.addAdminsBuildStage = (byte)-1;
                this.addAdmins = ImmutableChatAdminRights.this.addAdminsInitialize();
                this.addAdminsBuildStage = 1;
            }
            return this.addAdmins;
        }

        void addAdmins(boolean addAdmins) {
            this.addAdmins = addAdmins;
            this.addAdminsBuildStage = 1;
        }

        boolean anonymous() {
            if (this.anonymousBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.anonymousBuildStage == 0) {
                this.anonymousBuildStage = (byte)-1;
                this.anonymous = ImmutableChatAdminRights.this.anonymousInitialize();
                this.anonymousBuildStage = 1;
            }
            return this.anonymous;
        }

        void anonymous(boolean anonymous) {
            this.anonymous = anonymous;
            this.anonymousBuildStage = 1;
        }

        boolean manageCall() {
            if (this.manageCallBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.manageCallBuildStage == 0) {
                this.manageCallBuildStage = (byte)-1;
                this.manageCall = ImmutableChatAdminRights.this.manageCallInitialize();
                this.manageCallBuildStage = 1;
            }
            return this.manageCall;
        }

        void manageCall(boolean manageCall) {
            this.manageCall = manageCall;
            this.manageCallBuildStage = 1;
        }

        boolean other() {
            if (this.otherBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.otherBuildStage == 0) {
                this.otherBuildStage = (byte)-1;
                this.other = ImmutableChatAdminRights.this.otherInitialize();
                this.otherBuildStage = 1;
            }
            return this.other;
        }

        void other(boolean other) {
            this.other = other;
            this.otherBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.changeInfoBuildStage == -1) {
                attributes.add("changeInfo");
            }
            if (this.postMessagesBuildStage == -1) {
                attributes.add("postMessages");
            }
            if (this.editMessagesBuildStage == -1) {
                attributes.add("editMessages");
            }
            if (this.deleteMessagesBuildStage == -1) {
                attributes.add("deleteMessages");
            }
            if (this.banUsersBuildStage == -1) {
                attributes.add("banUsers");
            }
            if (this.inviteUsersBuildStage == -1) {
                attributes.add("inviteUsers");
            }
            if (this.pinMessagesBuildStage == -1) {
                attributes.add("pinMessages");
            }
            if (this.addAdminsBuildStage == -1) {
                attributes.add("addAdmins");
            }
            if (this.anonymousBuildStage == -1) {
                attributes.add("anonymous");
            }
            if (this.manageCallBuildStage == -1) {
                attributes.add("manageCall");
            }
            if (this.otherBuildStage == -1) {
                attributes.add("other");
            }
            return "Cannot build ChatAdminRights, attribute initializers form cycle " + attributes;
        }
    }
}

