/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChatAdminWithInvites;
import telegram4j.tl.api.TlObject;

public final class ImmutableChatAdminWithInvites
implements ChatAdminWithInvites {
    private final int identifier;
    private final long adminId;
    private final int invitesCount;
    private final int revokedInvitesCount;

    private ImmutableChatAdminWithInvites(long adminId, int invitesCount, int revokedInvitesCount) {
        this.adminId = adminId;
        this.invitesCount = invitesCount;
        this.revokedInvitesCount = revokedInvitesCount;
        this.identifier = ChatAdminWithInvites.super.identifier();
    }

    private ImmutableChatAdminWithInvites(Builder builder) {
        this.adminId = builder.adminId;
        this.invitesCount = builder.invitesCount;
        this.revokedInvitesCount = builder.revokedInvitesCount;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChatAdminWithInvites.super.identifier();
    }

    private ImmutableChatAdminWithInvites(int identifier, long adminId, int invitesCount, int revokedInvitesCount) {
        this.identifier = identifier;
        this.adminId = adminId;
        this.invitesCount = invitesCount;
        this.revokedInvitesCount = revokedInvitesCount;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long adminId() {
        return this.adminId;
    }

    @Override
    public int invitesCount() {
        return this.invitesCount;
    }

    @Override
    public int revokedInvitesCount() {
        return this.revokedInvitesCount;
    }

    public final ImmutableChatAdminWithInvites withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChatAdminWithInvites(value, this.adminId, this.invitesCount, this.revokedInvitesCount);
    }

    public final ImmutableChatAdminWithInvites withAdminId(long value) {
        if (this.adminId == value) {
            return this;
        }
        return new ImmutableChatAdminWithInvites(this.identifier, value, this.invitesCount, this.revokedInvitesCount);
    }

    public final ImmutableChatAdminWithInvites withInvitesCount(int value) {
        if (this.invitesCount == value) {
            return this;
        }
        return new ImmutableChatAdminWithInvites(this.identifier, this.adminId, value, this.revokedInvitesCount);
    }

    public final ImmutableChatAdminWithInvites withRevokedInvitesCount(int value) {
        if (this.revokedInvitesCount == value) {
            return this;
        }
        return new ImmutableChatAdminWithInvites(this.identifier, this.adminId, this.invitesCount, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChatAdminWithInvites && this.equalTo(0, (ImmutableChatAdminWithInvites)another);
    }

    private boolean equalTo(int synthetic, ImmutableChatAdminWithInvites another) {
        return this.identifier == another.identifier && this.adminId == another.adminId && this.invitesCount == another.invitesCount && this.revokedInvitesCount == another.revokedInvitesCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.adminId);
        h += (h << 5) + this.invitesCount;
        h += (h << 5) + this.revokedInvitesCount;
        return h;
    }

    public String toString() {
        return "ChatAdminWithInvites{identifier=" + this.identifier + ", adminId=" + this.adminId + ", invitesCount=" + this.invitesCount + ", revokedInvitesCount=" + this.revokedInvitesCount + "}";
    }

    public static ImmutableChatAdminWithInvites of(long adminId, int invitesCount, int revokedInvitesCount) {
        return new ImmutableChatAdminWithInvites(adminId, invitesCount, revokedInvitesCount);
    }

    public static ImmutableChatAdminWithInvites copyOf(ChatAdminWithInvites instance) {
        if (instance instanceof ImmutableChatAdminWithInvites) {
            return (ImmutableChatAdminWithInvites)instance;
        }
        return ImmutableChatAdminWithInvites.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ADMIN_ID = 1L;
        private static final long INIT_BIT_INVITES_COUNT = 2L;
        private static final long INIT_BIT_REVOKED_INVITES_COUNT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long adminId;
        private int invitesCount;
        private int revokedInvitesCount;

        private Builder() {
        }

        public final Builder from(ChatAdminWithInvites instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChatAdminWithInvites instance;
            long bits = 0L;
            if (object instanceof ChatAdminWithInvites) {
                instance = (ChatAdminWithInvites)object;
                this.adminId(instance.adminId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.invitesCount(instance.invitesCount());
                this.revokedInvitesCount(instance.revokedInvitesCount());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder adminId(long adminId) {
            this.adminId = adminId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder invitesCount(int invitesCount) {
            this.invitesCount = invitesCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder revokedInvitesCount(int revokedInvitesCount) {
            this.revokedInvitesCount = revokedInvitesCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableChatAdminWithInvites build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChatAdminWithInvites(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("adminId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("invitesCount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("revokedInvitesCount");
            }
            return "Cannot build ChatAdminWithInvites, some of required attributes are not set " + attributes;
        }
    }
}

