/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.ChatForbidden;
import telegram4j.tl.api.TlObject;

public final class ImmutableChatForbidden
implements ChatForbidden {
    private final int identifier;
    private final long id;
    private final String title;

    private ImmutableChatForbidden(long id, String title) {
        this.id = id;
        this.title = Objects.requireNonNull(title, "title");
        this.identifier = ChatForbidden.super.identifier();
    }

    private ImmutableChatForbidden(Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChatForbidden.super.identifier();
    }

    private ImmutableChatForbidden(int identifier, long id, String title) {
        this.identifier = identifier;
        this.id = id;
        this.title = title;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String title() {
        return this.title;
    }

    public final ImmutableChatForbidden withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChatForbidden(value, this.id, this.title);
    }

    public final ImmutableChatForbidden withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableChatForbidden(this.identifier, value, this.title);
    }

    public final ImmutableChatForbidden withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableChatForbidden(this.identifier, this.id, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChatForbidden && this.equalTo(0, (ImmutableChatForbidden)another);
    }

    private boolean equalTo(int synthetic, ImmutableChatForbidden another) {
        return this.identifier == another.identifier && this.id == another.id && this.title.equals(another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.title.hashCode();
        return h;
    }

    public String toString() {
        return "ChatForbidden{identifier=" + this.identifier + ", id=" + this.id + ", title=" + this.title + "}";
    }

    public static ImmutableChatForbidden of(long id, String title) {
        return new ImmutableChatForbidden(id, title);
    }

    public static ImmutableChatForbidden copyOf(ChatForbidden instance) {
        if (instance instanceof ImmutableChatForbidden) {
            return (ImmutableChatForbidden)instance;
        }
        return ImmutableChatForbidden.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long id;
        private String title;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatForbidden instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Chat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChatForbidden) {
                instance = (ChatForbidden)object;
                this.title(instance.title());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof Chat) {
                instance = (Chat)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableChatForbidden build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChatForbidden(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build ChatForbidden, some of required attributes are not set " + attributes;
        }
    }
}

