/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.ChatInvite;
import telegram4j.tl.ChatInviteAlready;
import telegram4j.tl.api.TlObject;

public final class ImmutableChatInviteAlready
implements ChatInviteAlready {
    private final int identifier;
    private final Chat chat;

    private ImmutableChatInviteAlready(Chat chat) {
        this.chat = Objects.requireNonNull(chat, "chat");
        this.identifier = ChatInviteAlready.super.identifier();
    }

    private ImmutableChatInviteAlready(Builder builder) {
        this.chat = builder.chat;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChatInviteAlready.super.identifier();
    }

    private ImmutableChatInviteAlready(int identifier, Chat chat) {
        this.identifier = identifier;
        this.chat = chat;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Chat chat() {
        return this.chat;
    }

    public final ImmutableChatInviteAlready withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChatInviteAlready(value, this.chat);
    }

    public final ImmutableChatInviteAlready withChat(Chat value) {
        if (this.chat == value) {
            return this;
        }
        Chat newValue = Objects.requireNonNull(value, "chat");
        return new ImmutableChatInviteAlready(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChatInviteAlready && this.equalTo(0, (ImmutableChatInviteAlready)another);
    }

    private boolean equalTo(int synthetic, ImmutableChatInviteAlready another) {
        return this.identifier == another.identifier && this.chat.equals(another.chat);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.chat.hashCode();
        return h;
    }

    public String toString() {
        return "ChatInviteAlready{identifier=" + this.identifier + ", chat=" + this.chat + "}";
    }

    public static ImmutableChatInviteAlready of(Chat chat) {
        return new ImmutableChatInviteAlready(chat);
    }

    public static ImmutableChatInviteAlready copyOf(ChatInviteAlready instance) {
        if (instance instanceof ImmutableChatInviteAlready) {
            return (ImmutableChatInviteAlready)instance;
        }
        return ImmutableChatInviteAlready.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private Chat chat;

        private Builder() {
        }

        public final Builder from(ChatInvite instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatInviteAlready instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChatInvite instance;
            long bits = 0L;
            if (object instanceof ChatInvite) {
                instance = (ChatInvite)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChatInviteAlready) {
                instance = (ChatInviteAlready)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.chat(instance.chat());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chat(Chat chat) {
            this.chat = Objects.requireNonNull(chat, "chat");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableChatInviteAlready build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChatInviteAlready(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chat");
            }
            return "Cannot build ChatInviteAlready, some of required attributes are not set " + attributes;
        }
    }
}

