/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.ChatInviteExported;
import telegram4j.tl.ExportedChatInvite;
import telegram4j.tl.api.TlObject;

public final class ImmutableChatInviteExported
implements ChatInviteExported {
    private final int identifier;
    private final int flags;
    private final boolean revoked;
    private final boolean permanent;
    private final boolean requestNeeded;
    private final String link;
    private final long adminId;
    private final int date;
    @Nullable
    private final Integer startDate;
    @Nullable
    private final Integer expireDate;
    @Nullable
    private final Integer usageLimit;
    @Nullable
    private final Integer usage;
    @Nullable
    private final Integer requested;
    @Nullable
    private final String title;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableChatInviteExported(String link, long adminId, int date) {
        this.link = Objects.requireNonNull(link, "link");
        this.adminId = adminId;
        this.date = date;
        this.startDate = null;
        this.expireDate = null;
        this.usageLimit = null;
        this.usage = null;
        this.requested = null;
        this.title = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.revoked = this.initShim.revoked();
        this.permanent = this.initShim.permanent();
        this.requestNeeded = this.initShim.requestNeeded();
        this.initShim = null;
    }

    private ImmutableChatInviteExported(Builder builder) {
        this.link = builder.link;
        this.adminId = builder.adminId;
        this.date = builder.date;
        this.startDate = builder.startDate;
        this.expireDate = builder.expireDate;
        this.usageLimit = builder.usageLimit;
        this.usage = builder.usage;
        this.requested = builder.requested;
        this.title = builder.title;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.revokedIsSet()) {
            this.initShim.revoked(builder.revoked);
        }
        if (builder.permanentIsSet()) {
            this.initShim.permanent(builder.permanent);
        }
        if (builder.requestNeededIsSet()) {
            this.initShim.requestNeeded(builder.requestNeeded);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.revoked = this.initShim.revoked();
        this.permanent = this.initShim.permanent();
        this.requestNeeded = this.initShim.requestNeeded();
        this.initShim = null;
    }

    private ImmutableChatInviteExported(int identifier, int flags, boolean revoked, boolean permanent, boolean requestNeeded, String link, long adminId, int date, @Nullable Integer startDate, @Nullable Integer expireDate, @Nullable Integer usageLimit, @Nullable Integer usage, @Nullable Integer requested, @Nullable String title) {
        this.identifier = identifier;
        this.flags = flags;
        this.revoked = revoked;
        this.permanent = permanent;
        this.requestNeeded = requestNeeded;
        this.link = link;
        this.adminId = adminId;
        this.date = date;
        this.startDate = startDate;
        this.expireDate = expireDate;
        this.usageLimit = usageLimit;
        this.usage = usage;
        this.requested = requested;
        this.title = title;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ChatInviteExported.super.identifier();
    }

    private int flagsInitialize() {
        return ChatInviteExported.super.flags();
    }

    private boolean revokedInitialize() {
        return ChatInviteExported.super.revoked();
    }

    private boolean permanentInitialize() {
        return ChatInviteExported.super.permanent();
    }

    private boolean requestNeededInitialize() {
        return ChatInviteExported.super.requestNeeded();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean revoked() {
        InitShim shim = this.initShim;
        return shim != null ? shim.revoked() : this.revoked;
    }

    @Override
    public boolean permanent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.permanent() : this.permanent;
    }

    @Override
    public boolean requestNeeded() {
        InitShim shim = this.initShim;
        return shim != null ? shim.requestNeeded() : this.requestNeeded;
    }

    @Override
    public String link() {
        return this.link;
    }

    @Override
    public long adminId() {
        return this.adminId;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    @Nullable
    public Integer startDate() {
        return this.startDate;
    }

    @Override
    @Nullable
    public Integer expireDate() {
        return this.expireDate;
    }

    @Override
    @Nullable
    public Integer usageLimit() {
        return this.usageLimit;
    }

    @Override
    @Nullable
    public Integer usage() {
        return this.usage;
    }

    @Override
    @Nullable
    public Integer requested() {
        return this.requested;
    }

    @Override
    @Nullable
    public String title() {
        return this.title;
    }

    public final ImmutableChatInviteExported withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChatInviteExported(value, this.flags, this.revoked, this.permanent, this.requestNeeded, this.link, this.adminId, this.date, this.startDate, this.expireDate, this.usageLimit, this.usage, this.requested, this.title);
    }

    public final ImmutableChatInviteExported withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableChatInviteExported(this.identifier, value, this.revoked, this.permanent, this.requestNeeded, this.link, this.adminId, this.date, this.startDate, this.expireDate, this.usageLimit, this.usage, this.requested, this.title);
    }

    public final ImmutableChatInviteExported withRevoked(boolean value) {
        if (this.revoked == value) {
            return this;
        }
        return new ImmutableChatInviteExported(this.identifier, this.flags, value, this.permanent, this.requestNeeded, this.link, this.adminId, this.date, this.startDate, this.expireDate, this.usageLimit, this.usage, this.requested, this.title);
    }

    public final ImmutableChatInviteExported withPermanent(boolean value) {
        if (this.permanent == value) {
            return this;
        }
        return new ImmutableChatInviteExported(this.identifier, this.flags, this.revoked, value, this.requestNeeded, this.link, this.adminId, this.date, this.startDate, this.expireDate, this.usageLimit, this.usage, this.requested, this.title);
    }

    public final ImmutableChatInviteExported withRequestNeeded(boolean value) {
        if (this.requestNeeded == value) {
            return this;
        }
        return new ImmutableChatInviteExported(this.identifier, this.flags, this.revoked, this.permanent, value, this.link, this.adminId, this.date, this.startDate, this.expireDate, this.usageLimit, this.usage, this.requested, this.title);
    }

    public final ImmutableChatInviteExported withLink(String value) {
        String newValue = Objects.requireNonNull(value, "link");
        if (this.link.equals(newValue)) {
            return this;
        }
        return new ImmutableChatInviteExported(this.identifier, this.flags, this.revoked, this.permanent, this.requestNeeded, newValue, this.adminId, this.date, this.startDate, this.expireDate, this.usageLimit, this.usage, this.requested, this.title);
    }

    public final ImmutableChatInviteExported withAdminId(long value) {
        if (this.adminId == value) {
            return this;
        }
        return new ImmutableChatInviteExported(this.identifier, this.flags, this.revoked, this.permanent, this.requestNeeded, this.link, value, this.date, this.startDate, this.expireDate, this.usageLimit, this.usage, this.requested, this.title);
    }

    public final ImmutableChatInviteExported withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableChatInviteExported(this.identifier, this.flags, this.revoked, this.permanent, this.requestNeeded, this.link, this.adminId, value, this.startDate, this.expireDate, this.usageLimit, this.usage, this.requested, this.title);
    }

    public final ImmutableChatInviteExported withStartDate(@Nullable Integer value) {
        if (Objects.equals(this.startDate, value)) {
            return this;
        }
        return new ImmutableChatInviteExported(this.identifier, this.flags, this.revoked, this.permanent, this.requestNeeded, this.link, this.adminId, this.date, value, this.expireDate, this.usageLimit, this.usage, this.requested, this.title);
    }

    public final ImmutableChatInviteExported withExpireDate(@Nullable Integer value) {
        if (Objects.equals(this.expireDate, value)) {
            return this;
        }
        return new ImmutableChatInviteExported(this.identifier, this.flags, this.revoked, this.permanent, this.requestNeeded, this.link, this.adminId, this.date, this.startDate, value, this.usageLimit, this.usage, this.requested, this.title);
    }

    public final ImmutableChatInviteExported withUsageLimit(@Nullable Integer value) {
        if (Objects.equals(this.usageLimit, value)) {
            return this;
        }
        return new ImmutableChatInviteExported(this.identifier, this.flags, this.revoked, this.permanent, this.requestNeeded, this.link, this.adminId, this.date, this.startDate, this.expireDate, value, this.usage, this.requested, this.title);
    }

    public final ImmutableChatInviteExported withUsage(@Nullable Integer value) {
        if (Objects.equals(this.usage, value)) {
            return this;
        }
        return new ImmutableChatInviteExported(this.identifier, this.flags, this.revoked, this.permanent, this.requestNeeded, this.link, this.adminId, this.date, this.startDate, this.expireDate, this.usageLimit, value, this.requested, this.title);
    }

    public final ImmutableChatInviteExported withRequested(@Nullable Integer value) {
        if (Objects.equals(this.requested, value)) {
            return this;
        }
        return new ImmutableChatInviteExported(this.identifier, this.flags, this.revoked, this.permanent, this.requestNeeded, this.link, this.adminId, this.date, this.startDate, this.expireDate, this.usageLimit, this.usage, value, this.title);
    }

    public final ImmutableChatInviteExported withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableChatInviteExported(this.identifier, this.flags, this.revoked, this.permanent, this.requestNeeded, this.link, this.adminId, this.date, this.startDate, this.expireDate, this.usageLimit, this.usage, this.requested, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChatInviteExported && this.equalTo(0, (ImmutableChatInviteExported)another);
    }

    private boolean equalTo(int synthetic, ImmutableChatInviteExported another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.revoked == another.revoked && this.permanent == another.permanent && this.requestNeeded == another.requestNeeded && this.link.equals(another.link) && this.adminId == another.adminId && this.date == another.date && Objects.equals(this.startDate, another.startDate) && Objects.equals(this.expireDate, another.expireDate) && Objects.equals(this.usageLimit, another.usageLimit) && Objects.equals(this.usage, another.usage) && Objects.equals(this.requested, another.requested) && Objects.equals(this.title, another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.revoked);
        h += (h << 5) + Boolean.hashCode(this.permanent);
        h += (h << 5) + Boolean.hashCode(this.requestNeeded);
        h += (h << 5) + this.link.hashCode();
        h += (h << 5) + Long.hashCode(this.adminId);
        h += (h << 5) + this.date;
        h += (h << 5) + Objects.hashCode(this.startDate);
        h += (h << 5) + Objects.hashCode(this.expireDate);
        h += (h << 5) + Objects.hashCode(this.usageLimit);
        h += (h << 5) + Objects.hashCode(this.usage);
        h += (h << 5) + Objects.hashCode(this.requested);
        h += (h << 5) + Objects.hashCode(this.title);
        return h;
    }

    public String toString() {
        return "ChatInviteExported{identifier=" + this.identifier + ", flags=" + this.flags + ", revoked=" + this.revoked + ", permanent=" + this.permanent + ", requestNeeded=" + this.requestNeeded + ", link=" + this.link + ", adminId=" + this.adminId + ", date=" + this.date + ", startDate=" + this.startDate + ", expireDate=" + this.expireDate + ", usageLimit=" + this.usageLimit + ", usage=" + this.usage + ", requested=" + this.requested + ", title=" + this.title + "}";
    }

    public static ImmutableChatInviteExported of(String link, long adminId, int date) {
        return new ImmutableChatInviteExported(link, adminId, date);
    }

    public static ImmutableChatInviteExported copyOf(ChatInviteExported instance) {
        if (instance instanceof ImmutableChatInviteExported) {
            return (ImmutableChatInviteExported)instance;
        }
        return ImmutableChatInviteExported.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LINK = 1L;
        private static final long INIT_BIT_ADMIN_ID = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_REVOKED = 4L;
        private static final long OPT_BIT_PERMANENT = 8L;
        private static final long OPT_BIT_REQUEST_NEEDED = 16L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean revoked;
        private boolean permanent;
        private boolean requestNeeded;
        private String link;
        private long adminId;
        private int date;
        private Integer startDate;
        private Integer expireDate;
        private Integer usageLimit;
        private Integer usage;
        private Integer requested;
        private String title;

        private Builder() {
        }

        public final Builder from(ChatInviteExported instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ExportedChatInvite instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ExportedChatInvite instance;
            long bits = 0L;
            if (object instanceof ChatInviteExported) {
                Integer startDateValue;
                Integer requestedValue;
                Integer usageValue;
                instance = (ChatInviteExported)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.requestNeeded(instance.requestNeeded());
                Integer usageLimitValue = instance.usageLimit();
                if (usageLimitValue != null) {
                    this.usageLimit(usageLimitValue);
                }
                if ((usageValue = instance.usage()) != null) {
                    this.usage(usageValue);
                }
                this.flags(instance.flags());
                this.link(instance.link());
                this.revoked(instance.revoked());
                String titleValue = instance.title();
                if (titleValue != null) {
                    this.title(titleValue);
                }
                if ((requestedValue = instance.requested()) != null) {
                    this.requested(requestedValue);
                }
                this.permanent(instance.permanent());
                this.adminId(instance.adminId());
                Integer expireDateValue = instance.expireDate();
                if (expireDateValue != null) {
                    this.expireDate(expireDateValue);
                }
                if ((startDateValue = instance.startDate()) != null) {
                    this.startDate(startDateValue);
                }
            }
            if (object instanceof ExportedChatInvite) {
                instance = (ExportedChatInvite)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder revoked(boolean revoked) {
            this.revoked = revoked;
            this.optBits |= 4L;
            return this;
        }

        public final Builder permanent(boolean permanent) {
            this.permanent = permanent;
            this.optBits |= 8L;
            return this;
        }

        public final Builder requestNeeded(boolean requestNeeded) {
            this.requestNeeded = requestNeeded;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder link(String link) {
            this.link = Objects.requireNonNull(link, "link");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder adminId(long adminId) {
            this.adminId = adminId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder startDate(@Nullable Integer startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Builder expireDate(@Nullable Integer expireDate) {
            this.expireDate = expireDate;
            return this;
        }

        public final Builder usageLimit(@Nullable Integer usageLimit) {
            this.usageLimit = usageLimit;
            return this;
        }

        public final Builder usage(@Nullable Integer usage) {
            this.usage = usage;
            return this;
        }

        public final Builder requested(@Nullable Integer requested) {
            this.requested = requested;
            return this;
        }

        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public ImmutableChatInviteExported build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChatInviteExported(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean revokedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean permanentIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean requestNeededIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("link");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("adminId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build ChatInviteExported, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte revokedBuildStage = 0;
        private boolean revoked;
        private byte permanentBuildStage = 0;
        private boolean permanent;
        private byte requestNeededBuildStage = 0;
        private boolean requestNeeded;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChatInviteExported.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChatInviteExported.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean revoked() {
            if (this.revokedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revokedBuildStage == 0) {
                this.revokedBuildStage = (byte)-1;
                this.revoked = ImmutableChatInviteExported.this.revokedInitialize();
                this.revokedBuildStage = 1;
            }
            return this.revoked;
        }

        void revoked(boolean revoked) {
            this.revoked = revoked;
            this.revokedBuildStage = 1;
        }

        boolean permanent() {
            if (this.permanentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.permanentBuildStage == 0) {
                this.permanentBuildStage = (byte)-1;
                this.permanent = ImmutableChatInviteExported.this.permanentInitialize();
                this.permanentBuildStage = 1;
            }
            return this.permanent;
        }

        void permanent(boolean permanent) {
            this.permanent = permanent;
            this.permanentBuildStage = 1;
        }

        boolean requestNeeded() {
            if (this.requestNeededBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requestNeededBuildStage == 0) {
                this.requestNeededBuildStage = (byte)-1;
                this.requestNeeded = ImmutableChatInviteExported.this.requestNeededInitialize();
                this.requestNeededBuildStage = 1;
            }
            return this.requestNeeded;
        }

        void requestNeeded(boolean requestNeeded) {
            this.requestNeeded = requestNeeded;
            this.requestNeededBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.revokedBuildStage == -1) {
                attributes.add("revoked");
            }
            if (this.permanentBuildStage == -1) {
                attributes.add("permanent");
            }
            if (this.requestNeededBuildStage == -1) {
                attributes.add("requestNeeded");
            }
            return "Cannot build ChatInviteExported, attribute initializers form cycle " + attributes;
        }
    }
}

