/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.ChatInviteImporter;
import telegram4j.tl.api.TlObject;

public final class ImmutableChatInviteImporter
implements ChatInviteImporter {
    private final int identifier;
    private final int flags;
    private final boolean requested;
    private final long userId;
    private final int date;
    @Nullable
    private final String about;
    @Nullable
    private final Long approvedBy;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableChatInviteImporter(long userId, int date) {
        this.userId = userId;
        this.date = date;
        this.about = null;
        this.approvedBy = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.requested = this.initShim.requested();
        this.initShim = null;
    }

    private ImmutableChatInviteImporter(Builder builder) {
        this.userId = builder.userId;
        this.date = builder.date;
        this.about = builder.about;
        this.approvedBy = builder.approvedBy;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.requestedIsSet()) {
            this.initShim.requested(builder.requested);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.requested = this.initShim.requested();
        this.initShim = null;
    }

    private ImmutableChatInviteImporter(int identifier, int flags, boolean requested, long userId, int date, @Nullable String about, @Nullable Long approvedBy) {
        this.identifier = identifier;
        this.flags = flags;
        this.requested = requested;
        this.userId = userId;
        this.date = date;
        this.about = about;
        this.approvedBy = approvedBy;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ChatInviteImporter.super.identifier();
    }

    private int flagsInitialize() {
        return ChatInviteImporter.super.flags();
    }

    private boolean requestedInitialize() {
        return ChatInviteImporter.super.requested();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean requested() {
        InitShim shim = this.initShim;
        return shim != null ? shim.requested() : this.requested;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    @Nullable
    public String about() {
        return this.about;
    }

    @Override
    @Nullable
    public Long approvedBy() {
        return this.approvedBy;
    }

    public final ImmutableChatInviteImporter withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChatInviteImporter(value, this.flags, this.requested, this.userId, this.date, this.about, this.approvedBy);
    }

    public final ImmutableChatInviteImporter withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableChatInviteImporter(this.identifier, value, this.requested, this.userId, this.date, this.about, this.approvedBy);
    }

    public final ImmutableChatInviteImporter withRequested(boolean value) {
        if (this.requested == value) {
            return this;
        }
        return new ImmutableChatInviteImporter(this.identifier, this.flags, value, this.userId, this.date, this.about, this.approvedBy);
    }

    public final ImmutableChatInviteImporter withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableChatInviteImporter(this.identifier, this.flags, this.requested, value, this.date, this.about, this.approvedBy);
    }

    public final ImmutableChatInviteImporter withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableChatInviteImporter(this.identifier, this.flags, this.requested, this.userId, value, this.about, this.approvedBy);
    }

    public final ImmutableChatInviteImporter withAbout(@Nullable String value) {
        if (Objects.equals(this.about, value)) {
            return this;
        }
        return new ImmutableChatInviteImporter(this.identifier, this.flags, this.requested, this.userId, this.date, value, this.approvedBy);
    }

    public final ImmutableChatInviteImporter withApprovedBy(@Nullable Long value) {
        if (Objects.equals(this.approvedBy, value)) {
            return this;
        }
        return new ImmutableChatInviteImporter(this.identifier, this.flags, this.requested, this.userId, this.date, this.about, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChatInviteImporter && this.equalTo(0, (ImmutableChatInviteImporter)another);
    }

    private boolean equalTo(int synthetic, ImmutableChatInviteImporter another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.requested == another.requested && this.userId == another.userId && this.date == another.date && Objects.equals(this.about, another.about) && Objects.equals(this.approvedBy, another.approvedBy);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.requested);
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.date;
        h += (h << 5) + Objects.hashCode(this.about);
        h += (h << 5) + Objects.hashCode(this.approvedBy);
        return h;
    }

    public String toString() {
        return "ChatInviteImporter{identifier=" + this.identifier + ", flags=" + this.flags + ", requested=" + this.requested + ", userId=" + this.userId + ", date=" + this.date + ", about=" + this.about + ", approvedBy=" + this.approvedBy + "}";
    }

    public static ImmutableChatInviteImporter of(long userId, int date) {
        return new ImmutableChatInviteImporter(userId, date);
    }

    public static ImmutableChatInviteImporter copyOf(ChatInviteImporter instance) {
        if (instance instanceof ImmutableChatInviteImporter) {
            return (ImmutableChatInviteImporter)instance;
        }
        return ImmutableChatInviteImporter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_REQUESTED = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean requested;
        private long userId;
        private int date;
        private String about;
        private Long approvedBy;

        private Builder() {
        }

        public final Builder from(ChatInviteImporter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChatInviteImporter instance;
            long bits = 0L;
            if (object instanceof ChatInviteImporter) {
                Long approvedByValue;
                instance = (ChatInviteImporter)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.requested(instance.requested());
                this.flags(instance.flags());
                String aboutValue = instance.about();
                if (aboutValue != null) {
                    this.about(aboutValue);
                }
                if ((approvedByValue = instance.approvedBy()) != null) {
                    this.approvedBy(approvedByValue);
                }
                this.userId(instance.userId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder requested(boolean requested) {
            this.requested = requested;
            this.optBits |= 4L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder about(@Nullable String about) {
            this.about = about;
            return this;
        }

        public final Builder approvedBy(@Nullable Long approvedBy) {
            this.approvedBy = approvedBy;
            return this;
        }

        public ImmutableChatInviteImporter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChatInviteImporter(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean requestedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build ChatInviteImporter, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte requestedBuildStage = 0;
        private boolean requested;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChatInviteImporter.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChatInviteImporter.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean requested() {
            if (this.requestedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requestedBuildStage == 0) {
                this.requestedBuildStage = (byte)-1;
                this.requested = ImmutableChatInviteImporter.this.requestedInitialize();
                this.requestedBuildStage = 1;
            }
            return this.requested;
        }

        void requested(boolean requested) {
            this.requested = requested;
            this.requestedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.requestedBuildStage == -1) {
                attributes.add("requested");
            }
            return "Cannot build ChatInviteImporter, attribute initializers form cycle " + attributes;
        }
    }
}

