/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.ChatInvite;
import telegram4j.tl.ChatInvitePeek;
import telegram4j.tl.api.TlObject;

public final class ImmutableChatInvitePeek
implements ChatInvitePeek {
    private final int identifier;
    private final Chat chat;
    private final int expires;

    private ImmutableChatInvitePeek(Chat chat, int expires) {
        this.chat = Objects.requireNonNull(chat, "chat");
        this.expires = expires;
        this.identifier = ChatInvitePeek.super.identifier();
    }

    private ImmutableChatInvitePeek(Builder builder) {
        this.chat = builder.chat;
        this.expires = builder.expires;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChatInvitePeek.super.identifier();
    }

    private ImmutableChatInvitePeek(int identifier, Chat chat, int expires) {
        this.identifier = identifier;
        this.chat = chat;
        this.expires = expires;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Chat chat() {
        return this.chat;
    }

    @Override
    public int expires() {
        return this.expires;
    }

    public final ImmutableChatInvitePeek withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChatInvitePeek(value, this.chat, this.expires);
    }

    public final ImmutableChatInvitePeek withChat(Chat value) {
        if (this.chat == value) {
            return this;
        }
        Chat newValue = Objects.requireNonNull(value, "chat");
        return new ImmutableChatInvitePeek(this.identifier, newValue, this.expires);
    }

    public final ImmutableChatInvitePeek withExpires(int value) {
        if (this.expires == value) {
            return this;
        }
        return new ImmutableChatInvitePeek(this.identifier, this.chat, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChatInvitePeek && this.equalTo(0, (ImmutableChatInvitePeek)another);
    }

    private boolean equalTo(int synthetic, ImmutableChatInvitePeek another) {
        return this.identifier == another.identifier && this.chat.equals(another.chat) && this.expires == another.expires;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.chat.hashCode();
        h += (h << 5) + this.expires;
        return h;
    }

    public String toString() {
        return "ChatInvitePeek{identifier=" + this.identifier + ", chat=" + this.chat + ", expires=" + this.expires + "}";
    }

    public static ImmutableChatInvitePeek of(Chat chat, int expires) {
        return new ImmutableChatInvitePeek(chat, expires);
    }

    public static ImmutableChatInvitePeek copyOf(ChatInvitePeek instance) {
        if (instance instanceof ImmutableChatInvitePeek) {
            return (ImmutableChatInvitePeek)instance;
        }
        return ImmutableChatInvitePeek.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT = 1L;
        private static final long INIT_BIT_EXPIRES = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private Chat chat;
        private int expires;

        private Builder() {
        }

        public final Builder from(ChatInvite instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatInvitePeek instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChatInvite instance;
            long bits = 0L;
            if (object instanceof ChatInvite) {
                instance = (ChatInvite)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChatInvitePeek) {
                instance = (ChatInvitePeek)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.expires(instance.expires());
                this.chat(instance.chat());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder chat(Chat chat) {
            this.chat = Objects.requireNonNull(chat, "chat");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder expires(int expires) {
            this.expires = expires;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableChatInvitePeek build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChatInvitePeek(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chat");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expires");
            }
            return "Cannot build ChatInvitePeek, some of required attributes are not set " + attributes;
        }
    }
}

