/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChatOnlines;
import telegram4j.tl.api.TlObject;

public final class ImmutableChatOnlines
implements ChatOnlines {
    private final int identifier;
    private final int onlines;

    private ImmutableChatOnlines(int onlines) {
        this.onlines = onlines;
        this.identifier = ChatOnlines.super.identifier();
    }

    private ImmutableChatOnlines(Builder builder) {
        this.onlines = builder.onlines;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChatOnlines.super.identifier();
    }

    private ImmutableChatOnlines(int identifier, int onlines) {
        this.identifier = identifier;
        this.onlines = onlines;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int onlines() {
        return this.onlines;
    }

    public final ImmutableChatOnlines withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChatOnlines(value, this.onlines);
    }

    public final ImmutableChatOnlines withOnlines(int value) {
        if (this.onlines == value) {
            return this;
        }
        return new ImmutableChatOnlines(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChatOnlines && this.equalTo(0, (ImmutableChatOnlines)another);
    }

    private boolean equalTo(int synthetic, ImmutableChatOnlines another) {
        return this.identifier == another.identifier && this.onlines == another.onlines;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.onlines;
        return h;
    }

    public String toString() {
        return "ChatOnlines{identifier=" + this.identifier + ", onlines=" + this.onlines + "}";
    }

    public static ImmutableChatOnlines of(int onlines) {
        return new ImmutableChatOnlines(onlines);
    }

    public static ImmutableChatOnlines copyOf(ChatOnlines instance) {
        if (instance instanceof ImmutableChatOnlines) {
            return (ImmutableChatOnlines)instance;
        }
        return ImmutableChatOnlines.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ONLINES = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int onlines;

        private Builder() {
        }

        public final Builder from(ChatOnlines instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChatOnlines instance;
            long bits = 0L;
            if (object instanceof ChatOnlines) {
                instance = (ChatOnlines)object;
                this.onlines(instance.onlines());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder onlines(int onlines) {
            this.onlines = onlines;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableChatOnlines build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChatOnlines(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("onlines");
            }
            return "Cannot build ChatOnlines, some of required attributes are not set " + attributes;
        }
    }
}

