/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChatParticipant;
import telegram4j.tl.ChatParticipantAdmin;
import telegram4j.tl.api.TlObject;

public final class ImmutableChatParticipantAdmin
implements ChatParticipantAdmin {
    private final int identifier;
    private final long userId;
    private final long inviterId;
    private final int date;

    private ImmutableChatParticipantAdmin(long userId, long inviterId, int date) {
        this.userId = userId;
        this.inviterId = inviterId;
        this.date = date;
        this.identifier = ChatParticipantAdmin.super.identifier();
    }

    private ImmutableChatParticipantAdmin(Builder builder) {
        this.userId = builder.userId;
        this.inviterId = builder.inviterId;
        this.date = builder.date;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChatParticipantAdmin.super.identifier();
    }

    private ImmutableChatParticipantAdmin(int identifier, long userId, long inviterId, int date) {
        this.identifier = identifier;
        this.userId = userId;
        this.inviterId = inviterId;
        this.date = date;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public long inviterId() {
        return this.inviterId;
    }

    @Override
    public int date() {
        return this.date;
    }

    public final ImmutableChatParticipantAdmin withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChatParticipantAdmin(value, this.userId, this.inviterId, this.date);
    }

    public final ImmutableChatParticipantAdmin withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableChatParticipantAdmin(this.identifier, value, this.inviterId, this.date);
    }

    public final ImmutableChatParticipantAdmin withInviterId(long value) {
        if (this.inviterId == value) {
            return this;
        }
        return new ImmutableChatParticipantAdmin(this.identifier, this.userId, value, this.date);
    }

    public final ImmutableChatParticipantAdmin withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableChatParticipantAdmin(this.identifier, this.userId, this.inviterId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChatParticipantAdmin && this.equalTo(0, (ImmutableChatParticipantAdmin)another);
    }

    private boolean equalTo(int synthetic, ImmutableChatParticipantAdmin another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.inviterId == another.inviterId && this.date == another.date;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + Long.hashCode(this.inviterId);
        h += (h << 5) + this.date;
        return h;
    }

    public String toString() {
        return "ChatParticipantAdmin{identifier=" + this.identifier + ", userId=" + this.userId + ", inviterId=" + this.inviterId + ", date=" + this.date + "}";
    }

    public static ImmutableChatParticipantAdmin of(long userId, long inviterId, int date) {
        return new ImmutableChatParticipantAdmin(userId, inviterId, date);
    }

    public static ImmutableChatParticipantAdmin copyOf(ChatParticipantAdmin instance) {
        if (instance instanceof ImmutableChatParticipantAdmin) {
            return (ImmutableChatParticipantAdmin)instance;
        }
        return ImmutableChatParticipantAdmin.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_INVITER_ID = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long userId;
        private long inviterId;
        private int date;

        private Builder() {
        }

        public final Builder from(ChatParticipantAdmin instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatParticipant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChatParticipant instance;
            long bits = 0L;
            if (object instanceof ChatParticipantAdmin) {
                instance = (ChatParticipantAdmin)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.inviterId(instance.inviterId());
                if ((bits & 2L) == 0L) {
                    this.userId(instance.userId());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChatParticipant) {
                instance = (ChatParticipant)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.userId(instance.userId());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder inviterId(long inviterId) {
            this.inviterId = inviterId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableChatParticipantAdmin build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChatParticipantAdmin(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("inviterId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build ChatParticipantAdmin, some of required attributes are not set " + attributes;
        }
    }
}

