/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChatParticipant;
import telegram4j.tl.ChatParticipantCreator;
import telegram4j.tl.api.TlObject;

public final class ImmutableChatParticipantCreator
implements ChatParticipantCreator {
    private final int identifier;
    private final long userId;

    private ImmutableChatParticipantCreator(long userId) {
        this.userId = userId;
        this.identifier = ChatParticipantCreator.super.identifier();
    }

    private ImmutableChatParticipantCreator(Builder builder) {
        this.userId = builder.userId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChatParticipantCreator.super.identifier();
    }

    private ImmutableChatParticipantCreator(int identifier, long userId) {
        this.identifier = identifier;
        this.userId = userId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    public final ImmutableChatParticipantCreator withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChatParticipantCreator(value, this.userId);
    }

    public final ImmutableChatParticipantCreator withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableChatParticipantCreator(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChatParticipantCreator && this.equalTo(0, (ImmutableChatParticipantCreator)another);
    }

    private boolean equalTo(int synthetic, ImmutableChatParticipantCreator another) {
        return this.identifier == another.identifier && this.userId == another.userId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        return h;
    }

    public String toString() {
        return "ChatParticipantCreator{identifier=" + this.identifier + ", userId=" + this.userId + "}";
    }

    public static ImmutableChatParticipantCreator of(long userId) {
        return new ImmutableChatParticipantCreator(userId);
    }

    public static ImmutableChatParticipantCreator copyOf(ChatParticipantCreator instance) {
        if (instance instanceof ImmutableChatParticipantCreator) {
            return (ImmutableChatParticipantCreator)instance;
        }
        return ImmutableChatParticipantCreator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long userId;

        private Builder() {
        }

        public final Builder from(ChatParticipantCreator instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatParticipant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChatParticipant instance;
            long bits = 0L;
            if (object instanceof ChatParticipantCreator) {
                instance = (ChatParticipantCreator)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.userId(instance.userId());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChatParticipant) {
                instance = (ChatParticipant)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.userId(instance.userId());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableChatParticipantCreator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChatParticipantCreator(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build ChatParticipantCreator, some of required attributes are not set " + attributes;
        }
    }
}

