/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.ChatParticipant;
import telegram4j.tl.ChatParticipants;
import telegram4j.tl.ChatParticipantsForbidden;
import telegram4j.tl.api.TlObject;

public final class ImmutableChatParticipantsForbidden
implements ChatParticipantsForbidden {
    private final int identifier;
    private final int flags;
    private final long chatId;
    @Nullable
    private final ChatParticipant selfParticipant;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableChatParticipantsForbidden(long chatId) {
        this.chatId = chatId;
        this.selfParticipant = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableChatParticipantsForbidden(Builder builder) {
        this.chatId = builder.chatId;
        this.selfParticipant = builder.selfParticipant;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableChatParticipantsForbidden(int identifier, int flags, long chatId, @Nullable ChatParticipant selfParticipant) {
        this.identifier = identifier;
        this.flags = flags;
        this.chatId = chatId;
        this.selfParticipant = selfParticipant;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ChatParticipantsForbidden.super.identifier();
    }

    private int flagsInitialize() {
        return ChatParticipantsForbidden.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long chatId() {
        return this.chatId;
    }

    @Override
    @Nullable
    public ChatParticipant selfParticipant() {
        return this.selfParticipant;
    }

    public final ImmutableChatParticipantsForbidden withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChatParticipantsForbidden(value, this.flags, this.chatId, this.selfParticipant);
    }

    public final ImmutableChatParticipantsForbidden withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableChatParticipantsForbidden(this.identifier, value, this.chatId, this.selfParticipant);
    }

    public final ImmutableChatParticipantsForbidden withChatId(long value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableChatParticipantsForbidden(this.identifier, this.flags, value, this.selfParticipant);
    }

    public final ImmutableChatParticipantsForbidden withSelfParticipant(@Nullable ChatParticipant value) {
        if (this.selfParticipant == value) {
            return this;
        }
        return new ImmutableChatParticipantsForbidden(this.identifier, this.flags, this.chatId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChatParticipantsForbidden && this.equalTo(0, (ImmutableChatParticipantsForbidden)another);
    }

    private boolean equalTo(int synthetic, ImmutableChatParticipantsForbidden another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.chatId == another.chatId && Objects.equals(this.selfParticipant, another.selfParticipant);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.chatId);
        h += (h << 5) + Objects.hashCode(this.selfParticipant);
        return h;
    }

    public String toString() {
        return "ChatParticipantsForbidden{identifier=" + this.identifier + ", flags=" + this.flags + ", chatId=" + this.chatId + ", selfParticipant=" + this.selfParticipant + "}";
    }

    public static ImmutableChatParticipantsForbidden of(long chatId) {
        return new ImmutableChatParticipantsForbidden(chatId);
    }

    public static ImmutableChatParticipantsForbidden copyOf(ChatParticipantsForbidden instance) {
        if (instance instanceof ImmutableChatParticipantsForbidden) {
            return (ImmutableChatParticipantsForbidden)instance;
        }
        return ImmutableChatParticipantsForbidden.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHAT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private long chatId;
        private ChatParticipant selfParticipant;

        private Builder() {
        }

        public final Builder from(ChatParticipants instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatParticipantsForbidden instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChatParticipants instance;
            long bits = 0L;
            if (object instanceof ChatParticipants) {
                instance = (ChatParticipants)object;
                if ((bits & 2L) == 0L) {
                    this.chatId(instance.chatId());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChatParticipantsForbidden) {
                instance = (ChatParticipantsForbidden)object;
                ChatParticipant selfParticipantValue = instance.selfParticipant();
                if (selfParticipantValue != null) {
                    this.selfParticipant(selfParticipantValue);
                }
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.chatId(instance.chatId());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder chatId(long chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder selfParticipant(@Nullable ChatParticipant selfParticipant) {
            this.selfParticipant = selfParticipant;
            return this;
        }

        public ImmutableChatParticipantsForbidden build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChatParticipantsForbidden(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chatId");
            }
            return "Cannot build ChatParticipantsForbidden, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChatParticipantsForbidden.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChatParticipantsForbidden.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build ChatParticipantsForbidden, attribute initializers form cycle " + attributes;
        }
    }
}

