/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import reactor.util.annotation.Nullable;
import telegram4j.tl.CodeSettings;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableCodeSettings
implements CodeSettings {
    private final int identifier;
    private final int flags;
    private final boolean allowFlashcall;
    private final boolean currentNumber;
    private final boolean allowAppHash;
    private final boolean allowMissedCall;
    private final List<ByteBuf> logoutTokens;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableCodeSettings INSTANCE = ImmutableCodeSettings.validate(new ImmutableCodeSettings());

    private ImmutableCodeSettings() {
        this.logoutTokens = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.allowFlashcall = this.initShim.allowFlashcall();
        this.currentNumber = this.initShim.currentNumber();
        this.allowAppHash = this.initShim.allowAppHash();
        this.allowMissedCall = this.initShim.allowMissedCall();
        this.initShim = null;
    }

    private ImmutableCodeSettings(Builder builder) {
        this.logoutTokens = builder.logoutTokens_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.allowFlashcallIsSet()) {
            this.initShim.allowFlashcall(builder.allowFlashcall);
        }
        if (builder.currentNumberIsSet()) {
            this.initShim.currentNumber(builder.currentNumber);
        }
        if (builder.allowAppHashIsSet()) {
            this.initShim.allowAppHash(builder.allowAppHash);
        }
        if (builder.allowMissedCallIsSet()) {
            this.initShim.allowMissedCall(builder.allowMissedCall);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.allowFlashcall = this.initShim.allowFlashcall();
        this.currentNumber = this.initShim.currentNumber();
        this.allowAppHash = this.initShim.allowAppHash();
        this.allowMissedCall = this.initShim.allowMissedCall();
        this.initShim = null;
    }

    private ImmutableCodeSettings(int identifier, int flags, boolean allowFlashcall, boolean currentNumber, boolean allowAppHash, boolean allowMissedCall, List<ByteBuf> logoutTokens) {
        this.identifier = identifier;
        this.flags = flags;
        this.allowFlashcall = allowFlashcall;
        this.currentNumber = currentNumber;
        this.allowAppHash = allowAppHash;
        this.allowMissedCall = allowMissedCall;
        this.logoutTokens = logoutTokens;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return CodeSettings.super.identifier();
    }

    private int flagsInitialize() {
        return CodeSettings.super.flags();
    }

    private boolean allowFlashcallInitialize() {
        return CodeSettings.super.allowFlashcall();
    }

    private boolean currentNumberInitialize() {
        return CodeSettings.super.currentNumber();
    }

    private boolean allowAppHashInitialize() {
        return CodeSettings.super.allowAppHash();
    }

    private boolean allowMissedCallInitialize() {
        return CodeSettings.super.allowMissedCall();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean allowFlashcall() {
        InitShim shim = this.initShim;
        return shim != null ? shim.allowFlashcall() : this.allowFlashcall;
    }

    @Override
    public boolean currentNumber() {
        InitShim shim = this.initShim;
        return shim != null ? shim.currentNumber() : this.currentNumber;
    }

    @Override
    public boolean allowAppHash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.allowAppHash() : this.allowAppHash;
    }

    @Override
    public boolean allowMissedCall() {
        InitShim shim = this.initShim;
        return shim != null ? shim.allowMissedCall() : this.allowMissedCall;
    }

    @Override
    public Optional<List<ByteBuf>> logoutTokens() {
        return Optional.ofNullable(this.logoutTokens).map(l -> l.stream().map(ByteBuf::duplicate).collect(Collectors.toList()));
    }

    public final ImmutableCodeSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableCodeSettings.validate(new ImmutableCodeSettings(value, this.flags, this.allowFlashcall, this.currentNumber, this.allowAppHash, this.allowMissedCall, this.logoutTokens));
    }

    public final ImmutableCodeSettings withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableCodeSettings.validate(new ImmutableCodeSettings(this.identifier, value, this.allowFlashcall, this.currentNumber, this.allowAppHash, this.allowMissedCall, this.logoutTokens));
    }

    public final ImmutableCodeSettings withAllowFlashcall(boolean value) {
        if (this.allowFlashcall == value) {
            return this;
        }
        return ImmutableCodeSettings.validate(new ImmutableCodeSettings(this.identifier, this.flags, value, this.currentNumber, this.allowAppHash, this.allowMissedCall, this.logoutTokens));
    }

    public final ImmutableCodeSettings withCurrentNumber(boolean value) {
        if (this.currentNumber == value) {
            return this;
        }
        return ImmutableCodeSettings.validate(new ImmutableCodeSettings(this.identifier, this.flags, this.allowFlashcall, value, this.allowAppHash, this.allowMissedCall, this.logoutTokens));
    }

    public final ImmutableCodeSettings withAllowAppHash(boolean value) {
        if (this.allowAppHash == value) {
            return this;
        }
        return ImmutableCodeSettings.validate(new ImmutableCodeSettings(this.identifier, this.flags, this.allowFlashcall, this.currentNumber, value, this.allowMissedCall, this.logoutTokens));
    }

    public final ImmutableCodeSettings withAllowMissedCall(boolean value) {
        if (this.allowMissedCall == value) {
            return this;
        }
        return ImmutableCodeSettings.validate(new ImmutableCodeSettings(this.identifier, this.flags, this.allowFlashcall, this.currentNumber, this.allowAppHash, value, this.logoutTokens));
    }

    public ImmutableCodeSettings withLogoutTokens(Optional<? extends Iterable<ByteBuf>> value) {
        List newValue = value.map(i -> StreamSupport.stream(i.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList())).orElse(null);
        if (this.logoutTokens == newValue) {
            return this;
        }
        return ImmutableCodeSettings.validate(new ImmutableCodeSettings(this.identifier, this.flags, this.allowFlashcall, this.currentNumber, this.allowAppHash, this.allowMissedCall, newValue));
    }

    public ImmutableCodeSettings withLogoutTokens(Iterable<? extends ByteBuf> value) {
        List<ByteBuf> newValue = StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList());
        if (this.logoutTokens == newValue) {
            return this;
        }
        return ImmutableCodeSettings.validate(new ImmutableCodeSettings(this.identifier, this.flags, this.allowFlashcall, this.currentNumber, this.allowAppHash, this.allowMissedCall, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCodeSettings && this.equalTo(0, (ImmutableCodeSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableCodeSettings another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.allowFlashcall == another.allowFlashcall && this.currentNumber == another.currentNumber && this.allowAppHash == another.allowAppHash && this.allowMissedCall == another.allowMissedCall && this.logoutTokens().equals(another.logoutTokens());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.allowFlashcall);
        h += (h << 5) + Boolean.hashCode(this.currentNumber);
        h += (h << 5) + Boolean.hashCode(this.allowAppHash);
        h += (h << 5) + Boolean.hashCode(this.allowMissedCall);
        h += (h << 5) + this.logoutTokens().hashCode();
        return h;
    }

    public String toString() {
        return "CodeSettings{identifier=" + this.identifier + ", flags=" + this.flags + ", allowFlashcall=" + this.allowFlashcall + ", currentNumber=" + this.currentNumber + ", allowAppHash=" + this.allowAppHash + ", allowMissedCall=" + this.allowMissedCall + ", logoutTokens=" + this.logoutTokens().map(l -> l.stream().map(ByteBufUtil::hexDump).collect(Collectors.joining(", ", "[", "]"))).toString() + "}";
    }

    public static ImmutableCodeSettings of() {
        return INSTANCE;
    }

    private static ImmutableCodeSettings validate(ImmutableCodeSettings instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableCodeSettings copyOf(CodeSettings instance) {
        if (instance instanceof ImmutableCodeSettings) {
            return (ImmutableCodeSettings)instance;
        }
        return ImmutableCodeSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_ALLOW_FLASHCALL = 4L;
        private static final long OPT_BIT_CURRENT_NUMBER = 8L;
        private static final long OPT_BIT_ALLOW_APP_HASH = 16L;
        private static final long OPT_BIT_ALLOW_MISSED_CALL = 32L;
        private long optBits;
        private Optional<List<ByteBuf>> logoutTokens_value = Optional.empty();
        private int identifier;
        private int flags;
        private boolean allowFlashcall;
        private boolean currentNumber;
        private boolean allowAppHash;
        private boolean allowMissedCall;

        private Builder() {
        }

        public final Builder from(CodeSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CodeSettings instance;
            long bits = 0L;
            if (object instanceof CodeSettings) {
                instance = (CodeSettings)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.logoutTokens(instance.logoutTokens());
                this.allowFlashcall(instance.allowFlashcall());
                this.allowMissedCall(instance.allowMissedCall());
                this.flags(instance.flags());
                this.allowAppHash(instance.allowAppHash());
                this.currentNumber(instance.currentNumber());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder allowFlashcall(boolean allowFlashcall) {
            this.allowFlashcall = allowFlashcall;
            this.optBits |= 4L;
            return this;
        }

        public final Builder currentNumber(boolean currentNumber) {
            this.currentNumber = currentNumber;
            this.optBits |= 8L;
            return this;
        }

        public final Builder allowAppHash(boolean allowAppHash) {
            this.allowAppHash = allowAppHash;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder allowMissedCall(boolean allowMissedCall) {
            this.allowMissedCall = allowMissedCall;
            this.optBits |= 0x20L;
            return this;
        }

        public Builder addLogoutToken(ByteBuf value) {
            this.logoutTokens_getOrCreate().add(TlEncodingUtil.copyAsUnpooled((ByteBuf)value));
            return this;
        }

        public Builder addAllLogoutTokens(Iterable<? extends ByteBuf> value) {
            this.logoutTokens_getOrCreate().addAll(StreamSupport.stream(value.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder addAllLogoutTokens(ByteBuf ... value) {
            this.logoutTokens_getOrCreate().addAll(Arrays.stream(value).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder logoutTokens(Optional<? extends Iterable<ByteBuf>> value) {
            this.logoutTokens_value = value.map(i -> StreamSupport.stream(i.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder logoutTokens(@Nullable Iterable<? extends ByteBuf> value) {
            this.logoutTokens_value = Optional.ofNullable(value).map(i -> StreamSupport.stream(i.spliterator(), false).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public Builder logoutTokens(ByteBuf ... value) {
            this.logoutTokens_value = Optional.ofNullable(value).map(b -> Arrays.stream(value).map(TlEncodingUtil::copyAsUnpooled).collect(Collectors.toList()));
            return this;
        }

        public ImmutableCodeSettings build() {
            return ImmutableCodeSettings.validate(new ImmutableCodeSettings(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean allowFlashcallIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean currentNumberIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean allowAppHashIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean allowMissedCallIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private List<ByteBuf> logoutTokens_build() {
            return this.logoutTokens_value.map(TlEncodingUtil::unmodifiableList).orElse(null);
        }

        private List<ByteBuf> logoutTokens_getOrCreate() {
            if (this.logoutTokens_value.isEmpty()) {
                this.logoutTokens_value = Optional.of(new ArrayList());
            }
            return this.logoutTokens_value.orElseThrow();
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte allowFlashcallBuildStage = 0;
        private boolean allowFlashcall;
        private byte currentNumberBuildStage = 0;
        private boolean currentNumber;
        private byte allowAppHashBuildStage = 0;
        private boolean allowAppHash;
        private byte allowMissedCallBuildStage = 0;
        private boolean allowMissedCall;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableCodeSettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableCodeSettings.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean allowFlashcall() {
            if (this.allowFlashcallBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allowFlashcallBuildStage == 0) {
                this.allowFlashcallBuildStage = (byte)-1;
                this.allowFlashcall = ImmutableCodeSettings.this.allowFlashcallInitialize();
                this.allowFlashcallBuildStage = 1;
            }
            return this.allowFlashcall;
        }

        void allowFlashcall(boolean allowFlashcall) {
            this.allowFlashcall = allowFlashcall;
            this.allowFlashcallBuildStage = 1;
        }

        boolean currentNumber() {
            if (this.currentNumberBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.currentNumberBuildStage == 0) {
                this.currentNumberBuildStage = (byte)-1;
                this.currentNumber = ImmutableCodeSettings.this.currentNumberInitialize();
                this.currentNumberBuildStage = 1;
            }
            return this.currentNumber;
        }

        void currentNumber(boolean currentNumber) {
            this.currentNumber = currentNumber;
            this.currentNumberBuildStage = 1;
        }

        boolean allowAppHash() {
            if (this.allowAppHashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allowAppHashBuildStage == 0) {
                this.allowAppHashBuildStage = (byte)-1;
                this.allowAppHash = ImmutableCodeSettings.this.allowAppHashInitialize();
                this.allowAppHashBuildStage = 1;
            }
            return this.allowAppHash;
        }

        void allowAppHash(boolean allowAppHash) {
            this.allowAppHash = allowAppHash;
            this.allowAppHashBuildStage = 1;
        }

        boolean allowMissedCall() {
            if (this.allowMissedCallBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allowMissedCallBuildStage == 0) {
                this.allowMissedCallBuildStage = (byte)-1;
                this.allowMissedCall = ImmutableCodeSettings.this.allowMissedCallInitialize();
                this.allowMissedCallBuildStage = 1;
            }
            return this.allowMissedCall;
        }

        void allowMissedCall(boolean allowMissedCall) {
            this.allowMissedCall = allowMissedCall;
            this.allowMissedCallBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.allowFlashcallBuildStage == -1) {
                attributes.add("allowFlashcall");
            }
            if (this.currentNumberBuildStage == -1) {
                attributes.add("currentNumber");
            }
            if (this.allowAppHashBuildStage == -1) {
                attributes.add("allowAppHash");
            }
            if (this.allowMissedCallBuildStage == -1) {
                attributes.add("allowMissedCall");
            }
            return "Cannot build CodeSettings, attribute initializers form cycle " + attributes;
        }
    }
}

