/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Config;
import telegram4j.tl.DcOption;
import telegram4j.tl.api.TlObject;

public final class ImmutableConfig
implements Config {
    private final int identifier;
    private final int flags;
    private final boolean phonecallsEnabled;
    private final boolean defaultP2pContacts;
    private final boolean preloadFeaturedStickers;
    private final boolean ignorePhoneEntities;
    private final boolean revokePmInbox;
    private final boolean blockedMode;
    private final boolean pfsEnabled;
    private final boolean forceTryIpv6;
    private final int date;
    private final int expires;
    private final boolean testMode;
    private final int thisDc;
    private final List<DcOption> dcOptions;
    private final String dcTxtDomainName;
    private final int chatSizeMax;
    private final int megagroupSizeMax;
    private final int forwardedCountMax;
    private final int onlineUpdatePeriodMs;
    private final int offlineBlurTimeoutMs;
    private final int offlineIdleTimeoutMs;
    private final int onlineCloudTimeoutMs;
    private final int notifyCloudDelayMs;
    private final int notifyDefaultDelayMs;
    private final int pushChatPeriodMs;
    private final int pushChatLimit;
    private final int savedGifsLimit;
    private final int editTimeLimit;
    private final int revokeTimeLimit;
    private final int revokePmTimeLimit;
    private final int ratingEDecay;
    private final int stickersRecentLimit;
    private final int stickersFavedLimit;
    private final int channelsReadMediaPeriod;
    @Nullable
    private final Integer tmpSessions;
    private final int pinnedDialogsCountMax;
    private final int pinnedInfolderCountMax;
    private final int callReceiveTimeoutMs;
    private final int callRingTimeoutMs;
    private final int callConnectTimeoutMs;
    private final int callPacketTimeoutMs;
    private final String meUrlPrefix;
    @Nullable
    private final String autoupdateUrlPrefix;
    @Nullable
    private final String gifSearchUsername;
    @Nullable
    private final String venueSearchUsername;
    @Nullable
    private final String imgSearchUsername;
    @Nullable
    private final String staticMapsProvider;
    private final int captionLengthMax;
    private final int messageLengthMax;
    private final int webfileDcId;
    @Nullable
    private final String suggestedLangCode;
    @Nullable
    private final Integer langPackVersion;
    @Nullable
    private final Integer baseLangPackVersion;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableConfig(int date, int expires, boolean testMode, int thisDc, String dcTxtDomainName, int chatSizeMax, int megagroupSizeMax, int forwardedCountMax, int onlineUpdatePeriodMs, int offlineBlurTimeoutMs, int offlineIdleTimeoutMs, int onlineCloudTimeoutMs, int notifyCloudDelayMs, int notifyDefaultDelayMs, int pushChatPeriodMs, int pushChatLimit, int savedGifsLimit, int editTimeLimit, int revokeTimeLimit, int revokePmTimeLimit, int ratingEDecay, int stickersRecentLimit, int stickersFavedLimit, int channelsReadMediaPeriod, int pinnedDialogsCountMax, int pinnedInfolderCountMax, int callReceiveTimeoutMs, int callRingTimeoutMs, int callConnectTimeoutMs, int callPacketTimeoutMs, String meUrlPrefix, int captionLengthMax, int messageLengthMax, int webfileDcId) {
        this.date = date;
        this.expires = expires;
        this.testMode = testMode;
        this.thisDc = thisDc;
        this.dcTxtDomainName = Objects.requireNonNull(dcTxtDomainName, "dcTxtDomainName");
        this.chatSizeMax = chatSizeMax;
        this.megagroupSizeMax = megagroupSizeMax;
        this.forwardedCountMax = forwardedCountMax;
        this.onlineUpdatePeriodMs = onlineUpdatePeriodMs;
        this.offlineBlurTimeoutMs = offlineBlurTimeoutMs;
        this.offlineIdleTimeoutMs = offlineIdleTimeoutMs;
        this.onlineCloudTimeoutMs = onlineCloudTimeoutMs;
        this.notifyCloudDelayMs = notifyCloudDelayMs;
        this.notifyDefaultDelayMs = notifyDefaultDelayMs;
        this.pushChatPeriodMs = pushChatPeriodMs;
        this.pushChatLimit = pushChatLimit;
        this.savedGifsLimit = savedGifsLimit;
        this.editTimeLimit = editTimeLimit;
        this.revokeTimeLimit = revokeTimeLimit;
        this.revokePmTimeLimit = revokePmTimeLimit;
        this.ratingEDecay = ratingEDecay;
        this.stickersRecentLimit = stickersRecentLimit;
        this.stickersFavedLimit = stickersFavedLimit;
        this.channelsReadMediaPeriod = channelsReadMediaPeriod;
        this.pinnedDialogsCountMax = pinnedDialogsCountMax;
        this.pinnedInfolderCountMax = pinnedInfolderCountMax;
        this.callReceiveTimeoutMs = callReceiveTimeoutMs;
        this.callRingTimeoutMs = callRingTimeoutMs;
        this.callConnectTimeoutMs = callConnectTimeoutMs;
        this.callPacketTimeoutMs = callPacketTimeoutMs;
        this.meUrlPrefix = Objects.requireNonNull(meUrlPrefix, "meUrlPrefix");
        this.captionLengthMax = captionLengthMax;
        this.messageLengthMax = messageLengthMax;
        this.webfileDcId = webfileDcId;
        this.dcOptions = Collections.emptyList();
        this.tmpSessions = null;
        this.autoupdateUrlPrefix = null;
        this.gifSearchUsername = null;
        this.venueSearchUsername = null;
        this.imgSearchUsername = null;
        this.staticMapsProvider = null;
        this.suggestedLangCode = null;
        this.langPackVersion = null;
        this.baseLangPackVersion = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.phonecallsEnabled = this.initShim.phonecallsEnabled();
        this.defaultP2pContacts = this.initShim.defaultP2pContacts();
        this.preloadFeaturedStickers = this.initShim.preloadFeaturedStickers();
        this.ignorePhoneEntities = this.initShim.ignorePhoneEntities();
        this.revokePmInbox = this.initShim.revokePmInbox();
        this.blockedMode = this.initShim.blockedMode();
        this.pfsEnabled = this.initShim.pfsEnabled();
        this.forceTryIpv6 = this.initShim.forceTryIpv6();
        this.initShim = null;
    }

    private ImmutableConfig(Builder builder) {
        this.date = builder.date;
        this.expires = builder.expires;
        this.testMode = builder.testMode;
        this.thisDc = builder.thisDc;
        this.dcOptions = ImmutableConfig.createUnmodifiableList(true, builder.dcOptions);
        this.dcTxtDomainName = builder.dcTxtDomainName;
        this.chatSizeMax = builder.chatSizeMax;
        this.megagroupSizeMax = builder.megagroupSizeMax;
        this.forwardedCountMax = builder.forwardedCountMax;
        this.onlineUpdatePeriodMs = builder.onlineUpdatePeriodMs;
        this.offlineBlurTimeoutMs = builder.offlineBlurTimeoutMs;
        this.offlineIdleTimeoutMs = builder.offlineIdleTimeoutMs;
        this.onlineCloudTimeoutMs = builder.onlineCloudTimeoutMs;
        this.notifyCloudDelayMs = builder.notifyCloudDelayMs;
        this.notifyDefaultDelayMs = builder.notifyDefaultDelayMs;
        this.pushChatPeriodMs = builder.pushChatPeriodMs;
        this.pushChatLimit = builder.pushChatLimit;
        this.savedGifsLimit = builder.savedGifsLimit;
        this.editTimeLimit = builder.editTimeLimit;
        this.revokeTimeLimit = builder.revokeTimeLimit;
        this.revokePmTimeLimit = builder.revokePmTimeLimit;
        this.ratingEDecay = builder.ratingEDecay;
        this.stickersRecentLimit = builder.stickersRecentLimit;
        this.stickersFavedLimit = builder.stickersFavedLimit;
        this.channelsReadMediaPeriod = builder.channelsReadMediaPeriod;
        this.tmpSessions = builder.tmpSessions;
        this.pinnedDialogsCountMax = builder.pinnedDialogsCountMax;
        this.pinnedInfolderCountMax = builder.pinnedInfolderCountMax;
        this.callReceiveTimeoutMs = builder.callReceiveTimeoutMs;
        this.callRingTimeoutMs = builder.callRingTimeoutMs;
        this.callConnectTimeoutMs = builder.callConnectTimeoutMs;
        this.callPacketTimeoutMs = builder.callPacketTimeoutMs;
        this.meUrlPrefix = builder.meUrlPrefix;
        this.autoupdateUrlPrefix = builder.autoupdateUrlPrefix;
        this.gifSearchUsername = builder.gifSearchUsername;
        this.venueSearchUsername = builder.venueSearchUsername;
        this.imgSearchUsername = builder.imgSearchUsername;
        this.staticMapsProvider = builder.staticMapsProvider;
        this.captionLengthMax = builder.captionLengthMax;
        this.messageLengthMax = builder.messageLengthMax;
        this.webfileDcId = builder.webfileDcId;
        this.suggestedLangCode = builder.suggestedLangCode;
        this.langPackVersion = builder.langPackVersion;
        this.baseLangPackVersion = builder.baseLangPackVersion;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.phonecallsEnabledIsSet()) {
            this.initShim.phonecallsEnabled(builder.phonecallsEnabled);
        }
        if (builder.defaultP2pContactsIsSet()) {
            this.initShim.defaultP2pContacts(builder.defaultP2pContacts);
        }
        if (builder.preloadFeaturedStickersIsSet()) {
            this.initShim.preloadFeaturedStickers(builder.preloadFeaturedStickers);
        }
        if (builder.ignorePhoneEntitiesIsSet()) {
            this.initShim.ignorePhoneEntities(builder.ignorePhoneEntities);
        }
        if (builder.revokePmInboxIsSet()) {
            this.initShim.revokePmInbox(builder.revokePmInbox);
        }
        if (builder.blockedModeIsSet()) {
            this.initShim.blockedMode(builder.blockedMode);
        }
        if (builder.pfsEnabledIsSet()) {
            this.initShim.pfsEnabled(builder.pfsEnabled);
        }
        if (builder.forceTryIpv6IsSet()) {
            this.initShim.forceTryIpv6(builder.forceTryIpv6);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.phonecallsEnabled = this.initShim.phonecallsEnabled();
        this.defaultP2pContacts = this.initShim.defaultP2pContacts();
        this.preloadFeaturedStickers = this.initShim.preloadFeaturedStickers();
        this.ignorePhoneEntities = this.initShim.ignorePhoneEntities();
        this.revokePmInbox = this.initShim.revokePmInbox();
        this.blockedMode = this.initShim.blockedMode();
        this.pfsEnabled = this.initShim.pfsEnabled();
        this.forceTryIpv6 = this.initShim.forceTryIpv6();
        this.initShim = null;
    }

    private ImmutableConfig(int identifier, int flags, boolean phonecallsEnabled, boolean defaultP2pContacts, boolean preloadFeaturedStickers, boolean ignorePhoneEntities, boolean revokePmInbox, boolean blockedMode, boolean pfsEnabled, boolean forceTryIpv6, int date, int expires, boolean testMode, int thisDc, List<DcOption> dcOptions, String dcTxtDomainName, int chatSizeMax, int megagroupSizeMax, int forwardedCountMax, int onlineUpdatePeriodMs, int offlineBlurTimeoutMs, int offlineIdleTimeoutMs, int onlineCloudTimeoutMs, int notifyCloudDelayMs, int notifyDefaultDelayMs, int pushChatPeriodMs, int pushChatLimit, int savedGifsLimit, int editTimeLimit, int revokeTimeLimit, int revokePmTimeLimit, int ratingEDecay, int stickersRecentLimit, int stickersFavedLimit, int channelsReadMediaPeriod, @Nullable Integer tmpSessions, int pinnedDialogsCountMax, int pinnedInfolderCountMax, int callReceiveTimeoutMs, int callRingTimeoutMs, int callConnectTimeoutMs, int callPacketTimeoutMs, String meUrlPrefix, @Nullable String autoupdateUrlPrefix, @Nullable String gifSearchUsername, @Nullable String venueSearchUsername, @Nullable String imgSearchUsername, @Nullable String staticMapsProvider, int captionLengthMax, int messageLengthMax, int webfileDcId, @Nullable String suggestedLangCode, @Nullable Integer langPackVersion, @Nullable Integer baseLangPackVersion) {
        this.identifier = identifier;
        this.flags = flags;
        this.phonecallsEnabled = phonecallsEnabled;
        this.defaultP2pContacts = defaultP2pContacts;
        this.preloadFeaturedStickers = preloadFeaturedStickers;
        this.ignorePhoneEntities = ignorePhoneEntities;
        this.revokePmInbox = revokePmInbox;
        this.blockedMode = blockedMode;
        this.pfsEnabled = pfsEnabled;
        this.forceTryIpv6 = forceTryIpv6;
        this.date = date;
        this.expires = expires;
        this.testMode = testMode;
        this.thisDc = thisDc;
        this.dcOptions = dcOptions;
        this.dcTxtDomainName = dcTxtDomainName;
        this.chatSizeMax = chatSizeMax;
        this.megagroupSizeMax = megagroupSizeMax;
        this.forwardedCountMax = forwardedCountMax;
        this.onlineUpdatePeriodMs = onlineUpdatePeriodMs;
        this.offlineBlurTimeoutMs = offlineBlurTimeoutMs;
        this.offlineIdleTimeoutMs = offlineIdleTimeoutMs;
        this.onlineCloudTimeoutMs = onlineCloudTimeoutMs;
        this.notifyCloudDelayMs = notifyCloudDelayMs;
        this.notifyDefaultDelayMs = notifyDefaultDelayMs;
        this.pushChatPeriodMs = pushChatPeriodMs;
        this.pushChatLimit = pushChatLimit;
        this.savedGifsLimit = savedGifsLimit;
        this.editTimeLimit = editTimeLimit;
        this.revokeTimeLimit = revokeTimeLimit;
        this.revokePmTimeLimit = revokePmTimeLimit;
        this.ratingEDecay = ratingEDecay;
        this.stickersRecentLimit = stickersRecentLimit;
        this.stickersFavedLimit = stickersFavedLimit;
        this.channelsReadMediaPeriod = channelsReadMediaPeriod;
        this.tmpSessions = tmpSessions;
        this.pinnedDialogsCountMax = pinnedDialogsCountMax;
        this.pinnedInfolderCountMax = pinnedInfolderCountMax;
        this.callReceiveTimeoutMs = callReceiveTimeoutMs;
        this.callRingTimeoutMs = callRingTimeoutMs;
        this.callConnectTimeoutMs = callConnectTimeoutMs;
        this.callPacketTimeoutMs = callPacketTimeoutMs;
        this.meUrlPrefix = meUrlPrefix;
        this.autoupdateUrlPrefix = autoupdateUrlPrefix;
        this.gifSearchUsername = gifSearchUsername;
        this.venueSearchUsername = venueSearchUsername;
        this.imgSearchUsername = imgSearchUsername;
        this.staticMapsProvider = staticMapsProvider;
        this.captionLengthMax = captionLengthMax;
        this.messageLengthMax = messageLengthMax;
        this.webfileDcId = webfileDcId;
        this.suggestedLangCode = suggestedLangCode;
        this.langPackVersion = langPackVersion;
        this.baseLangPackVersion = baseLangPackVersion;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return Config.super.identifier();
    }

    private int flagsInitialize() {
        return Config.super.flags();
    }

    private boolean phonecallsEnabledInitialize() {
        return Config.super.phonecallsEnabled();
    }

    private boolean defaultP2pContactsInitialize() {
        return Config.super.defaultP2pContacts();
    }

    private boolean preloadFeaturedStickersInitialize() {
        return Config.super.preloadFeaturedStickers();
    }

    private boolean ignorePhoneEntitiesInitialize() {
        return Config.super.ignorePhoneEntities();
    }

    private boolean revokePmInboxInitialize() {
        return Config.super.revokePmInbox();
    }

    private boolean blockedModeInitialize() {
        return Config.super.blockedMode();
    }

    private boolean pfsEnabledInitialize() {
        return Config.super.pfsEnabled();
    }

    private boolean forceTryIpv6Initialize() {
        return Config.super.forceTryIpv6();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean phonecallsEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.phonecallsEnabled() : this.phonecallsEnabled;
    }

    @Override
    public boolean defaultP2pContacts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defaultP2pContacts() : this.defaultP2pContacts;
    }

    @Override
    public boolean preloadFeaturedStickers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.preloadFeaturedStickers() : this.preloadFeaturedStickers;
    }

    @Override
    public boolean ignorePhoneEntities() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ignorePhoneEntities() : this.ignorePhoneEntities;
    }

    @Override
    public boolean revokePmInbox() {
        InitShim shim = this.initShim;
        return shim != null ? shim.revokePmInbox() : this.revokePmInbox;
    }

    @Override
    public boolean blockedMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.blockedMode() : this.blockedMode;
    }

    @Override
    public boolean pfsEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pfsEnabled() : this.pfsEnabled;
    }

    @Override
    public boolean forceTryIpv6() {
        InitShim shim = this.initShim;
        return shim != null ? shim.forceTryIpv6() : this.forceTryIpv6;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public int expires() {
        return this.expires;
    }

    @Override
    public boolean testMode() {
        return this.testMode;
    }

    @Override
    public int thisDc() {
        return this.thisDc;
    }

    @Override
    public List<DcOption> dcOptions() {
        return this.dcOptions;
    }

    @Override
    public String dcTxtDomainName() {
        return this.dcTxtDomainName;
    }

    @Override
    public int chatSizeMax() {
        return this.chatSizeMax;
    }

    @Override
    public int megagroupSizeMax() {
        return this.megagroupSizeMax;
    }

    @Override
    public int forwardedCountMax() {
        return this.forwardedCountMax;
    }

    @Override
    public int onlineUpdatePeriodMs() {
        return this.onlineUpdatePeriodMs;
    }

    @Override
    public int offlineBlurTimeoutMs() {
        return this.offlineBlurTimeoutMs;
    }

    @Override
    public int offlineIdleTimeoutMs() {
        return this.offlineIdleTimeoutMs;
    }

    @Override
    public int onlineCloudTimeoutMs() {
        return this.onlineCloudTimeoutMs;
    }

    @Override
    public int notifyCloudDelayMs() {
        return this.notifyCloudDelayMs;
    }

    @Override
    public int notifyDefaultDelayMs() {
        return this.notifyDefaultDelayMs;
    }

    @Override
    public int pushChatPeriodMs() {
        return this.pushChatPeriodMs;
    }

    @Override
    public int pushChatLimit() {
        return this.pushChatLimit;
    }

    @Override
    public int savedGifsLimit() {
        return this.savedGifsLimit;
    }

    @Override
    public int editTimeLimit() {
        return this.editTimeLimit;
    }

    @Override
    public int revokeTimeLimit() {
        return this.revokeTimeLimit;
    }

    @Override
    public int revokePmTimeLimit() {
        return this.revokePmTimeLimit;
    }

    @Override
    public int ratingEDecay() {
        return this.ratingEDecay;
    }

    @Override
    public int stickersRecentLimit() {
        return this.stickersRecentLimit;
    }

    @Override
    public int stickersFavedLimit() {
        return this.stickersFavedLimit;
    }

    @Override
    public int channelsReadMediaPeriod() {
        return this.channelsReadMediaPeriod;
    }

    @Override
    @Nullable
    public Integer tmpSessions() {
        return this.tmpSessions;
    }

    @Override
    public int pinnedDialogsCountMax() {
        return this.pinnedDialogsCountMax;
    }

    @Override
    public int pinnedInfolderCountMax() {
        return this.pinnedInfolderCountMax;
    }

    @Override
    public int callReceiveTimeoutMs() {
        return this.callReceiveTimeoutMs;
    }

    @Override
    public int callRingTimeoutMs() {
        return this.callRingTimeoutMs;
    }

    @Override
    public int callConnectTimeoutMs() {
        return this.callConnectTimeoutMs;
    }

    @Override
    public int callPacketTimeoutMs() {
        return this.callPacketTimeoutMs;
    }

    @Override
    public String meUrlPrefix() {
        return this.meUrlPrefix;
    }

    @Override
    @Nullable
    public String autoupdateUrlPrefix() {
        return this.autoupdateUrlPrefix;
    }

    @Override
    @Nullable
    public String gifSearchUsername() {
        return this.gifSearchUsername;
    }

    @Override
    @Nullable
    public String venueSearchUsername() {
        return this.venueSearchUsername;
    }

    @Override
    @Nullable
    public String imgSearchUsername() {
        return this.imgSearchUsername;
    }

    @Override
    @Nullable
    public String staticMapsProvider() {
        return this.staticMapsProvider;
    }

    @Override
    public int captionLengthMax() {
        return this.captionLengthMax;
    }

    @Override
    public int messageLengthMax() {
        return this.messageLengthMax;
    }

    @Override
    public int webfileDcId() {
        return this.webfileDcId;
    }

    @Override
    @Nullable
    public String suggestedLangCode() {
        return this.suggestedLangCode;
    }

    @Override
    @Nullable
    public Integer langPackVersion() {
        return this.langPackVersion;
    }

    @Override
    @Nullable
    public Integer baseLangPackVersion() {
        return this.baseLangPackVersion;
    }

    public final ImmutableConfig withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableConfig(value, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, value, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withPhonecallsEnabled(boolean value) {
        if (this.phonecallsEnabled == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, value, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withDefaultP2pContacts(boolean value) {
        if (this.defaultP2pContacts == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, value, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withPreloadFeaturedStickers(boolean value) {
        if (this.preloadFeaturedStickers == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, value, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withIgnorePhoneEntities(boolean value) {
        if (this.ignorePhoneEntities == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, value, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withRevokePmInbox(boolean value) {
        if (this.revokePmInbox == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, value, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withBlockedMode(boolean value) {
        if (this.blockedMode == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, value, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withPfsEnabled(boolean value) {
        if (this.pfsEnabled == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, value, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withForceTryIpv6(boolean value) {
        if (this.forceTryIpv6 == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, value, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, value, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withExpires(int value) {
        if (this.expires == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, value, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withTestMode(boolean value) {
        if (this.testMode == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, value, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withThisDc(int value) {
        if (this.thisDc == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, value, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withDcOptions(DcOption ... elements) {
        List<DcOption> newValue = ImmutableConfig.createUnmodifiableList(false, ImmutableConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, newValue, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withDcOptions(Iterable<? extends DcOption> elements) {
        if (this.dcOptions == elements) {
            return this;
        }
        List<DcOption> newValue = ImmutableConfig.createUnmodifiableList(false, ImmutableConfig.createSafeList(elements, true, false));
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, newValue, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withDcTxtDomainName(String value) {
        String newValue = Objects.requireNonNull(value, "dcTxtDomainName");
        if (this.dcTxtDomainName.equals(newValue)) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, newValue, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withChatSizeMax(int value) {
        if (this.chatSizeMax == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, value, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withMegagroupSizeMax(int value) {
        if (this.megagroupSizeMax == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, value, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withForwardedCountMax(int value) {
        if (this.forwardedCountMax == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, value, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withOnlineUpdatePeriodMs(int value) {
        if (this.onlineUpdatePeriodMs == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, value, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withOfflineBlurTimeoutMs(int value) {
        if (this.offlineBlurTimeoutMs == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, value, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withOfflineIdleTimeoutMs(int value) {
        if (this.offlineIdleTimeoutMs == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, value, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withOnlineCloudTimeoutMs(int value) {
        if (this.onlineCloudTimeoutMs == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, value, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withNotifyCloudDelayMs(int value) {
        if (this.notifyCloudDelayMs == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, value, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withNotifyDefaultDelayMs(int value) {
        if (this.notifyDefaultDelayMs == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, value, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withPushChatPeriodMs(int value) {
        if (this.pushChatPeriodMs == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, value, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withPushChatLimit(int value) {
        if (this.pushChatLimit == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, value, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withSavedGifsLimit(int value) {
        if (this.savedGifsLimit == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, value, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withEditTimeLimit(int value) {
        if (this.editTimeLimit == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, value, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withRevokeTimeLimit(int value) {
        if (this.revokeTimeLimit == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, value, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withRevokePmTimeLimit(int value) {
        if (this.revokePmTimeLimit == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, value, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withRatingEDecay(int value) {
        if (this.ratingEDecay == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, value, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withStickersRecentLimit(int value) {
        if (this.stickersRecentLimit == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, value, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withStickersFavedLimit(int value) {
        if (this.stickersFavedLimit == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, value, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withChannelsReadMediaPeriod(int value) {
        if (this.channelsReadMediaPeriod == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, value, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withTmpSessions(@Nullable Integer value) {
        if (Objects.equals(this.tmpSessions, value)) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, value, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withPinnedDialogsCountMax(int value) {
        if (this.pinnedDialogsCountMax == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, value, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withPinnedInfolderCountMax(int value) {
        if (this.pinnedInfolderCountMax == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, value, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withCallReceiveTimeoutMs(int value) {
        if (this.callReceiveTimeoutMs == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, value, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withCallRingTimeoutMs(int value) {
        if (this.callRingTimeoutMs == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, value, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withCallConnectTimeoutMs(int value) {
        if (this.callConnectTimeoutMs == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, value, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withCallPacketTimeoutMs(int value) {
        if (this.callPacketTimeoutMs == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, value, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withMeUrlPrefix(String value) {
        String newValue = Objects.requireNonNull(value, "meUrlPrefix");
        if (this.meUrlPrefix.equals(newValue)) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, newValue, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withAutoupdateUrlPrefix(@Nullable String value) {
        if (Objects.equals(this.autoupdateUrlPrefix, value)) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, value, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withGifSearchUsername(@Nullable String value) {
        if (Objects.equals(this.gifSearchUsername, value)) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, value, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withVenueSearchUsername(@Nullable String value) {
        if (Objects.equals(this.venueSearchUsername, value)) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, value, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withImgSearchUsername(@Nullable String value) {
        if (Objects.equals(this.imgSearchUsername, value)) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, value, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withStaticMapsProvider(@Nullable String value) {
        if (Objects.equals(this.staticMapsProvider, value)) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, value, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withCaptionLengthMax(int value) {
        if (this.captionLengthMax == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, value, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withMessageLengthMax(int value) {
        if (this.messageLengthMax == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, value, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withWebfileDcId(int value) {
        if (this.webfileDcId == value) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, value, this.suggestedLangCode, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withSuggestedLangCode(@Nullable String value) {
        if (Objects.equals(this.suggestedLangCode, value)) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, value, this.langPackVersion, this.baseLangPackVersion);
    }

    public final ImmutableConfig withLangPackVersion(@Nullable Integer value) {
        if (Objects.equals(this.langPackVersion, value)) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, value, this.baseLangPackVersion);
    }

    public final ImmutableConfig withBaseLangPackVersion(@Nullable Integer value) {
        if (Objects.equals(this.baseLangPackVersion, value)) {
            return this;
        }
        return new ImmutableConfig(this.identifier, this.flags, this.phonecallsEnabled, this.defaultP2pContacts, this.preloadFeaturedStickers, this.ignorePhoneEntities, this.revokePmInbox, this.blockedMode, this.pfsEnabled, this.forceTryIpv6, this.date, this.expires, this.testMode, this.thisDc, this.dcOptions, this.dcTxtDomainName, this.chatSizeMax, this.megagroupSizeMax, this.forwardedCountMax, this.onlineUpdatePeriodMs, this.offlineBlurTimeoutMs, this.offlineIdleTimeoutMs, this.onlineCloudTimeoutMs, this.notifyCloudDelayMs, this.notifyDefaultDelayMs, this.pushChatPeriodMs, this.pushChatLimit, this.savedGifsLimit, this.editTimeLimit, this.revokeTimeLimit, this.revokePmTimeLimit, this.ratingEDecay, this.stickersRecentLimit, this.stickersFavedLimit, this.channelsReadMediaPeriod, this.tmpSessions, this.pinnedDialogsCountMax, this.pinnedInfolderCountMax, this.callReceiveTimeoutMs, this.callRingTimeoutMs, this.callConnectTimeoutMs, this.callPacketTimeoutMs, this.meUrlPrefix, this.autoupdateUrlPrefix, this.gifSearchUsername, this.venueSearchUsername, this.imgSearchUsername, this.staticMapsProvider, this.captionLengthMax, this.messageLengthMax, this.webfileDcId, this.suggestedLangCode, this.langPackVersion, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfig && this.equalTo(0, (ImmutableConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableConfig another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.phonecallsEnabled == another.phonecallsEnabled && this.defaultP2pContacts == another.defaultP2pContacts && this.preloadFeaturedStickers == another.preloadFeaturedStickers && this.ignorePhoneEntities == another.ignorePhoneEntities && this.revokePmInbox == another.revokePmInbox && this.blockedMode == another.blockedMode && this.pfsEnabled == another.pfsEnabled && this.forceTryIpv6 == another.forceTryIpv6 && this.date == another.date && this.expires == another.expires && this.testMode == another.testMode && this.thisDc == another.thisDc && this.dcOptions.equals(another.dcOptions) && this.dcTxtDomainName.equals(another.dcTxtDomainName) && this.chatSizeMax == another.chatSizeMax && this.megagroupSizeMax == another.megagroupSizeMax && this.forwardedCountMax == another.forwardedCountMax && this.onlineUpdatePeriodMs == another.onlineUpdatePeriodMs && this.offlineBlurTimeoutMs == another.offlineBlurTimeoutMs && this.offlineIdleTimeoutMs == another.offlineIdleTimeoutMs && this.onlineCloudTimeoutMs == another.onlineCloudTimeoutMs && this.notifyCloudDelayMs == another.notifyCloudDelayMs && this.notifyDefaultDelayMs == another.notifyDefaultDelayMs && this.pushChatPeriodMs == another.pushChatPeriodMs && this.pushChatLimit == another.pushChatLimit && this.savedGifsLimit == another.savedGifsLimit && this.editTimeLimit == another.editTimeLimit && this.revokeTimeLimit == another.revokeTimeLimit && this.revokePmTimeLimit == another.revokePmTimeLimit && this.ratingEDecay == another.ratingEDecay && this.stickersRecentLimit == another.stickersRecentLimit && this.stickersFavedLimit == another.stickersFavedLimit && this.channelsReadMediaPeriod == another.channelsReadMediaPeriod && Objects.equals(this.tmpSessions, another.tmpSessions) && this.pinnedDialogsCountMax == another.pinnedDialogsCountMax && this.pinnedInfolderCountMax == another.pinnedInfolderCountMax && this.callReceiveTimeoutMs == another.callReceiveTimeoutMs && this.callRingTimeoutMs == another.callRingTimeoutMs && this.callConnectTimeoutMs == another.callConnectTimeoutMs && this.callPacketTimeoutMs == another.callPacketTimeoutMs && this.meUrlPrefix.equals(another.meUrlPrefix) && Objects.equals(this.autoupdateUrlPrefix, another.autoupdateUrlPrefix) && Objects.equals(this.gifSearchUsername, another.gifSearchUsername) && Objects.equals(this.venueSearchUsername, another.venueSearchUsername) && Objects.equals(this.imgSearchUsername, another.imgSearchUsername) && Objects.equals(this.staticMapsProvider, another.staticMapsProvider) && this.captionLengthMax == another.captionLengthMax && this.messageLengthMax == another.messageLengthMax && this.webfileDcId == another.webfileDcId && Objects.equals(this.suggestedLangCode, another.suggestedLangCode) && Objects.equals(this.langPackVersion, another.langPackVersion) && Objects.equals(this.baseLangPackVersion, another.baseLangPackVersion);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.phonecallsEnabled);
        h += (h << 5) + Boolean.hashCode(this.defaultP2pContacts);
        h += (h << 5) + Boolean.hashCode(this.preloadFeaturedStickers);
        h += (h << 5) + Boolean.hashCode(this.ignorePhoneEntities);
        h += (h << 5) + Boolean.hashCode(this.revokePmInbox);
        h += (h << 5) + Boolean.hashCode(this.blockedMode);
        h += (h << 5) + Boolean.hashCode(this.pfsEnabled);
        h += (h << 5) + Boolean.hashCode(this.forceTryIpv6);
        h += (h << 5) + this.date;
        h += (h << 5) + this.expires;
        h += (h << 5) + Boolean.hashCode(this.testMode);
        h += (h << 5) + this.thisDc;
        h += (h << 5) + this.dcOptions.hashCode();
        h += (h << 5) + this.dcTxtDomainName.hashCode();
        h += (h << 5) + this.chatSizeMax;
        h += (h << 5) + this.megagroupSizeMax;
        h += (h << 5) + this.forwardedCountMax;
        h += (h << 5) + this.onlineUpdatePeriodMs;
        h += (h << 5) + this.offlineBlurTimeoutMs;
        h += (h << 5) + this.offlineIdleTimeoutMs;
        h += (h << 5) + this.onlineCloudTimeoutMs;
        h += (h << 5) + this.notifyCloudDelayMs;
        h += (h << 5) + this.notifyDefaultDelayMs;
        h += (h << 5) + this.pushChatPeriodMs;
        h += (h << 5) + this.pushChatLimit;
        h += (h << 5) + this.savedGifsLimit;
        h += (h << 5) + this.editTimeLimit;
        h += (h << 5) + this.revokeTimeLimit;
        h += (h << 5) + this.revokePmTimeLimit;
        h += (h << 5) + this.ratingEDecay;
        h += (h << 5) + this.stickersRecentLimit;
        h += (h << 5) + this.stickersFavedLimit;
        h += (h << 5) + this.channelsReadMediaPeriod;
        h += (h << 5) + Objects.hashCode(this.tmpSessions);
        h += (h << 5) + this.pinnedDialogsCountMax;
        h += (h << 5) + this.pinnedInfolderCountMax;
        h += (h << 5) + this.callReceiveTimeoutMs;
        h += (h << 5) + this.callRingTimeoutMs;
        h += (h << 5) + this.callConnectTimeoutMs;
        h += (h << 5) + this.callPacketTimeoutMs;
        h += (h << 5) + this.meUrlPrefix.hashCode();
        h += (h << 5) + Objects.hashCode(this.autoupdateUrlPrefix);
        h += (h << 5) + Objects.hashCode(this.gifSearchUsername);
        h += (h << 5) + Objects.hashCode(this.venueSearchUsername);
        h += (h << 5) + Objects.hashCode(this.imgSearchUsername);
        h += (h << 5) + Objects.hashCode(this.staticMapsProvider);
        h += (h << 5) + this.captionLengthMax;
        h += (h << 5) + this.messageLengthMax;
        h += (h << 5) + this.webfileDcId;
        h += (h << 5) + Objects.hashCode(this.suggestedLangCode);
        h += (h << 5) + Objects.hashCode(this.langPackVersion);
        h += (h << 5) + Objects.hashCode(this.baseLangPackVersion);
        return h;
    }

    public String toString() {
        return "Config{identifier=" + this.identifier + ", flags=" + this.flags + ", phonecallsEnabled=" + this.phonecallsEnabled + ", defaultP2pContacts=" + this.defaultP2pContacts + ", preloadFeaturedStickers=" + this.preloadFeaturedStickers + ", ignorePhoneEntities=" + this.ignorePhoneEntities + ", revokePmInbox=" + this.revokePmInbox + ", blockedMode=" + this.blockedMode + ", pfsEnabled=" + this.pfsEnabled + ", forceTryIpv6=" + this.forceTryIpv6 + ", date=" + this.date + ", expires=" + this.expires + ", testMode=" + this.testMode + ", thisDc=" + this.thisDc + ", dcOptions=" + this.dcOptions + ", dcTxtDomainName=" + this.dcTxtDomainName + ", chatSizeMax=" + this.chatSizeMax + ", megagroupSizeMax=" + this.megagroupSizeMax + ", forwardedCountMax=" + this.forwardedCountMax + ", onlineUpdatePeriodMs=" + this.onlineUpdatePeriodMs + ", offlineBlurTimeoutMs=" + this.offlineBlurTimeoutMs + ", offlineIdleTimeoutMs=" + this.offlineIdleTimeoutMs + ", onlineCloudTimeoutMs=" + this.onlineCloudTimeoutMs + ", notifyCloudDelayMs=" + this.notifyCloudDelayMs + ", notifyDefaultDelayMs=" + this.notifyDefaultDelayMs + ", pushChatPeriodMs=" + this.pushChatPeriodMs + ", pushChatLimit=" + this.pushChatLimit + ", savedGifsLimit=" + this.savedGifsLimit + ", editTimeLimit=" + this.editTimeLimit + ", revokeTimeLimit=" + this.revokeTimeLimit + ", revokePmTimeLimit=" + this.revokePmTimeLimit + ", ratingEDecay=" + this.ratingEDecay + ", stickersRecentLimit=" + this.stickersRecentLimit + ", stickersFavedLimit=" + this.stickersFavedLimit + ", channelsReadMediaPeriod=" + this.channelsReadMediaPeriod + ", tmpSessions=" + this.tmpSessions + ", pinnedDialogsCountMax=" + this.pinnedDialogsCountMax + ", pinnedInfolderCountMax=" + this.pinnedInfolderCountMax + ", callReceiveTimeoutMs=" + this.callReceiveTimeoutMs + ", callRingTimeoutMs=" + this.callRingTimeoutMs + ", callConnectTimeoutMs=" + this.callConnectTimeoutMs + ", callPacketTimeoutMs=" + this.callPacketTimeoutMs + ", meUrlPrefix=" + this.meUrlPrefix + ", autoupdateUrlPrefix=" + this.autoupdateUrlPrefix + ", gifSearchUsername=" + this.gifSearchUsername + ", venueSearchUsername=" + this.venueSearchUsername + ", imgSearchUsername=" + this.imgSearchUsername + ", staticMapsProvider=" + this.staticMapsProvider + ", captionLengthMax=" + this.captionLengthMax + ", messageLengthMax=" + this.messageLengthMax + ", webfileDcId=" + this.webfileDcId + ", suggestedLangCode=" + this.suggestedLangCode + ", langPackVersion=" + this.langPackVersion + ", baseLangPackVersion=" + this.baseLangPackVersion + "}";
    }

    public static ImmutableConfig of(int date, int expires, boolean testMode, int thisDc, String dcTxtDomainName, int chatSizeMax, int megagroupSizeMax, int forwardedCountMax, int onlineUpdatePeriodMs, int offlineBlurTimeoutMs, int offlineIdleTimeoutMs, int onlineCloudTimeoutMs, int notifyCloudDelayMs, int notifyDefaultDelayMs, int pushChatPeriodMs, int pushChatLimit, int savedGifsLimit, int editTimeLimit, int revokeTimeLimit, int revokePmTimeLimit, int ratingEDecay, int stickersRecentLimit, int stickersFavedLimit, int channelsReadMediaPeriod, int pinnedDialogsCountMax, int pinnedInfolderCountMax, int callReceiveTimeoutMs, int callRingTimeoutMs, int callConnectTimeoutMs, int callPacketTimeoutMs, String meUrlPrefix, int captionLengthMax, int messageLengthMax, int webfileDcId) {
        return new ImmutableConfig(date, expires, testMode, thisDc, dcTxtDomainName, chatSizeMax, megagroupSizeMax, forwardedCountMax, onlineUpdatePeriodMs, offlineBlurTimeoutMs, offlineIdleTimeoutMs, onlineCloudTimeoutMs, notifyCloudDelayMs, notifyDefaultDelayMs, pushChatPeriodMs, pushChatLimit, savedGifsLimit, editTimeLimit, revokeTimeLimit, revokePmTimeLimit, ratingEDecay, stickersRecentLimit, stickersFavedLimit, channelsReadMediaPeriod, pinnedDialogsCountMax, pinnedInfolderCountMax, callReceiveTimeoutMs, callRingTimeoutMs, callConnectTimeoutMs, callPacketTimeoutMs, meUrlPrefix, captionLengthMax, messageLengthMax, webfileDcId);
    }

    public static ImmutableConfig copyOf(Config instance) {
        if (instance instanceof ImmutableConfig) {
            return (ImmutableConfig)instance;
        }
        return ImmutableConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_DATE = 1L;
        private static final long INIT_BIT_EXPIRES = 2L;
        private static final long INIT_BIT_TEST_MODE = 4L;
        private static final long INIT_BIT_THIS_DC = 8L;
        private static final long INIT_BIT_DC_TXT_DOMAIN_NAME = 16L;
        private static final long INIT_BIT_CHAT_SIZE_MAX = 32L;
        private static final long INIT_BIT_MEGAGROUP_SIZE_MAX = 64L;
        private static final long INIT_BIT_FORWARDED_COUNT_MAX = 128L;
        private static final long INIT_BIT_ONLINE_UPDATE_PERIOD_MS = 256L;
        private static final long INIT_BIT_OFFLINE_BLUR_TIMEOUT_MS = 512L;
        private static final long INIT_BIT_OFFLINE_IDLE_TIMEOUT_MS = 1024L;
        private static final long INIT_BIT_ONLINE_CLOUD_TIMEOUT_MS = 2048L;
        private static final long INIT_BIT_NOTIFY_CLOUD_DELAY_MS = 4096L;
        private static final long INIT_BIT_NOTIFY_DEFAULT_DELAY_MS = 8192L;
        private static final long INIT_BIT_PUSH_CHAT_PERIOD_MS = 16384L;
        private static final long INIT_BIT_PUSH_CHAT_LIMIT = 32768L;
        private static final long INIT_BIT_SAVED_GIFS_LIMIT = 65536L;
        private static final long INIT_BIT_EDIT_TIME_LIMIT = 131072L;
        private static final long INIT_BIT_REVOKE_TIME_LIMIT = 262144L;
        private static final long INIT_BIT_REVOKE_PM_TIME_LIMIT = 524288L;
        private static final long INIT_BIT_RATING_E_DECAY = 0x100000L;
        private static final long INIT_BIT_STICKERS_RECENT_LIMIT = 0x200000L;
        private static final long INIT_BIT_STICKERS_FAVED_LIMIT = 0x400000L;
        private static final long INIT_BIT_CHANNELS_READ_MEDIA_PERIOD = 0x800000L;
        private static final long INIT_BIT_PINNED_DIALOGS_COUNT_MAX = 0x1000000L;
        private static final long INIT_BIT_PINNED_INFOLDER_COUNT_MAX = 0x2000000L;
        private static final long INIT_BIT_CALL_RECEIVE_TIMEOUT_MS = 0x4000000L;
        private static final long INIT_BIT_CALL_RING_TIMEOUT_MS = 0x8000000L;
        private static final long INIT_BIT_CALL_CONNECT_TIMEOUT_MS = 0x10000000L;
        private static final long INIT_BIT_CALL_PACKET_TIMEOUT_MS = 0x20000000L;
        private static final long INIT_BIT_ME_URL_PREFIX = 0x40000000L;
        private static final long INIT_BIT_CAPTION_LENGTH_MAX = 0x80000000L;
        private static final long INIT_BIT_MESSAGE_LENGTH_MAX = 0x100000000L;
        private static final long INIT_BIT_WEBFILE_DC_ID = 0x200000000L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_PHONECALLS_ENABLED = 4L;
        private static final long OPT_BIT_DEFAULT_P2P_CONTACTS = 8L;
        private static final long OPT_BIT_PRELOAD_FEATURED_STICKERS = 16L;
        private static final long OPT_BIT_IGNORE_PHONE_ENTITIES = 32L;
        private static final long OPT_BIT_REVOKE_PM_INBOX = 64L;
        private static final long OPT_BIT_BLOCKED_MODE = 128L;
        private static final long OPT_BIT_PFS_ENABLED = 256L;
        private static final long OPT_BIT_FORCE_TRY_IPV6 = 512L;
        private long initBits = 0x3FFFFFFFFL;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean phonecallsEnabled;
        private boolean defaultP2pContacts;
        private boolean preloadFeaturedStickers;
        private boolean ignorePhoneEntities;
        private boolean revokePmInbox;
        private boolean blockedMode;
        private boolean pfsEnabled;
        private boolean forceTryIpv6;
        private int date;
        private int expires;
        private boolean testMode;
        private int thisDc;
        private List<DcOption> dcOptions = new ArrayList<DcOption>();
        private String dcTxtDomainName;
        private int chatSizeMax;
        private int megagroupSizeMax;
        private int forwardedCountMax;
        private int onlineUpdatePeriodMs;
        private int offlineBlurTimeoutMs;
        private int offlineIdleTimeoutMs;
        private int onlineCloudTimeoutMs;
        private int notifyCloudDelayMs;
        private int notifyDefaultDelayMs;
        private int pushChatPeriodMs;
        private int pushChatLimit;
        private int savedGifsLimit;
        private int editTimeLimit;
        private int revokeTimeLimit;
        private int revokePmTimeLimit;
        private int ratingEDecay;
        private int stickersRecentLimit;
        private int stickersFavedLimit;
        private int channelsReadMediaPeriod;
        private Integer tmpSessions;
        private int pinnedDialogsCountMax;
        private int pinnedInfolderCountMax;
        private int callReceiveTimeoutMs;
        private int callRingTimeoutMs;
        private int callConnectTimeoutMs;
        private int callPacketTimeoutMs;
        private String meUrlPrefix;
        private String autoupdateUrlPrefix;
        private String gifSearchUsername;
        private String venueSearchUsername;
        private String imgSearchUsername;
        private String staticMapsProvider;
        private int captionLengthMax;
        private int messageLengthMax;
        private int webfileDcId;
        private String suggestedLangCode;
        private Integer langPackVersion;
        private Integer baseLangPackVersion;

        private Builder() {
        }

        public final Builder from(Config instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Config instance;
            long bits = 0L;
            if (object instanceof Config) {
                Integer baseLangPackVersionValue;
                String venueSearchUsernameValue;
                Integer tmpSessionsValue;
                instance = (Config)object;
                this.date(instance.date());
                this.pinnedDialogsCountMax(instance.pinnedDialogsCountMax());
                this.forceTryIpv6(instance.forceTryIpv6());
                this.callConnectTimeoutMs(instance.callConnectTimeoutMs());
                this.onlineCloudTimeoutMs(instance.onlineCloudTimeoutMs());
                this.pushChatPeriodMs(instance.pushChatPeriodMs());
                this.pfsEnabled(instance.pfsEnabled());
                this.addAllDcOptions(instance.dcOptions());
                String gifSearchUsernameValue = instance.gifSearchUsername();
                if (gifSearchUsernameValue != null) {
                    this.gifSearchUsername(gifSearchUsernameValue);
                }
                this.notifyCloudDelayMs(instance.notifyCloudDelayMs());
                this.callRingTimeoutMs(instance.callRingTimeoutMs());
                this.notifyDefaultDelayMs(instance.notifyDefaultDelayMs());
                this.pinnedInfolderCountMax(instance.pinnedInfolderCountMax());
                this.callReceiveTimeoutMs(instance.callReceiveTimeoutMs());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((tmpSessionsValue = instance.tmpSessions()) != null) {
                    this.tmpSessions(tmpSessionsValue);
                }
                if ((venueSearchUsernameValue = instance.venueSearchUsername()) != null) {
                    this.venueSearchUsername(venueSearchUsernameValue);
                }
                this.captionLengthMax(instance.captionLengthMax());
                this.forwardedCountMax(instance.forwardedCountMax());
                this.blockedMode(instance.blockedMode());
                this.revokePmTimeLimit(instance.revokePmTimeLimit());
                this.megagroupSizeMax(instance.megagroupSizeMax());
                this.messageLengthMax(instance.messageLengthMax());
                this.stickersRecentLimit(instance.stickersRecentLimit());
                this.onlineUpdatePeriodMs(instance.onlineUpdatePeriodMs());
                this.editTimeLimit(instance.editTimeLimit());
                this.expires(instance.expires());
                this.phonecallsEnabled(instance.phonecallsEnabled());
                this.stickersFavedLimit(instance.stickersFavedLimit());
                this.savedGifsLimit(instance.savedGifsLimit());
                this.flags(instance.flags());
                this.dcTxtDomainName(instance.dcTxtDomainName());
                String imgSearchUsernameValue = instance.imgSearchUsername();
                if (imgSearchUsernameValue != null) {
                    this.imgSearchUsername(imgSearchUsernameValue);
                }
                this.revokeTimeLimit(instance.revokeTimeLimit());
                this.defaultP2pContacts(instance.defaultP2pContacts());
                this.pushChatLimit(instance.pushChatLimit());
                String suggestedLangCodeValue = instance.suggestedLangCode();
                if (suggestedLangCodeValue != null) {
                    this.suggestedLangCode(suggestedLangCodeValue);
                }
                this.meUrlPrefix(instance.meUrlPrefix());
                this.chatSizeMax(instance.chatSizeMax());
                Integer langPackVersionValue = instance.langPackVersion();
                if (langPackVersionValue != null) {
                    this.langPackVersion(langPackVersionValue);
                }
                this.thisDc(instance.thisDc());
                this.callPacketTimeoutMs(instance.callPacketTimeoutMs());
                this.preloadFeaturedStickers(instance.preloadFeaturedStickers());
                this.revokePmInbox(instance.revokePmInbox());
                this.offlineBlurTimeoutMs(instance.offlineBlurTimeoutMs());
                this.webfileDcId(instance.webfileDcId());
                this.ignorePhoneEntities(instance.ignorePhoneEntities());
                this.testMode(instance.testMode());
                this.channelsReadMediaPeriod(instance.channelsReadMediaPeriod());
                this.ratingEDecay(instance.ratingEDecay());
                String autoupdateUrlPrefixValue = instance.autoupdateUrlPrefix();
                if (autoupdateUrlPrefixValue != null) {
                    this.autoupdateUrlPrefix(autoupdateUrlPrefixValue);
                }
                if ((baseLangPackVersionValue = instance.baseLangPackVersion()) != null) {
                    this.baseLangPackVersion(baseLangPackVersionValue);
                }
                this.offlineIdleTimeoutMs(instance.offlineIdleTimeoutMs());
                String staticMapsProviderValue = instance.staticMapsProvider();
                if (staticMapsProviderValue != null) {
                    this.staticMapsProvider(staticMapsProviderValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder phonecallsEnabled(boolean phonecallsEnabled) {
            this.phonecallsEnabled = phonecallsEnabled;
            this.optBits |= 4L;
            return this;
        }

        public final Builder defaultP2pContacts(boolean defaultP2pContacts) {
            this.defaultP2pContacts = defaultP2pContacts;
            this.optBits |= 8L;
            return this;
        }

        public final Builder preloadFeaturedStickers(boolean preloadFeaturedStickers) {
            this.preloadFeaturedStickers = preloadFeaturedStickers;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder ignorePhoneEntities(boolean ignorePhoneEntities) {
            this.ignorePhoneEntities = ignorePhoneEntities;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder revokePmInbox(boolean revokePmInbox) {
            this.revokePmInbox = revokePmInbox;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder blockedMode(boolean blockedMode) {
            this.blockedMode = blockedMode;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder pfsEnabled(boolean pfsEnabled) {
            this.pfsEnabled = pfsEnabled;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder forceTryIpv6(boolean forceTryIpv6) {
            this.forceTryIpv6 = forceTryIpv6;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder expires(int expires) {
            this.expires = expires;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder testMode(boolean testMode) {
            this.testMode = testMode;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder thisDc(int thisDc) {
            this.thisDc = thisDc;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder addDcOption(DcOption element) {
            this.dcOptions.add(Objects.requireNonNull(element, "dcOptions element"));
            return this;
        }

        public final Builder addDcOptions(DcOption ... elements) {
            for (DcOption element : elements) {
                this.dcOptions.add(Objects.requireNonNull(element, "dcOptions element"));
            }
            return this;
        }

        public final Builder dcOptions(Iterable<? extends DcOption> elements) {
            this.dcOptions.clear();
            return this.addAllDcOptions(elements);
        }

        public final Builder addAllDcOptions(Iterable<? extends DcOption> elements) {
            for (DcOption dcOption : elements) {
                this.dcOptions.add(Objects.requireNonNull(dcOption, "dcOptions element"));
            }
            return this;
        }

        public final Builder dcTxtDomainName(String dcTxtDomainName) {
            this.dcTxtDomainName = Objects.requireNonNull(dcTxtDomainName, "dcTxtDomainName");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder chatSizeMax(int chatSizeMax) {
            this.chatSizeMax = chatSizeMax;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder megagroupSizeMax(int megagroupSizeMax) {
            this.megagroupSizeMax = megagroupSizeMax;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder forwardedCountMax(int forwardedCountMax) {
            this.forwardedCountMax = forwardedCountMax;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder onlineUpdatePeriodMs(int onlineUpdatePeriodMs) {
            this.onlineUpdatePeriodMs = onlineUpdatePeriodMs;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder offlineBlurTimeoutMs(int offlineBlurTimeoutMs) {
            this.offlineBlurTimeoutMs = offlineBlurTimeoutMs;
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public final Builder offlineIdleTimeoutMs(int offlineIdleTimeoutMs) {
            this.offlineIdleTimeoutMs = offlineIdleTimeoutMs;
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public final Builder onlineCloudTimeoutMs(int onlineCloudTimeoutMs) {
            this.onlineCloudTimeoutMs = onlineCloudTimeoutMs;
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        public final Builder notifyCloudDelayMs(int notifyCloudDelayMs) {
            this.notifyCloudDelayMs = notifyCloudDelayMs;
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        public final Builder notifyDefaultDelayMs(int notifyDefaultDelayMs) {
            this.notifyDefaultDelayMs = notifyDefaultDelayMs;
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        public final Builder pushChatPeriodMs(int pushChatPeriodMs) {
            this.pushChatPeriodMs = pushChatPeriodMs;
            this.initBits &= 0xFFFFFFFFFFFFBFFFL;
            return this;
        }

        public final Builder pushChatLimit(int pushChatLimit) {
            this.pushChatLimit = pushChatLimit;
            this.initBits &= 0xFFFFFFFFFFFF7FFFL;
            return this;
        }

        public final Builder savedGifsLimit(int savedGifsLimit) {
            this.savedGifsLimit = savedGifsLimit;
            this.initBits &= 0xFFFFFFFFFFFEFFFFL;
            return this;
        }

        public final Builder editTimeLimit(int editTimeLimit) {
            this.editTimeLimit = editTimeLimit;
            this.initBits &= 0xFFFFFFFFFFFDFFFFL;
            return this;
        }

        public final Builder revokeTimeLimit(int revokeTimeLimit) {
            this.revokeTimeLimit = revokeTimeLimit;
            this.initBits &= 0xFFFFFFFFFFFBFFFFL;
            return this;
        }

        public final Builder revokePmTimeLimit(int revokePmTimeLimit) {
            this.revokePmTimeLimit = revokePmTimeLimit;
            this.initBits &= 0xFFFFFFFFFFF7FFFFL;
            return this;
        }

        public final Builder ratingEDecay(int ratingEDecay) {
            this.ratingEDecay = ratingEDecay;
            this.initBits &= 0xFFFFFFFFFFEFFFFFL;
            return this;
        }

        public final Builder stickersRecentLimit(int stickersRecentLimit) {
            this.stickersRecentLimit = stickersRecentLimit;
            this.initBits &= 0xFFFFFFFFFFDFFFFFL;
            return this;
        }

        public final Builder stickersFavedLimit(int stickersFavedLimit) {
            this.stickersFavedLimit = stickersFavedLimit;
            this.initBits &= 0xFFFFFFFFFFBFFFFFL;
            return this;
        }

        public final Builder channelsReadMediaPeriod(int channelsReadMediaPeriod) {
            this.channelsReadMediaPeriod = channelsReadMediaPeriod;
            this.initBits &= 0xFFFFFFFFFF7FFFFFL;
            return this;
        }

        public final Builder tmpSessions(@Nullable Integer tmpSessions) {
            this.tmpSessions = tmpSessions;
            return this;
        }

        public final Builder pinnedDialogsCountMax(int pinnedDialogsCountMax) {
            this.pinnedDialogsCountMax = pinnedDialogsCountMax;
            this.initBits &= 0xFFFFFFFFFEFFFFFFL;
            return this;
        }

        public final Builder pinnedInfolderCountMax(int pinnedInfolderCountMax) {
            this.pinnedInfolderCountMax = pinnedInfolderCountMax;
            this.initBits &= 0xFFFFFFFFFDFFFFFFL;
            return this;
        }

        public final Builder callReceiveTimeoutMs(int callReceiveTimeoutMs) {
            this.callReceiveTimeoutMs = callReceiveTimeoutMs;
            this.initBits &= 0xFFFFFFFFFBFFFFFFL;
            return this;
        }

        public final Builder callRingTimeoutMs(int callRingTimeoutMs) {
            this.callRingTimeoutMs = callRingTimeoutMs;
            this.initBits &= 0xFFFFFFFFF7FFFFFFL;
            return this;
        }

        public final Builder callConnectTimeoutMs(int callConnectTimeoutMs) {
            this.callConnectTimeoutMs = callConnectTimeoutMs;
            this.initBits &= 0xFFFFFFFFEFFFFFFFL;
            return this;
        }

        public final Builder callPacketTimeoutMs(int callPacketTimeoutMs) {
            this.callPacketTimeoutMs = callPacketTimeoutMs;
            this.initBits &= 0xFFFFFFFFDFFFFFFFL;
            return this;
        }

        public final Builder meUrlPrefix(String meUrlPrefix) {
            this.meUrlPrefix = Objects.requireNonNull(meUrlPrefix, "meUrlPrefix");
            this.initBits &= 0xFFFFFFFFBFFFFFFFL;
            return this;
        }

        public final Builder autoupdateUrlPrefix(@Nullable String autoupdateUrlPrefix) {
            this.autoupdateUrlPrefix = autoupdateUrlPrefix;
            return this;
        }

        public final Builder gifSearchUsername(@Nullable String gifSearchUsername) {
            this.gifSearchUsername = gifSearchUsername;
            return this;
        }

        public final Builder venueSearchUsername(@Nullable String venueSearchUsername) {
            this.venueSearchUsername = venueSearchUsername;
            return this;
        }

        public final Builder imgSearchUsername(@Nullable String imgSearchUsername) {
            this.imgSearchUsername = imgSearchUsername;
            return this;
        }

        public final Builder staticMapsProvider(@Nullable String staticMapsProvider) {
            this.staticMapsProvider = staticMapsProvider;
            return this;
        }

        public final Builder captionLengthMax(int captionLengthMax) {
            this.captionLengthMax = captionLengthMax;
            this.initBits &= 0xFFFFFFFF7FFFFFFFL;
            return this;
        }

        public final Builder messageLengthMax(int messageLengthMax) {
            this.messageLengthMax = messageLengthMax;
            this.initBits &= 0xFFFFFFFEFFFFFFFFL;
            return this;
        }

        public final Builder webfileDcId(int webfileDcId) {
            this.webfileDcId = webfileDcId;
            this.initBits &= 0xFFFFFFFDFFFFFFFFL;
            return this;
        }

        public final Builder suggestedLangCode(@Nullable String suggestedLangCode) {
            this.suggestedLangCode = suggestedLangCode;
            return this;
        }

        public final Builder langPackVersion(@Nullable Integer langPackVersion) {
            this.langPackVersion = langPackVersion;
            return this;
        }

        public final Builder baseLangPackVersion(@Nullable Integer baseLangPackVersion) {
            this.baseLangPackVersion = baseLangPackVersion;
            return this;
        }

        public ImmutableConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfig(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean phonecallsEnabledIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean defaultP2pContactsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean preloadFeaturedStickersIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean ignorePhoneEntitiesIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean revokePmInboxIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean blockedModeIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean pfsEnabledIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean forceTryIpv6IsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expires");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("testMode");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("thisDc");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("dcTxtDomainName");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("chatSizeMax");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("megagroupSizeMax");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("forwardedCountMax");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("onlineUpdatePeriodMs");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("offlineBlurTimeoutMs");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("offlineIdleTimeoutMs");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("onlineCloudTimeoutMs");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("notifyCloudDelayMs");
            }
            if ((this.initBits & 0x2000L) != 0L) {
                attributes.add("notifyDefaultDelayMs");
            }
            if ((this.initBits & 0x4000L) != 0L) {
                attributes.add("pushChatPeriodMs");
            }
            if ((this.initBits & 0x8000L) != 0L) {
                attributes.add("pushChatLimit");
            }
            if ((this.initBits & 0x10000L) != 0L) {
                attributes.add("savedGifsLimit");
            }
            if ((this.initBits & 0x20000L) != 0L) {
                attributes.add("editTimeLimit");
            }
            if ((this.initBits & 0x40000L) != 0L) {
                attributes.add("revokeTimeLimit");
            }
            if ((this.initBits & 0x80000L) != 0L) {
                attributes.add("revokePmTimeLimit");
            }
            if ((this.initBits & 0x100000L) != 0L) {
                attributes.add("ratingEDecay");
            }
            if ((this.initBits & 0x200000L) != 0L) {
                attributes.add("stickersRecentLimit");
            }
            if ((this.initBits & 0x400000L) != 0L) {
                attributes.add("stickersFavedLimit");
            }
            if ((this.initBits & 0x800000L) != 0L) {
                attributes.add("channelsReadMediaPeriod");
            }
            if ((this.initBits & 0x1000000L) != 0L) {
                attributes.add("pinnedDialogsCountMax");
            }
            if ((this.initBits & 0x2000000L) != 0L) {
                attributes.add("pinnedInfolderCountMax");
            }
            if ((this.initBits & 0x4000000L) != 0L) {
                attributes.add("callReceiveTimeoutMs");
            }
            if ((this.initBits & 0x8000000L) != 0L) {
                attributes.add("callRingTimeoutMs");
            }
            if ((this.initBits & 0x10000000L) != 0L) {
                attributes.add("callConnectTimeoutMs");
            }
            if ((this.initBits & 0x20000000L) != 0L) {
                attributes.add("callPacketTimeoutMs");
            }
            if ((this.initBits & 0x40000000L) != 0L) {
                attributes.add("meUrlPrefix");
            }
            if ((this.initBits & 0x80000000L) != 0L) {
                attributes.add("captionLengthMax");
            }
            if ((this.initBits & 0x100000000L) != 0L) {
                attributes.add("messageLengthMax");
            }
            if ((this.initBits & 0x200000000L) != 0L) {
                attributes.add("webfileDcId");
            }
            return "Cannot build Config, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte phonecallsEnabledBuildStage = 0;
        private boolean phonecallsEnabled;
        private byte defaultP2pContactsBuildStage = 0;
        private boolean defaultP2pContacts;
        private byte preloadFeaturedStickersBuildStage = 0;
        private boolean preloadFeaturedStickers;
        private byte ignorePhoneEntitiesBuildStage = 0;
        private boolean ignorePhoneEntities;
        private byte revokePmInboxBuildStage = 0;
        private boolean revokePmInbox;
        private byte blockedModeBuildStage = 0;
        private boolean blockedMode;
        private byte pfsEnabledBuildStage = 0;
        private boolean pfsEnabled;
        private byte forceTryIpv6BuildStage = 0;
        private boolean forceTryIpv6;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableConfig.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableConfig.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean phonecallsEnabled() {
            if (this.phonecallsEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.phonecallsEnabledBuildStage == 0) {
                this.phonecallsEnabledBuildStage = (byte)-1;
                this.phonecallsEnabled = ImmutableConfig.this.phonecallsEnabledInitialize();
                this.phonecallsEnabledBuildStage = 1;
            }
            return this.phonecallsEnabled;
        }

        void phonecallsEnabled(boolean phonecallsEnabled) {
            this.phonecallsEnabled = phonecallsEnabled;
            this.phonecallsEnabledBuildStage = 1;
        }

        boolean defaultP2pContacts() {
            if (this.defaultP2pContactsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultP2pContactsBuildStage == 0) {
                this.defaultP2pContactsBuildStage = (byte)-1;
                this.defaultP2pContacts = ImmutableConfig.this.defaultP2pContactsInitialize();
                this.defaultP2pContactsBuildStage = 1;
            }
            return this.defaultP2pContacts;
        }

        void defaultP2pContacts(boolean defaultP2pContacts) {
            this.defaultP2pContacts = defaultP2pContacts;
            this.defaultP2pContactsBuildStage = 1;
        }

        boolean preloadFeaturedStickers() {
            if (this.preloadFeaturedStickersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.preloadFeaturedStickersBuildStage == 0) {
                this.preloadFeaturedStickersBuildStage = (byte)-1;
                this.preloadFeaturedStickers = ImmutableConfig.this.preloadFeaturedStickersInitialize();
                this.preloadFeaturedStickersBuildStage = 1;
            }
            return this.preloadFeaturedStickers;
        }

        void preloadFeaturedStickers(boolean preloadFeaturedStickers) {
            this.preloadFeaturedStickers = preloadFeaturedStickers;
            this.preloadFeaturedStickersBuildStage = 1;
        }

        boolean ignorePhoneEntities() {
            if (this.ignorePhoneEntitiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ignorePhoneEntitiesBuildStage == 0) {
                this.ignorePhoneEntitiesBuildStage = (byte)-1;
                this.ignorePhoneEntities = ImmutableConfig.this.ignorePhoneEntitiesInitialize();
                this.ignorePhoneEntitiesBuildStage = 1;
            }
            return this.ignorePhoneEntities;
        }

        void ignorePhoneEntities(boolean ignorePhoneEntities) {
            this.ignorePhoneEntities = ignorePhoneEntities;
            this.ignorePhoneEntitiesBuildStage = 1;
        }

        boolean revokePmInbox() {
            if (this.revokePmInboxBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.revokePmInboxBuildStage == 0) {
                this.revokePmInboxBuildStage = (byte)-1;
                this.revokePmInbox = ImmutableConfig.this.revokePmInboxInitialize();
                this.revokePmInboxBuildStage = 1;
            }
            return this.revokePmInbox;
        }

        void revokePmInbox(boolean revokePmInbox) {
            this.revokePmInbox = revokePmInbox;
            this.revokePmInboxBuildStage = 1;
        }

        boolean blockedMode() {
            if (this.blockedModeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.blockedModeBuildStage == 0) {
                this.blockedModeBuildStage = (byte)-1;
                this.blockedMode = ImmutableConfig.this.blockedModeInitialize();
                this.blockedModeBuildStage = 1;
            }
            return this.blockedMode;
        }

        void blockedMode(boolean blockedMode) {
            this.blockedMode = blockedMode;
            this.blockedModeBuildStage = 1;
        }

        boolean pfsEnabled() {
            if (this.pfsEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pfsEnabledBuildStage == 0) {
                this.pfsEnabledBuildStage = (byte)-1;
                this.pfsEnabled = ImmutableConfig.this.pfsEnabledInitialize();
                this.pfsEnabledBuildStage = 1;
            }
            return this.pfsEnabled;
        }

        void pfsEnabled(boolean pfsEnabled) {
            this.pfsEnabled = pfsEnabled;
            this.pfsEnabledBuildStage = 1;
        }

        boolean forceTryIpv6() {
            if (this.forceTryIpv6BuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forceTryIpv6BuildStage == 0) {
                this.forceTryIpv6BuildStage = (byte)-1;
                this.forceTryIpv6 = ImmutableConfig.this.forceTryIpv6Initialize();
                this.forceTryIpv6BuildStage = 1;
            }
            return this.forceTryIpv6;
        }

        void forceTryIpv6(boolean forceTryIpv6) {
            this.forceTryIpv6 = forceTryIpv6;
            this.forceTryIpv6BuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.phonecallsEnabledBuildStage == -1) {
                attributes.add("phonecallsEnabled");
            }
            if (this.defaultP2pContactsBuildStage == -1) {
                attributes.add("defaultP2pContacts");
            }
            if (this.preloadFeaturedStickersBuildStage == -1) {
                attributes.add("preloadFeaturedStickers");
            }
            if (this.ignorePhoneEntitiesBuildStage == -1) {
                attributes.add("ignorePhoneEntities");
            }
            if (this.revokePmInboxBuildStage == -1) {
                attributes.add("revokePmInbox");
            }
            if (this.blockedModeBuildStage == -1) {
                attributes.add("blockedMode");
            }
            if (this.pfsEnabledBuildStage == -1) {
                attributes.add("pfsEnabled");
            }
            if (this.forceTryIpv6BuildStage == -1) {
                attributes.add("forceTryIpv6");
            }
            return "Cannot build Config, attribute initializers form cycle " + attributes;
        }
    }
}

