/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Contact;
import telegram4j.tl.api.TlObject;

public final class ImmutableContact
implements Contact {
    private final int identifier;
    private final long userId;
    private final boolean mutual;

    private ImmutableContact(long userId, boolean mutual) {
        this.userId = userId;
        this.mutual = mutual;
        this.identifier = Contact.super.identifier();
    }

    private ImmutableContact(Builder builder) {
        this.userId = builder.userId;
        this.mutual = builder.mutual;
        this.identifier = builder.identifierIsSet() ? builder.identifier : Contact.super.identifier();
    }

    private ImmutableContact(int identifier, long userId, boolean mutual) {
        this.identifier = identifier;
        this.userId = userId;
        this.mutual = mutual;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public boolean mutual() {
        return this.mutual;
    }

    public final ImmutableContact withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableContact(value, this.userId, this.mutual);
    }

    public final ImmutableContact withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableContact(this.identifier, value, this.mutual);
    }

    public final ImmutableContact withMutual(boolean value) {
        if (this.mutual == value) {
            return this;
        }
        return new ImmutableContact(this.identifier, this.userId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContact && this.equalTo(0, (ImmutableContact)another);
    }

    private boolean equalTo(int synthetic, ImmutableContact another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.mutual == another.mutual;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + Boolean.hashCode(this.mutual);
        return h;
    }

    public String toString() {
        return "Contact{identifier=" + this.identifier + ", userId=" + this.userId + ", mutual=" + this.mutual + "}";
    }

    public static ImmutableContact of(long userId, boolean mutual) {
        return new ImmutableContact(userId, mutual);
    }

    public static ImmutableContact copyOf(Contact instance) {
        if (instance instanceof ImmutableContact) {
            return (ImmutableContact)instance;
        }
        return ImmutableContact.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_MUTUAL = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long userId;
        private boolean mutual;

        private Builder() {
        }

        public final Builder from(Contact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Contact instance;
            long bits = 0L;
            if (object instanceof Contact) {
                instance = (Contact)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.userId(instance.userId());
                this.mutual(instance.mutual());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder mutual(boolean mutual) {
            this.mutual = mutual;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableContact build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContact(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mutual");
            }
            return "Cannot build Contact, some of required attributes are not set " + attributes;
        }
    }
}

