/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ContactStatus;
import telegram4j.tl.UserStatus;
import telegram4j.tl.api.TlObject;

public final class ImmutableContactStatus
implements ContactStatus {
    private final int identifier;
    private final long userId;
    private final UserStatus status;

    private ImmutableContactStatus(long userId, UserStatus status) {
        this.userId = userId;
        this.status = Objects.requireNonNull(status, "status");
        this.identifier = ContactStatus.super.identifier();
    }

    private ImmutableContactStatus(Builder builder) {
        this.userId = builder.userId;
        this.status = builder.status;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ContactStatus.super.identifier();
    }

    private ImmutableContactStatus(int identifier, long userId, UserStatus status) {
        this.identifier = identifier;
        this.userId = userId;
        this.status = status;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public UserStatus status() {
        return this.status;
    }

    public final ImmutableContactStatus withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableContactStatus(value, this.userId, this.status);
    }

    public final ImmutableContactStatus withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableContactStatus(this.identifier, value, this.status);
    }

    public final ImmutableContactStatus withStatus(UserStatus value) {
        if (this.status == value) {
            return this;
        }
        UserStatus newValue = Objects.requireNonNull(value, "status");
        return new ImmutableContactStatus(this.identifier, this.userId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContactStatus && this.equalTo(0, (ImmutableContactStatus)another);
    }

    private boolean equalTo(int synthetic, ImmutableContactStatus another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.status.equals(another.status);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.status.hashCode();
        return h;
    }

    public String toString() {
        return "ContactStatus{identifier=" + this.identifier + ", userId=" + this.userId + ", status=" + this.status + "}";
    }

    public static ImmutableContactStatus of(long userId, UserStatus status) {
        return new ImmutableContactStatus(userId, status);
    }

    public static ImmutableContactStatus copyOf(ContactStatus instance) {
        if (instance instanceof ImmutableContactStatus) {
            return (ImmutableContactStatus)instance;
        }
        return ImmutableContactStatus.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_STATUS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long userId;
        private UserStatus status;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ContactStatus instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ContactStatus) {
                instance = (ContactStatus)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.userId(instance.userId());
                this.status(instance.status());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder status(UserStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableContactStatus build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContactStatus(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build ContactStatus, some of required attributes are not set " + attributes;
        }
    }
}

