/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;
import telegram4j.tl.DcOption;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableDcOption
implements DcOption {
    private final int identifier;
    private final int flags;
    private final boolean ipv6;
    private final boolean mediaOnly;
    private final boolean tcpoOnly;
    private final boolean cdn;
    private final boolean isStatic;
    private final boolean thisPortOnly;
    private final int id;
    private final String ipAddress;
    private final int port;
    private final ByteBuf secret;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDcOption(int id, String ipAddress, int port) {
        this.id = id;
        this.ipAddress = Objects.requireNonNull(ipAddress, "ipAddress");
        this.port = port;
        this.secret = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.ipv6 = this.initShim.ipv6();
        this.mediaOnly = this.initShim.mediaOnly();
        this.tcpoOnly = this.initShim.tcpoOnly();
        this.cdn = this.initShim.cdn();
        this.isStatic = this.initShim.isStatic();
        this.thisPortOnly = this.initShim.thisPortOnly();
        this.initShim = null;
    }

    private ImmutableDcOption(Builder builder) {
        this.id = builder.id;
        this.ipAddress = builder.ipAddress;
        this.port = builder.port;
        this.secret = builder.secret_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.ipv6IsSet()) {
            this.initShim.ipv6(builder.ipv6);
        }
        if (builder.mediaOnlyIsSet()) {
            this.initShim.mediaOnly(builder.mediaOnly);
        }
        if (builder.tcpoOnlyIsSet()) {
            this.initShim.tcpoOnly(builder.tcpoOnly);
        }
        if (builder.cdnIsSet()) {
            this.initShim.cdn(builder.cdn);
        }
        if (builder.isStaticIsSet()) {
            this.initShim.isStatic(builder.isStatic);
        }
        if (builder.thisPortOnlyIsSet()) {
            this.initShim.thisPortOnly(builder.thisPortOnly);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.ipv6 = this.initShim.ipv6();
        this.mediaOnly = this.initShim.mediaOnly();
        this.tcpoOnly = this.initShim.tcpoOnly();
        this.cdn = this.initShim.cdn();
        this.isStatic = this.initShim.isStatic();
        this.thisPortOnly = this.initShim.thisPortOnly();
        this.initShim = null;
    }

    private ImmutableDcOption(int identifier, int flags, boolean ipv6, boolean mediaOnly, boolean tcpoOnly, boolean cdn, boolean isStatic, boolean thisPortOnly, int id, String ipAddress, int port, ByteBuf secret) {
        this.identifier = identifier;
        this.flags = flags;
        this.ipv6 = ipv6;
        this.mediaOnly = mediaOnly;
        this.tcpoOnly = tcpoOnly;
        this.cdn = cdn;
        this.isStatic = isStatic;
        this.thisPortOnly = thisPortOnly;
        this.id = id;
        this.ipAddress = ipAddress;
        this.port = port;
        this.secret = secret;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DcOption.super.identifier();
    }

    private int flagsInitialize() {
        return DcOption.super.flags();
    }

    private boolean ipv6Initialize() {
        return DcOption.super.ipv6();
    }

    private boolean mediaOnlyInitialize() {
        return DcOption.super.mediaOnly();
    }

    private boolean tcpoOnlyInitialize() {
        return DcOption.super.tcpoOnly();
    }

    private boolean cdnInitialize() {
        return DcOption.super.cdn();
    }

    private boolean isStaticInitialize() {
        return DcOption.super.isStatic();
    }

    private boolean thisPortOnlyInitialize() {
        return DcOption.super.thisPortOnly();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean ipv6() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ipv6() : this.ipv6;
    }

    @Override
    public boolean mediaOnly() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mediaOnly() : this.mediaOnly;
    }

    @Override
    public boolean tcpoOnly() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tcpoOnly() : this.tcpoOnly;
    }

    @Override
    public boolean cdn() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cdn() : this.cdn;
    }

    @Override
    public boolean isStatic() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isStatic() : this.isStatic;
    }

    @Override
    public boolean thisPortOnly() {
        InitShim shim = this.initShim;
        return shim != null ? shim.thisPortOnly() : this.thisPortOnly;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String ipAddress() {
        return this.ipAddress;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public Optional<ByteBuf> secret() {
        return Optional.ofNullable(this.secret).map(ByteBuf::duplicate);
    }

    public final ImmutableDcOption withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDcOption(value, this.flags, this.ipv6, this.mediaOnly, this.tcpoOnly, this.cdn, this.isStatic, this.thisPortOnly, this.id, this.ipAddress, this.port, this.secret);
    }

    public final ImmutableDcOption withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableDcOption(this.identifier, value, this.ipv6, this.mediaOnly, this.tcpoOnly, this.cdn, this.isStatic, this.thisPortOnly, this.id, this.ipAddress, this.port, this.secret);
    }

    public final ImmutableDcOption withIpv6(boolean value) {
        if (this.ipv6 == value) {
            return this;
        }
        return new ImmutableDcOption(this.identifier, this.flags, value, this.mediaOnly, this.tcpoOnly, this.cdn, this.isStatic, this.thisPortOnly, this.id, this.ipAddress, this.port, this.secret);
    }

    public final ImmutableDcOption withMediaOnly(boolean value) {
        if (this.mediaOnly == value) {
            return this;
        }
        return new ImmutableDcOption(this.identifier, this.flags, this.ipv6, value, this.tcpoOnly, this.cdn, this.isStatic, this.thisPortOnly, this.id, this.ipAddress, this.port, this.secret);
    }

    public final ImmutableDcOption withTcpoOnly(boolean value) {
        if (this.tcpoOnly == value) {
            return this;
        }
        return new ImmutableDcOption(this.identifier, this.flags, this.ipv6, this.mediaOnly, value, this.cdn, this.isStatic, this.thisPortOnly, this.id, this.ipAddress, this.port, this.secret);
    }

    public final ImmutableDcOption withCdn(boolean value) {
        if (this.cdn == value) {
            return this;
        }
        return new ImmutableDcOption(this.identifier, this.flags, this.ipv6, this.mediaOnly, this.tcpoOnly, value, this.isStatic, this.thisPortOnly, this.id, this.ipAddress, this.port, this.secret);
    }

    public final ImmutableDcOption withIsStatic(boolean value) {
        if (this.isStatic == value) {
            return this;
        }
        return new ImmutableDcOption(this.identifier, this.flags, this.ipv6, this.mediaOnly, this.tcpoOnly, this.cdn, value, this.thisPortOnly, this.id, this.ipAddress, this.port, this.secret);
    }

    public final ImmutableDcOption withThisPortOnly(boolean value) {
        if (this.thisPortOnly == value) {
            return this;
        }
        return new ImmutableDcOption(this.identifier, this.flags, this.ipv6, this.mediaOnly, this.tcpoOnly, this.cdn, this.isStatic, value, this.id, this.ipAddress, this.port, this.secret);
    }

    public final ImmutableDcOption withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableDcOption(this.identifier, this.flags, this.ipv6, this.mediaOnly, this.tcpoOnly, this.cdn, this.isStatic, this.thisPortOnly, value, this.ipAddress, this.port, this.secret);
    }

    public final ImmutableDcOption withIpAddress(String value) {
        String newValue = Objects.requireNonNull(value, "ipAddress");
        if (this.ipAddress.equals(newValue)) {
            return this;
        }
        return new ImmutableDcOption(this.identifier, this.flags, this.ipv6, this.mediaOnly, this.tcpoOnly, this.cdn, this.isStatic, this.thisPortOnly, this.id, newValue, this.port, this.secret);
    }

    public final ImmutableDcOption withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableDcOption(this.identifier, this.flags, this.ipv6, this.mediaOnly, this.tcpoOnly, this.cdn, this.isStatic, this.thisPortOnly, this.id, this.ipAddress, value, this.secret);
    }

    public ImmutableDcOption withSecret(Optional<ByteBuf> value) {
        ByteBuf newValue = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
        if (this.secret == newValue) {
            return this;
        }
        return new ImmutableDcOption(this.identifier, this.flags, this.ipv6, this.mediaOnly, this.tcpoOnly, this.cdn, this.isStatic, this.thisPortOnly, this.id, this.ipAddress, this.port, newValue);
    }

    public ImmutableDcOption withSecret(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.secret == newValue) {
            return this;
        }
        return new ImmutableDcOption(this.identifier, this.flags, this.ipv6, this.mediaOnly, this.tcpoOnly, this.cdn, this.isStatic, this.thisPortOnly, this.id, this.ipAddress, this.port, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDcOption && this.equalTo(0, (ImmutableDcOption)another);
    }

    private boolean equalTo(int synthetic, ImmutableDcOption another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.ipv6 == another.ipv6 && this.mediaOnly == another.mediaOnly && this.tcpoOnly == another.tcpoOnly && this.cdn == another.cdn && this.isStatic == another.isStatic && this.thisPortOnly == another.thisPortOnly && this.id == another.id && this.ipAddress.equals(another.ipAddress) && this.port == another.port && this.secret().equals(another.secret());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.ipv6);
        h += (h << 5) + Boolean.hashCode(this.mediaOnly);
        h += (h << 5) + Boolean.hashCode(this.tcpoOnly);
        h += (h << 5) + Boolean.hashCode(this.cdn);
        h += (h << 5) + Boolean.hashCode(this.isStatic);
        h += (h << 5) + Boolean.hashCode(this.thisPortOnly);
        h += (h << 5) + this.id;
        h += (h << 5) + this.ipAddress.hashCode();
        h += (h << 5) + this.port;
        h += (h << 5) + this.secret().hashCode();
        return h;
    }

    public String toString() {
        return "DcOption{identifier=" + this.identifier + ", flags=" + this.flags + ", ipv6=" + this.ipv6 + ", mediaOnly=" + this.mediaOnly + ", tcpoOnly=" + this.tcpoOnly + ", cdn=" + this.cdn + ", isStatic=" + this.isStatic + ", thisPortOnly=" + this.thisPortOnly + ", id=" + this.id + ", ipAddress=" + this.ipAddress + ", port=" + this.port + ", secret=" + this.secret().map(ByteBufUtil::hexDump).toString() + "}";
    }

    public static ImmutableDcOption of(int id, String ipAddress, int port) {
        return new ImmutableDcOption(id, ipAddress, port);
    }

    public static ImmutableDcOption copyOf(DcOption instance) {
        if (instance instanceof ImmutableDcOption) {
            return (ImmutableDcOption)instance;
        }
        return ImmutableDcOption.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_IP_ADDRESS = 2L;
        private static final long INIT_BIT_PORT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_IPV6 = 4L;
        private static final long OPT_BIT_MEDIA_ONLY = 8L;
        private static final long OPT_BIT_TCPO_ONLY = 16L;
        private static final long OPT_BIT_CDN = 32L;
        private static final long OPT_BIT_IS_STATIC = 64L;
        private static final long OPT_BIT_THIS_PORT_ONLY = 128L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf secret_value = null;
        private int identifier;
        private int flags;
        private boolean ipv6;
        private boolean mediaOnly;
        private boolean tcpoOnly;
        private boolean cdn;
        private boolean isStatic;
        private boolean thisPortOnly;
        private int id;
        private String ipAddress;
        private int port;

        private Builder() {
        }

        public final Builder from(DcOption instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DcOption instance;
            long bits = 0L;
            if (object instanceof DcOption) {
                instance = (DcOption)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.mediaOnly(instance.mediaOnly());
                this.isStatic(instance.isStatic());
                this.port(instance.port());
                this.ipv6(instance.ipv6());
                this.flags(instance.flags());
                this.ipAddress(instance.ipAddress());
                this.tcpoOnly(instance.tcpoOnly());
                this.id(instance.id());
                this.secret(instance.secret());
                this.cdn(instance.cdn());
                this.thisPortOnly(instance.thisPortOnly());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder ipv6(boolean ipv6) {
            this.ipv6 = ipv6;
            this.optBits |= 4L;
            return this;
        }

        public final Builder mediaOnly(boolean mediaOnly) {
            this.mediaOnly = mediaOnly;
            this.optBits |= 8L;
            return this;
        }

        public final Builder tcpoOnly(boolean tcpoOnly) {
            this.tcpoOnly = tcpoOnly;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder cdn(boolean cdn) {
            this.cdn = cdn;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder isStatic(boolean isStatic) {
            this.isStatic = isStatic;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder thisPortOnly(boolean thisPortOnly) {
            this.thisPortOnly = thisPortOnly;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = Objects.requireNonNull(ipAddress, "ipAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder secret(@Nullable ByteBuf value) {
            this.secret_value = value != null ? TlEncodingUtil.copyAsUnpooled((ByteBuf)value) : null;
            return this;
        }

        public Builder secret(Optional<ByteBuf> value) {
            this.secret_value = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
            return this;
        }

        public ImmutableDcOption build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDcOption(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean ipv6IsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean mediaOnlyIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean tcpoOnlyIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean cdnIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean isStaticIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean thisPortOnlyIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ipAddress");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build DcOption, some of required attributes are not set " + attributes;
        }

        private ByteBuf secret_build() {
            return this.secret_value;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte ipv6BuildStage = 0;
        private boolean ipv6;
        private byte mediaOnlyBuildStage = 0;
        private boolean mediaOnly;
        private byte tcpoOnlyBuildStage = 0;
        private boolean tcpoOnly;
        private byte cdnBuildStage = 0;
        private boolean cdn;
        private byte isStaticBuildStage = 0;
        private boolean isStatic;
        private byte thisPortOnlyBuildStage = 0;
        private boolean thisPortOnly;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDcOption.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableDcOption.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean ipv6() {
            if (this.ipv6BuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ipv6BuildStage == 0) {
                this.ipv6BuildStage = (byte)-1;
                this.ipv6 = ImmutableDcOption.this.ipv6Initialize();
                this.ipv6BuildStage = 1;
            }
            return this.ipv6;
        }

        void ipv6(boolean ipv6) {
            this.ipv6 = ipv6;
            this.ipv6BuildStage = 1;
        }

        boolean mediaOnly() {
            if (this.mediaOnlyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mediaOnlyBuildStage == 0) {
                this.mediaOnlyBuildStage = (byte)-1;
                this.mediaOnly = ImmutableDcOption.this.mediaOnlyInitialize();
                this.mediaOnlyBuildStage = 1;
            }
            return this.mediaOnly;
        }

        void mediaOnly(boolean mediaOnly) {
            this.mediaOnly = mediaOnly;
            this.mediaOnlyBuildStage = 1;
        }

        boolean tcpoOnly() {
            if (this.tcpoOnlyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tcpoOnlyBuildStage == 0) {
                this.tcpoOnlyBuildStage = (byte)-1;
                this.tcpoOnly = ImmutableDcOption.this.tcpoOnlyInitialize();
                this.tcpoOnlyBuildStage = 1;
            }
            return this.tcpoOnly;
        }

        void tcpoOnly(boolean tcpoOnly) {
            this.tcpoOnly = tcpoOnly;
            this.tcpoOnlyBuildStage = 1;
        }

        boolean cdn() {
            if (this.cdnBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cdnBuildStage == 0) {
                this.cdnBuildStage = (byte)-1;
                this.cdn = ImmutableDcOption.this.cdnInitialize();
                this.cdnBuildStage = 1;
            }
            return this.cdn;
        }

        void cdn(boolean cdn) {
            this.cdn = cdn;
            this.cdnBuildStage = 1;
        }

        boolean isStatic() {
            if (this.isStaticBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isStaticBuildStage == 0) {
                this.isStaticBuildStage = (byte)-1;
                this.isStatic = ImmutableDcOption.this.isStaticInitialize();
                this.isStaticBuildStage = 1;
            }
            return this.isStatic;
        }

        void isStatic(boolean isStatic) {
            this.isStatic = isStatic;
            this.isStaticBuildStage = 1;
        }

        boolean thisPortOnly() {
            if (this.thisPortOnlyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.thisPortOnlyBuildStage == 0) {
                this.thisPortOnlyBuildStage = (byte)-1;
                this.thisPortOnly = ImmutableDcOption.this.thisPortOnlyInitialize();
                this.thisPortOnlyBuildStage = 1;
            }
            return this.thisPortOnly;
        }

        void thisPortOnly(boolean thisPortOnly) {
            this.thisPortOnly = thisPortOnly;
            this.thisPortOnlyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.ipv6BuildStage == -1) {
                attributes.add("ipv6");
            }
            if (this.mediaOnlyBuildStage == -1) {
                attributes.add("mediaOnly");
            }
            if (this.tcpoOnlyBuildStage == -1) {
                attributes.add("tcpoOnly");
            }
            if (this.cdnBuildStage == -1) {
                attributes.add("cdn");
            }
            if (this.isStaticBuildStage == -1) {
                attributes.add("isStatic");
            }
            if (this.thisPortOnlyBuildStage == -1) {
                attributes.add("thisPortOnly");
            }
            return "Cannot build DcOption, attribute initializers form cycle " + attributes;
        }
    }
}

