/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.DialogFilter;
import telegram4j.tl.DialogFilterDefault;
import telegram4j.tl.api.TlObject;

public final class ImmutableDialogFilterDefault
implements DialogFilterDefault {
    private final int identifier;
    private static final ImmutableDialogFilterDefault INSTANCE = ImmutableDialogFilterDefault.validate(new ImmutableDialogFilterDefault());

    private ImmutableDialogFilterDefault() {
        this.identifier = DialogFilterDefault.super.identifier();
    }

    private ImmutableDialogFilterDefault(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : DialogFilterDefault.super.identifier();
    }

    private ImmutableDialogFilterDefault(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableDialogFilterDefault withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableDialogFilterDefault.validate(new ImmutableDialogFilterDefault(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDialogFilterDefault && this.equalTo(0, (ImmutableDialogFilterDefault)another);
    }

    private boolean equalTo(int synthetic, ImmutableDialogFilterDefault another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "DialogFilterDefault{identifier=" + this.identifier + "}";
    }

    public static ImmutableDialogFilterDefault of() {
        return INSTANCE;
    }

    private static ImmutableDialogFilterDefault validate(ImmutableDialogFilterDefault instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableDialogFilterDefault copyOf(DialogFilterDefault instance) {
        if (instance instanceof ImmutableDialogFilterDefault) {
            return (ImmutableDialogFilterDefault)instance;
        }
        return ImmutableDialogFilterDefault.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DialogFilterDefault instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DialogFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DialogFilterDefault) {
                instance = (DialogFilterDefault)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DialogFilter) {
                instance = (DialogFilter)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableDialogFilterDefault build() {
            return ImmutableDialogFilterDefault.validate(new ImmutableDialogFilterDefault(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

