/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DialogFilter;
import telegram4j.tl.DialogFilterSuggested;
import telegram4j.tl.api.TlObject;

public final class ImmutableDialogFilterSuggested
implements DialogFilterSuggested {
    private final int identifier;
    private final DialogFilter filter;
    private final String description;

    private ImmutableDialogFilterSuggested(DialogFilter filter, String description) {
        this.filter = Objects.requireNonNull(filter, "filter");
        this.description = Objects.requireNonNull(description, "description");
        this.identifier = DialogFilterSuggested.super.identifier();
    }

    private ImmutableDialogFilterSuggested(Builder builder) {
        this.filter = builder.filter;
        this.description = builder.description;
        this.identifier = builder.identifierIsSet() ? builder.identifier : DialogFilterSuggested.super.identifier();
    }

    private ImmutableDialogFilterSuggested(int identifier, DialogFilter filter, String description) {
        this.identifier = identifier;
        this.filter = filter;
        this.description = description;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public DialogFilter filter() {
        return this.filter;
    }

    @Override
    public String description() {
        return this.description;
    }

    public final ImmutableDialogFilterSuggested withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDialogFilterSuggested(value, this.filter, this.description);
    }

    public final ImmutableDialogFilterSuggested withFilter(DialogFilter value) {
        if (this.filter == value) {
            return this;
        }
        DialogFilter newValue = Objects.requireNonNull(value, "filter");
        return new ImmutableDialogFilterSuggested(this.identifier, newValue, this.description);
    }

    public final ImmutableDialogFilterSuggested withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableDialogFilterSuggested(this.identifier, this.filter, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDialogFilterSuggested && this.equalTo(0, (ImmutableDialogFilterSuggested)another);
    }

    private boolean equalTo(int synthetic, ImmutableDialogFilterSuggested another) {
        return this.identifier == another.identifier && this.filter.equals(another.filter) && this.description.equals(another.description);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.filter.hashCode();
        h += (h << 5) + this.description.hashCode();
        return h;
    }

    public String toString() {
        return "DialogFilterSuggested{identifier=" + this.identifier + ", filter=" + this.filter + ", description=" + this.description + "}";
    }

    public static ImmutableDialogFilterSuggested of(DialogFilter filter, String description) {
        return new ImmutableDialogFilterSuggested(filter, description);
    }

    public static ImmutableDialogFilterSuggested copyOf(DialogFilterSuggested instance) {
        if (instance instanceof ImmutableDialogFilterSuggested) {
            return (ImmutableDialogFilterSuggested)instance;
        }
        return ImmutableDialogFilterSuggested.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FILTER = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private DialogFilter filter;
        private String description;

        private Builder() {
        }

        public final Builder from(DialogFilterSuggested instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DialogFilterSuggested instance;
            long bits = 0L;
            if (object instanceof DialogFilterSuggested) {
                instance = (DialogFilterSuggested)object;
                this.filter(instance.filter());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.description(instance.description());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder filter(DialogFilter filter) {
            this.filter = Objects.requireNonNull(filter, "filter");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDialogFilterSuggested build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDialogFilterSuggested(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("filter");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            return "Cannot build DialogFilterSuggested, some of required attributes are not set " + attributes;
        }
    }
}

