/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Dialog;
import telegram4j.tl.DialogFolder;
import telegram4j.tl.Folder;
import telegram4j.tl.Peer;
import telegram4j.tl.api.TlObject;

public final class ImmutableDialogFolder
implements DialogFolder {
    private final int identifier;
    private final int flags;
    private final boolean pinned;
    private final Folder folder;
    private final Peer peer;
    private final int topMessage;
    private final int unreadMutedPeersCount;
    private final int unreadUnmutedPeersCount;
    private final int unreadMutedMessagesCount;
    private final int unreadUnmutedMessagesCount;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDialogFolder(Folder folder, Peer peer, int topMessage, int unreadMutedPeersCount, int unreadUnmutedPeersCount, int unreadMutedMessagesCount, int unreadUnmutedMessagesCount) {
        this.folder = Objects.requireNonNull(folder, "folder");
        this.peer = Objects.requireNonNull(peer, "peer");
        this.topMessage = topMessage;
        this.unreadMutedPeersCount = unreadMutedPeersCount;
        this.unreadUnmutedPeersCount = unreadUnmutedPeersCount;
        this.unreadMutedMessagesCount = unreadMutedMessagesCount;
        this.unreadUnmutedMessagesCount = unreadUnmutedMessagesCount;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.pinned = this.initShim.pinned();
        this.initShim = null;
    }

    private ImmutableDialogFolder(Builder builder) {
        this.folder = builder.folder;
        this.peer = builder.peer;
        this.topMessage = builder.topMessage;
        this.unreadMutedPeersCount = builder.unreadMutedPeersCount;
        this.unreadUnmutedPeersCount = builder.unreadUnmutedPeersCount;
        this.unreadMutedMessagesCount = builder.unreadMutedMessagesCount;
        this.unreadUnmutedMessagesCount = builder.unreadUnmutedMessagesCount;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.pinnedIsSet()) {
            this.initShim.pinned(builder.pinned);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.pinned = this.initShim.pinned();
        this.initShim = null;
    }

    private ImmutableDialogFolder(int identifier, int flags, boolean pinned, Folder folder, Peer peer, int topMessage, int unreadMutedPeersCount, int unreadUnmutedPeersCount, int unreadMutedMessagesCount, int unreadUnmutedMessagesCount) {
        this.identifier = identifier;
        this.flags = flags;
        this.pinned = pinned;
        this.folder = folder;
        this.peer = peer;
        this.topMessage = topMessage;
        this.unreadMutedPeersCount = unreadMutedPeersCount;
        this.unreadUnmutedPeersCount = unreadUnmutedPeersCount;
        this.unreadMutedMessagesCount = unreadMutedMessagesCount;
        this.unreadUnmutedMessagesCount = unreadUnmutedMessagesCount;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DialogFolder.super.identifier();
    }

    private int flagsInitialize() {
        return DialogFolder.super.flags();
    }

    private boolean pinnedInitialize() {
        return DialogFolder.super.pinned();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean pinned() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pinned() : this.pinned;
    }

    @Override
    public Folder folder() {
        return this.folder;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public int topMessage() {
        return this.topMessage;
    }

    @Override
    public int unreadMutedPeersCount() {
        return this.unreadMutedPeersCount;
    }

    @Override
    public int unreadUnmutedPeersCount() {
        return this.unreadUnmutedPeersCount;
    }

    @Override
    public int unreadMutedMessagesCount() {
        return this.unreadMutedMessagesCount;
    }

    @Override
    public int unreadUnmutedMessagesCount() {
        return this.unreadUnmutedMessagesCount;
    }

    public final ImmutableDialogFolder withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDialogFolder(value, this.flags, this.pinned, this.folder, this.peer, this.topMessage, this.unreadMutedPeersCount, this.unreadUnmutedPeersCount, this.unreadMutedMessagesCount, this.unreadUnmutedMessagesCount);
    }

    public final ImmutableDialogFolder withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableDialogFolder(this.identifier, value, this.pinned, this.folder, this.peer, this.topMessage, this.unreadMutedPeersCount, this.unreadUnmutedPeersCount, this.unreadMutedMessagesCount, this.unreadUnmutedMessagesCount);
    }

    public final ImmutableDialogFolder withPinned(boolean value) {
        if (this.pinned == value) {
            return this;
        }
        return new ImmutableDialogFolder(this.identifier, this.flags, value, this.folder, this.peer, this.topMessage, this.unreadMutedPeersCount, this.unreadUnmutedPeersCount, this.unreadMutedMessagesCount, this.unreadUnmutedMessagesCount);
    }

    public final ImmutableDialogFolder withFolder(Folder value) {
        if (this.folder == value) {
            return this;
        }
        Folder newValue = Objects.requireNonNull(value, "folder");
        return new ImmutableDialogFolder(this.identifier, this.flags, this.pinned, newValue, this.peer, this.topMessage, this.unreadMutedPeersCount, this.unreadUnmutedPeersCount, this.unreadMutedMessagesCount, this.unreadUnmutedMessagesCount);
    }

    public final ImmutableDialogFolder withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableDialogFolder(this.identifier, this.flags, this.pinned, this.folder, newValue, this.topMessage, this.unreadMutedPeersCount, this.unreadUnmutedPeersCount, this.unreadMutedMessagesCount, this.unreadUnmutedMessagesCount);
    }

    public final ImmutableDialogFolder withTopMessage(int value) {
        if (this.topMessage == value) {
            return this;
        }
        return new ImmutableDialogFolder(this.identifier, this.flags, this.pinned, this.folder, this.peer, value, this.unreadMutedPeersCount, this.unreadUnmutedPeersCount, this.unreadMutedMessagesCount, this.unreadUnmutedMessagesCount);
    }

    public final ImmutableDialogFolder withUnreadMutedPeersCount(int value) {
        if (this.unreadMutedPeersCount == value) {
            return this;
        }
        return new ImmutableDialogFolder(this.identifier, this.flags, this.pinned, this.folder, this.peer, this.topMessage, value, this.unreadUnmutedPeersCount, this.unreadMutedMessagesCount, this.unreadUnmutedMessagesCount);
    }

    public final ImmutableDialogFolder withUnreadUnmutedPeersCount(int value) {
        if (this.unreadUnmutedPeersCount == value) {
            return this;
        }
        return new ImmutableDialogFolder(this.identifier, this.flags, this.pinned, this.folder, this.peer, this.topMessage, this.unreadMutedPeersCount, value, this.unreadMutedMessagesCount, this.unreadUnmutedMessagesCount);
    }

    public final ImmutableDialogFolder withUnreadMutedMessagesCount(int value) {
        if (this.unreadMutedMessagesCount == value) {
            return this;
        }
        return new ImmutableDialogFolder(this.identifier, this.flags, this.pinned, this.folder, this.peer, this.topMessage, this.unreadMutedPeersCount, this.unreadUnmutedPeersCount, value, this.unreadUnmutedMessagesCount);
    }

    public final ImmutableDialogFolder withUnreadUnmutedMessagesCount(int value) {
        if (this.unreadUnmutedMessagesCount == value) {
            return this;
        }
        return new ImmutableDialogFolder(this.identifier, this.flags, this.pinned, this.folder, this.peer, this.topMessage, this.unreadMutedPeersCount, this.unreadUnmutedPeersCount, this.unreadMutedMessagesCount, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDialogFolder && this.equalTo(0, (ImmutableDialogFolder)another);
    }

    private boolean equalTo(int synthetic, ImmutableDialogFolder another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.pinned == another.pinned && this.folder.equals(another.folder) && this.peer.equals(another.peer) && this.topMessage == another.topMessage && this.unreadMutedPeersCount == another.unreadMutedPeersCount && this.unreadUnmutedPeersCount == another.unreadUnmutedPeersCount && this.unreadMutedMessagesCount == another.unreadMutedMessagesCount && this.unreadUnmutedMessagesCount == another.unreadUnmutedMessagesCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.pinned);
        h += (h << 5) + this.folder.hashCode();
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.topMessage;
        h += (h << 5) + this.unreadMutedPeersCount;
        h += (h << 5) + this.unreadUnmutedPeersCount;
        h += (h << 5) + this.unreadMutedMessagesCount;
        h += (h << 5) + this.unreadUnmutedMessagesCount;
        return h;
    }

    public String toString() {
        return "DialogFolder{identifier=" + this.identifier + ", flags=" + this.flags + ", pinned=" + this.pinned + ", folder=" + this.folder + ", peer=" + this.peer + ", topMessage=" + this.topMessage + ", unreadMutedPeersCount=" + this.unreadMutedPeersCount + ", unreadUnmutedPeersCount=" + this.unreadUnmutedPeersCount + ", unreadMutedMessagesCount=" + this.unreadMutedMessagesCount + ", unreadUnmutedMessagesCount=" + this.unreadUnmutedMessagesCount + "}";
    }

    public static ImmutableDialogFolder of(Folder folder, Peer peer, int topMessage, int unreadMutedPeersCount, int unreadUnmutedPeersCount, int unreadMutedMessagesCount, int unreadUnmutedMessagesCount) {
        return new ImmutableDialogFolder(folder, peer, topMessage, unreadMutedPeersCount, unreadUnmutedPeersCount, unreadMutedMessagesCount, unreadUnmutedMessagesCount);
    }

    public static ImmutableDialogFolder copyOf(DialogFolder instance) {
        if (instance instanceof ImmutableDialogFolder) {
            return (ImmutableDialogFolder)instance;
        }
        return ImmutableDialogFolder.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FOLDER = 1L;
        private static final long INIT_BIT_PEER = 2L;
        private static final long INIT_BIT_TOP_MESSAGE = 4L;
        private static final long INIT_BIT_UNREAD_MUTED_PEERS_COUNT = 8L;
        private static final long INIT_BIT_UNREAD_UNMUTED_PEERS_COUNT = 16L;
        private static final long INIT_BIT_UNREAD_MUTED_MESSAGES_COUNT = 32L;
        private static final long INIT_BIT_UNREAD_UNMUTED_MESSAGES_COUNT = 64L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_PINNED = 4L;
        private long initBits = 127L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean pinned;
        private Folder folder;
        private Peer peer;
        private int topMessage;
        private int unreadMutedPeersCount;
        private int unreadUnmutedPeersCount;
        private int unreadMutedMessagesCount;
        private int unreadUnmutedMessagesCount;

        private Builder() {
        }

        public final Builder from(DialogFolder instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Dialog instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Dialog instance;
            long bits = 0L;
            if (object instanceof DialogFolder) {
                instance = (DialogFolder)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.pinned(instance.pinned());
                    bits |= 2L;
                }
                this.folder(instance.folder());
                this.unreadMutedMessagesCount(instance.unreadMutedMessagesCount());
                if ((bits & 4L) == 0L) {
                    this.peer(instance.peer());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.topMessage(instance.topMessage());
                    bits |= 0x10L;
                }
                this.unreadUnmutedMessagesCount(instance.unreadUnmutedMessagesCount());
                this.unreadMutedPeersCount(instance.unreadMutedPeersCount());
                this.unreadUnmutedPeersCount(instance.unreadUnmutedPeersCount());
            }
            if (object instanceof Dialog) {
                instance = (Dialog)object;
                if ((bits & 8L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.topMessage(instance.topMessage());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.pinned(instance.pinned());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.peer(instance.peer());
                    bits |= 4L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder pinned(boolean pinned) {
            this.pinned = pinned;
            this.optBits |= 4L;
            return this;
        }

        public final Builder folder(Folder folder) {
            this.folder = Objects.requireNonNull(folder, "folder");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder topMessage(int topMessage) {
            this.topMessage = topMessage;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder unreadMutedPeersCount(int unreadMutedPeersCount) {
            this.unreadMutedPeersCount = unreadMutedPeersCount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder unreadUnmutedPeersCount(int unreadUnmutedPeersCount) {
            this.unreadUnmutedPeersCount = unreadUnmutedPeersCount;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder unreadMutedMessagesCount(int unreadMutedMessagesCount) {
            this.unreadMutedMessagesCount = unreadMutedMessagesCount;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder unreadUnmutedMessagesCount(int unreadUnmutedMessagesCount) {
            this.unreadUnmutedMessagesCount = unreadUnmutedMessagesCount;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableDialogFolder build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDialogFolder(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean pinnedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("folder");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("topMessage");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("unreadMutedPeersCount");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("unreadUnmutedPeersCount");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("unreadMutedMessagesCount");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("unreadUnmutedMessagesCount");
            }
            return "Cannot build DialogFolder, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte pinnedBuildStage = 0;
        private boolean pinned;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDialogFolder.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableDialogFolder.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean pinned() {
            if (this.pinnedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pinnedBuildStage == 0) {
                this.pinnedBuildStage = (byte)-1;
                this.pinned = ImmutableDialogFolder.this.pinnedInitialize();
                this.pinnedBuildStage = 1;
            }
            return this.pinned;
        }

        void pinned(boolean pinned) {
            this.pinned = pinned;
            this.pinnedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.pinnedBuildStage == -1) {
                attributes.add("pinned");
            }
            return "Cannot build DialogFolder, attribute initializers form cycle " + attributes;
        }
    }
}

