/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.DocumentAttribute;
import telegram4j.tl.DocumentAttributeAnimated;
import telegram4j.tl.api.TlObject;

public final class ImmutableDocumentAttributeAnimated
implements DocumentAttributeAnimated {
    private final int identifier;
    private static final ImmutableDocumentAttributeAnimated INSTANCE = ImmutableDocumentAttributeAnimated.validate(new ImmutableDocumentAttributeAnimated());

    private ImmutableDocumentAttributeAnimated() {
        this.identifier = DocumentAttributeAnimated.super.identifier();
    }

    private ImmutableDocumentAttributeAnimated(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : DocumentAttributeAnimated.super.identifier();
    }

    private ImmutableDocumentAttributeAnimated(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableDocumentAttributeAnimated withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableDocumentAttributeAnimated.validate(new ImmutableDocumentAttributeAnimated(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDocumentAttributeAnimated && this.equalTo(0, (ImmutableDocumentAttributeAnimated)another);
    }

    private boolean equalTo(int synthetic, ImmutableDocumentAttributeAnimated another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "DocumentAttributeAnimated{identifier=" + this.identifier + "}";
    }

    public static ImmutableDocumentAttributeAnimated of() {
        return INSTANCE;
    }

    private static ImmutableDocumentAttributeAnimated validate(ImmutableDocumentAttributeAnimated instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableDocumentAttributeAnimated copyOf(DocumentAttributeAnimated instance) {
        if (instance instanceof ImmutableDocumentAttributeAnimated) {
            return (ImmutableDocumentAttributeAnimated)instance;
        }
        return ImmutableDocumentAttributeAnimated.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(DocumentAttributeAnimated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DocumentAttribute instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DocumentAttribute instance;
            long bits = 0L;
            if (object instanceof DocumentAttributeAnimated) {
                instance = (DocumentAttributeAnimated)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DocumentAttribute) {
                instance = (DocumentAttribute)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableDocumentAttributeAnimated build() {
            return ImmutableDocumentAttributeAnimated.validate(new ImmutableDocumentAttributeAnimated(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

