/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;
import telegram4j.tl.DocumentAttribute;
import telegram4j.tl.DocumentAttributeAudio;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableDocumentAttributeAudio
implements DocumentAttributeAudio {
    private final int identifier;
    private final int flags;
    private final boolean voice;
    private final int duration;
    @Nullable
    private final String title;
    @Nullable
    private final String performer;
    private final ByteBuf waveform;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDocumentAttributeAudio(int duration) {
        this.duration = duration;
        this.title = null;
        this.performer = null;
        this.waveform = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.voice = this.initShim.voice();
        this.initShim = null;
    }

    private ImmutableDocumentAttributeAudio(Builder builder) {
        this.duration = builder.duration;
        this.title = builder.title;
        this.performer = builder.performer;
        this.waveform = builder.waveform_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.voiceIsSet()) {
            this.initShim.voice(builder.voice);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.voice = this.initShim.voice();
        this.initShim = null;
    }

    private ImmutableDocumentAttributeAudio(int identifier, int flags, boolean voice, int duration, @Nullable String title, @Nullable String performer, ByteBuf waveform) {
        this.identifier = identifier;
        this.flags = flags;
        this.voice = voice;
        this.duration = duration;
        this.title = title;
        this.performer = performer;
        this.waveform = waveform;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DocumentAttributeAudio.super.identifier();
    }

    private int flagsInitialize() {
        return DocumentAttributeAudio.super.flags();
    }

    private boolean voiceInitialize() {
        return DocumentAttributeAudio.super.voice();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean voice() {
        InitShim shim = this.initShim;
        return shim != null ? shim.voice() : this.voice;
    }

    @Override
    public int duration() {
        return this.duration;
    }

    @Override
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public String performer() {
        return this.performer;
    }

    @Override
    public Optional<ByteBuf> waveform() {
        return Optional.ofNullable(this.waveform).map(ByteBuf::duplicate);
    }

    public final ImmutableDocumentAttributeAudio withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDocumentAttributeAudio(value, this.flags, this.voice, this.duration, this.title, this.performer, this.waveform);
    }

    public final ImmutableDocumentAttributeAudio withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableDocumentAttributeAudio(this.identifier, value, this.voice, this.duration, this.title, this.performer, this.waveform);
    }

    public final ImmutableDocumentAttributeAudio withVoice(boolean value) {
        if (this.voice == value) {
            return this;
        }
        return new ImmutableDocumentAttributeAudio(this.identifier, this.flags, value, this.duration, this.title, this.performer, this.waveform);
    }

    public final ImmutableDocumentAttributeAudio withDuration(int value) {
        if (this.duration == value) {
            return this;
        }
        return new ImmutableDocumentAttributeAudio(this.identifier, this.flags, this.voice, value, this.title, this.performer, this.waveform);
    }

    public final ImmutableDocumentAttributeAudio withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableDocumentAttributeAudio(this.identifier, this.flags, this.voice, this.duration, value, this.performer, this.waveform);
    }

    public final ImmutableDocumentAttributeAudio withPerformer(@Nullable String value) {
        if (Objects.equals(this.performer, value)) {
            return this;
        }
        return new ImmutableDocumentAttributeAudio(this.identifier, this.flags, this.voice, this.duration, this.title, value, this.waveform);
    }

    public ImmutableDocumentAttributeAudio withWaveform(Optional<ByteBuf> value) {
        ByteBuf newValue = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
        if (this.waveform == newValue) {
            return this;
        }
        return new ImmutableDocumentAttributeAudio(this.identifier, this.flags, this.voice, this.duration, this.title, this.performer, newValue);
    }

    public ImmutableDocumentAttributeAudio withWaveform(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.waveform == newValue) {
            return this;
        }
        return new ImmutableDocumentAttributeAudio(this.identifier, this.flags, this.voice, this.duration, this.title, this.performer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDocumentAttributeAudio && this.equalTo(0, (ImmutableDocumentAttributeAudio)another);
    }

    private boolean equalTo(int synthetic, ImmutableDocumentAttributeAudio another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.voice == another.voice && this.duration == another.duration && Objects.equals(this.title, another.title) && Objects.equals(this.performer, another.performer) && this.waveform().equals(another.waveform());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.voice);
        h += (h << 5) + this.duration;
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.performer);
        h += (h << 5) + this.waveform().hashCode();
        return h;
    }

    public String toString() {
        return "DocumentAttributeAudio{identifier=" + this.identifier + ", flags=" + this.flags + ", voice=" + this.voice + ", duration=" + this.duration + ", title=" + this.title + ", performer=" + this.performer + ", waveform=" + this.waveform().map(ByteBufUtil::hexDump).toString() + "}";
    }

    public static ImmutableDocumentAttributeAudio of(int duration) {
        return new ImmutableDocumentAttributeAudio(duration);
    }

    public static ImmutableDocumentAttributeAudio copyOf(DocumentAttributeAudio instance) {
        if (instance instanceof ImmutableDocumentAttributeAudio) {
            return (ImmutableDocumentAttributeAudio)instance;
        }
        return ImmutableDocumentAttributeAudio.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DURATION = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_VOICE = 4L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf waveform_value = null;
        private int identifier;
        private int flags;
        private boolean voice;
        private int duration;
        private String title;
        private String performer;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DocumentAttribute instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DocumentAttributeAudio instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DocumentAttribute) {
                instance = (DocumentAttribute)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DocumentAttributeAudio) {
                String performerValue;
                instance = (DocumentAttributeAudio)object;
                this.voice(instance.voice());
                this.duration(instance.duration());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((performerValue = instance.performer()) != null) {
                    this.performer(performerValue);
                }
                this.flags(instance.flags());
                String titleValue = instance.title();
                if (titleValue != null) {
                    this.title(titleValue);
                }
                this.waveform(instance.waveform());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder voice(boolean voice) {
            this.voice = voice;
            this.optBits |= 4L;
            return this;
        }

        public final Builder duration(int duration) {
            this.duration = duration;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder performer(@Nullable String performer) {
            this.performer = performer;
            return this;
        }

        public Builder waveform(@Nullable ByteBuf value) {
            this.waveform_value = value != null ? TlEncodingUtil.copyAsUnpooled((ByteBuf)value) : null;
            return this;
        }

        public Builder waveform(Optional<ByteBuf> value) {
            this.waveform_value = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
            return this;
        }

        public ImmutableDocumentAttributeAudio build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDocumentAttributeAudio(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean voiceIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("duration");
            }
            return "Cannot build DocumentAttributeAudio, some of required attributes are not set " + attributes;
        }

        private ByteBuf waveform_build() {
            return this.waveform_value;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte voiceBuildStage = 0;
        private boolean voice;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDocumentAttributeAudio.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableDocumentAttributeAudio.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean voice() {
            if (this.voiceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.voiceBuildStage == 0) {
                this.voiceBuildStage = (byte)-1;
                this.voice = ImmutableDocumentAttributeAudio.this.voiceInitialize();
                this.voiceBuildStage = 1;
            }
            return this.voice;
        }

        void voice(boolean voice) {
            this.voice = voice;
            this.voiceBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.voiceBuildStage == -1) {
                attributes.add("voice");
            }
            return "Cannot build DocumentAttributeAudio, attribute initializers form cycle " + attributes;
        }
    }
}

