/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DocumentAttribute;
import telegram4j.tl.DocumentAttributeCustomEmoji;
import telegram4j.tl.InputStickerSet;
import telegram4j.tl.api.TlObject;

public final class ImmutableDocumentAttributeCustomEmoji
implements DocumentAttributeCustomEmoji {
    private final int identifier;
    private final int flags;
    private final boolean free;
    private final String alt;
    private final InputStickerSet stickerset;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDocumentAttributeCustomEmoji(String alt, InputStickerSet stickerset) {
        this.alt = Objects.requireNonNull(alt, "alt");
        this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.free = this.initShim.free();
        this.initShim = null;
    }

    private ImmutableDocumentAttributeCustomEmoji(Builder builder) {
        this.alt = builder.alt;
        this.stickerset = builder.stickerset;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.freeIsSet()) {
            this.initShim.free(builder.free);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.free = this.initShim.free();
        this.initShim = null;
    }

    private ImmutableDocumentAttributeCustomEmoji(int identifier, int flags, boolean free, String alt, InputStickerSet stickerset) {
        this.identifier = identifier;
        this.flags = flags;
        this.free = free;
        this.alt = alt;
        this.stickerset = stickerset;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DocumentAttributeCustomEmoji.super.identifier();
    }

    private int flagsInitialize() {
        return DocumentAttributeCustomEmoji.super.flags();
    }

    private boolean freeInitialize() {
        return DocumentAttributeCustomEmoji.super.free();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean free() {
        InitShim shim = this.initShim;
        return shim != null ? shim.free() : this.free;
    }

    @Override
    public String alt() {
        return this.alt;
    }

    @Override
    public InputStickerSet stickerset() {
        return this.stickerset;
    }

    public final ImmutableDocumentAttributeCustomEmoji withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDocumentAttributeCustomEmoji(value, this.flags, this.free, this.alt, this.stickerset);
    }

    public final ImmutableDocumentAttributeCustomEmoji withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableDocumentAttributeCustomEmoji(this.identifier, value, this.free, this.alt, this.stickerset);
    }

    public final ImmutableDocumentAttributeCustomEmoji withFree(boolean value) {
        if (this.free == value) {
            return this;
        }
        return new ImmutableDocumentAttributeCustomEmoji(this.identifier, this.flags, value, this.alt, this.stickerset);
    }

    public final ImmutableDocumentAttributeCustomEmoji withAlt(String value) {
        String newValue = Objects.requireNonNull(value, "alt");
        if (this.alt.equals(newValue)) {
            return this;
        }
        return new ImmutableDocumentAttributeCustomEmoji(this.identifier, this.flags, this.free, newValue, this.stickerset);
    }

    public final ImmutableDocumentAttributeCustomEmoji withStickerset(InputStickerSet value) {
        if (this.stickerset == value) {
            return this;
        }
        InputStickerSet newValue = Objects.requireNonNull(value, "stickerset");
        return new ImmutableDocumentAttributeCustomEmoji(this.identifier, this.flags, this.free, this.alt, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDocumentAttributeCustomEmoji && this.equalTo(0, (ImmutableDocumentAttributeCustomEmoji)another);
    }

    private boolean equalTo(int synthetic, ImmutableDocumentAttributeCustomEmoji another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.free == another.free && this.alt.equals(another.alt) && this.stickerset.equals(another.stickerset);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.free);
        h += (h << 5) + this.alt.hashCode();
        h += (h << 5) + this.stickerset.hashCode();
        return h;
    }

    public String toString() {
        return "DocumentAttributeCustomEmoji{identifier=" + this.identifier + ", flags=" + this.flags + ", free=" + this.free + ", alt=" + this.alt + ", stickerset=" + this.stickerset + "}";
    }

    public static ImmutableDocumentAttributeCustomEmoji of(String alt, InputStickerSet stickerset) {
        return new ImmutableDocumentAttributeCustomEmoji(alt, stickerset);
    }

    public static ImmutableDocumentAttributeCustomEmoji copyOf(DocumentAttributeCustomEmoji instance) {
        if (instance instanceof ImmutableDocumentAttributeCustomEmoji) {
            return (ImmutableDocumentAttributeCustomEmoji)instance;
        }
        return ImmutableDocumentAttributeCustomEmoji.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ALT = 1L;
        private static final long INIT_BIT_STICKERSET = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_FREE = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean free;
        private String alt;
        private InputStickerSet stickerset;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DocumentAttributeCustomEmoji instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DocumentAttribute instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DocumentAttributeCustomEmoji) {
                instance = (DocumentAttributeCustomEmoji)object;
                this.flags(instance.flags());
                this.alt(instance.alt());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.stickerset(instance.stickerset());
                this.free(instance.free());
            }
            if (object instanceof DocumentAttribute) {
                instance = (DocumentAttribute)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder free(boolean free) {
            this.free = free;
            this.optBits |= 4L;
            return this;
        }

        public final Builder alt(String alt) {
            this.alt = Objects.requireNonNull(alt, "alt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder stickerset(InputStickerSet stickerset) {
            this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDocumentAttributeCustomEmoji build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDocumentAttributeCustomEmoji(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean freeIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("alt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("stickerset");
            }
            return "Cannot build DocumentAttributeCustomEmoji, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte freeBuildStage = 0;
        private boolean free;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDocumentAttributeCustomEmoji.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableDocumentAttributeCustomEmoji.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean free() {
            if (this.freeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.freeBuildStage == 0) {
                this.freeBuildStage = (byte)-1;
                this.free = ImmutableDocumentAttributeCustomEmoji.this.freeInitialize();
                this.freeBuildStage = 1;
            }
            return this.free;
        }

        void free(boolean free) {
            this.free = free;
            this.freeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.freeBuildStage == -1) {
                attributes.add("free");
            }
            return "Cannot build DocumentAttributeCustomEmoji, attribute initializers form cycle " + attributes;
        }
    }
}

