/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DocumentAttribute;
import telegram4j.tl.DocumentAttributeFilename;
import telegram4j.tl.api.TlObject;

public final class ImmutableDocumentAttributeFilename
implements DocumentAttributeFilename {
    private final int identifier;
    private final String fileName;

    private ImmutableDocumentAttributeFilename(String fileName) {
        this.fileName = Objects.requireNonNull(fileName, "fileName");
        this.identifier = DocumentAttributeFilename.super.identifier();
    }

    private ImmutableDocumentAttributeFilename(Builder builder) {
        this.fileName = builder.fileName;
        this.identifier = builder.identifierIsSet() ? builder.identifier : DocumentAttributeFilename.super.identifier();
    }

    private ImmutableDocumentAttributeFilename(int identifier, String fileName) {
        this.identifier = identifier;
        this.fileName = fileName;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String fileName() {
        return this.fileName;
    }

    public final ImmutableDocumentAttributeFilename withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDocumentAttributeFilename(value, this.fileName);
    }

    public final ImmutableDocumentAttributeFilename withFileName(String value) {
        String newValue = Objects.requireNonNull(value, "fileName");
        if (this.fileName.equals(newValue)) {
            return this;
        }
        return new ImmutableDocumentAttributeFilename(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDocumentAttributeFilename && this.equalTo(0, (ImmutableDocumentAttributeFilename)another);
    }

    private boolean equalTo(int synthetic, ImmutableDocumentAttributeFilename another) {
        return this.identifier == another.identifier && this.fileName.equals(another.fileName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.fileName.hashCode();
        return h;
    }

    public String toString() {
        return "DocumentAttributeFilename{identifier=" + this.identifier + ", fileName=" + this.fileName + "}";
    }

    public static ImmutableDocumentAttributeFilename of(String fileName) {
        return new ImmutableDocumentAttributeFilename(fileName);
    }

    public static ImmutableDocumentAttributeFilename copyOf(DocumentAttributeFilename instance) {
        if (instance instanceof ImmutableDocumentAttributeFilename) {
            return (ImmutableDocumentAttributeFilename)instance;
        }
        return ImmutableDocumentAttributeFilename.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FILE_NAME = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String fileName;

        private Builder() {
        }

        public final Builder from(DocumentAttributeFilename instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DocumentAttribute instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DocumentAttribute instance;
            long bits = 0L;
            if (object instanceof DocumentAttributeFilename) {
                instance = (DocumentAttributeFilename)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.fileName(instance.fileName());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DocumentAttribute) {
                instance = (DocumentAttribute)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder fileName(String fileName) {
            this.fileName = Objects.requireNonNull(fileName, "fileName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDocumentAttributeFilename build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDocumentAttributeFilename(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fileName");
            }
            return "Cannot build DocumentAttributeFilename, some of required attributes are not set " + attributes;
        }
    }
}

