/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.DocumentAttribute;
import telegram4j.tl.DocumentAttributeHasStickers;
import telegram4j.tl.api.TlObject;

public final class ImmutableDocumentAttributeHasStickers
implements DocumentAttributeHasStickers {
    private final int identifier;
    private static final ImmutableDocumentAttributeHasStickers INSTANCE = ImmutableDocumentAttributeHasStickers.validate(new ImmutableDocumentAttributeHasStickers());

    private ImmutableDocumentAttributeHasStickers() {
        this.identifier = DocumentAttributeHasStickers.super.identifier();
    }

    private ImmutableDocumentAttributeHasStickers(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : DocumentAttributeHasStickers.super.identifier();
    }

    private ImmutableDocumentAttributeHasStickers(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableDocumentAttributeHasStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableDocumentAttributeHasStickers.validate(new ImmutableDocumentAttributeHasStickers(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDocumentAttributeHasStickers && this.equalTo(0, (ImmutableDocumentAttributeHasStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableDocumentAttributeHasStickers another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "DocumentAttributeHasStickers{identifier=" + this.identifier + "}";
    }

    public static ImmutableDocumentAttributeHasStickers of() {
        return INSTANCE;
    }

    private static ImmutableDocumentAttributeHasStickers validate(ImmutableDocumentAttributeHasStickers instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableDocumentAttributeHasStickers copyOf(DocumentAttributeHasStickers instance) {
        if (instance instanceof ImmutableDocumentAttributeHasStickers) {
            return (ImmutableDocumentAttributeHasStickers)instance;
        }
        return ImmutableDocumentAttributeHasStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(DocumentAttributeHasStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DocumentAttribute instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DocumentAttribute instance;
            long bits = 0L;
            if (object instanceof DocumentAttributeHasStickers) {
                instance = (DocumentAttributeHasStickers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DocumentAttribute) {
                instance = (DocumentAttribute)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableDocumentAttributeHasStickers build() {
            return ImmutableDocumentAttributeHasStickers.validate(new ImmutableDocumentAttributeHasStickers(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

