/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DocumentAttribute;
import telegram4j.tl.DocumentAttributeImageSize;
import telegram4j.tl.api.TlObject;

public final class ImmutableDocumentAttributeImageSize
implements DocumentAttributeImageSize {
    private final int identifier;
    private final int w;
    private final int h;

    private ImmutableDocumentAttributeImageSize(int w, int h) {
        this.w = w;
        this.h = h;
        this.identifier = DocumentAttributeImageSize.super.identifier();
    }

    private ImmutableDocumentAttributeImageSize(Builder builder) {
        this.w = builder.w;
        this.h = builder.h;
        this.identifier = builder.identifierIsSet() ? builder.identifier : DocumentAttributeImageSize.super.identifier();
    }

    private ImmutableDocumentAttributeImageSize(int identifier, int w, int h) {
        this.identifier = identifier;
        this.w = w;
        this.h = h;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int w() {
        return this.w;
    }

    @Override
    public int h() {
        return this.h;
    }

    public final ImmutableDocumentAttributeImageSize withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDocumentAttributeImageSize(value, this.w, this.h);
    }

    public final ImmutableDocumentAttributeImageSize withW(int value) {
        if (this.w == value) {
            return this;
        }
        return new ImmutableDocumentAttributeImageSize(this.identifier, value, this.h);
    }

    public final ImmutableDocumentAttributeImageSize withH(int value) {
        if (this.h == value) {
            return this;
        }
        return new ImmutableDocumentAttributeImageSize(this.identifier, this.w, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDocumentAttributeImageSize && this.equalTo(0, (ImmutableDocumentAttributeImageSize)another);
    }

    private boolean equalTo(int synthetic, ImmutableDocumentAttributeImageSize another) {
        return this.identifier == another.identifier && this.w == another.w && this.h == another.h;
    }

    public int hashCode() {
        int h$$ = 5381;
        h$$ += (h$$ << 5) + this.identifier;
        h$$ += (h$$ << 5) + this.w;
        h$$ += (h$$ << 5) + this.h;
        return h$$;
    }

    public String toString() {
        return "DocumentAttributeImageSize{identifier=" + this.identifier + ", w=" + this.w + ", h=" + this.h + "}";
    }

    public static ImmutableDocumentAttributeImageSize of(int w, int h) {
        return new ImmutableDocumentAttributeImageSize(w, h);
    }

    public static ImmutableDocumentAttributeImageSize copyOf(DocumentAttributeImageSize instance) {
        if (instance instanceof ImmutableDocumentAttributeImageSize) {
            return (ImmutableDocumentAttributeImageSize)instance;
        }
        return ImmutableDocumentAttributeImageSize.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_W = 1L;
        private static final long INIT_BIT_H = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int w;
        private int h;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DocumentAttribute instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DocumentAttributeImageSize instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DocumentAttribute) {
                instance = (DocumentAttribute)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DocumentAttributeImageSize) {
                instance = (DocumentAttributeImageSize)object;
                this.h(instance.h());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.w(instance.w());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder w(int w) {
            this.w = w;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder h(int h) {
            this.h = h;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDocumentAttributeImageSize build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDocumentAttributeImageSize(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("w");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("h");
            }
            return "Cannot build DocumentAttributeImageSize, some of required attributes are not set " + attributes;
        }
    }
}

