/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.DocumentAttribute;
import telegram4j.tl.DocumentAttributeSticker;
import telegram4j.tl.InputStickerSet;
import telegram4j.tl.MaskCoords;
import telegram4j.tl.api.TlObject;

public final class ImmutableDocumentAttributeSticker
implements DocumentAttributeSticker {
    private final int identifier;
    private final int flags;
    private final boolean mask;
    private final String alt;
    private final InputStickerSet stickerset;
    @Nullable
    private final MaskCoords maskCoords;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDocumentAttributeSticker(String alt, InputStickerSet stickerset) {
        this.alt = Objects.requireNonNull(alt, "alt");
        this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
        this.maskCoords = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.mask = this.initShim.mask();
        this.initShim = null;
    }

    private ImmutableDocumentAttributeSticker(Builder builder) {
        this.alt = builder.alt;
        this.stickerset = builder.stickerset;
        this.maskCoords = builder.maskCoords;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.maskIsSet()) {
            this.initShim.mask(builder.mask);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.mask = this.initShim.mask();
        this.initShim = null;
    }

    private ImmutableDocumentAttributeSticker(int identifier, int flags, boolean mask, String alt, InputStickerSet stickerset, @Nullable MaskCoords maskCoords) {
        this.identifier = identifier;
        this.flags = flags;
        this.mask = mask;
        this.alt = alt;
        this.stickerset = stickerset;
        this.maskCoords = maskCoords;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DocumentAttributeSticker.super.identifier();
    }

    private int flagsInitialize() {
        return DocumentAttributeSticker.super.flags();
    }

    private boolean maskInitialize() {
        return DocumentAttributeSticker.super.mask();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean mask() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mask() : this.mask;
    }

    @Override
    public String alt() {
        return this.alt;
    }

    @Override
    public InputStickerSet stickerset() {
        return this.stickerset;
    }

    @Override
    @Nullable
    public MaskCoords maskCoords() {
        return this.maskCoords;
    }

    public final ImmutableDocumentAttributeSticker withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDocumentAttributeSticker(value, this.flags, this.mask, this.alt, this.stickerset, this.maskCoords);
    }

    public final ImmutableDocumentAttributeSticker withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableDocumentAttributeSticker(this.identifier, value, this.mask, this.alt, this.stickerset, this.maskCoords);
    }

    public final ImmutableDocumentAttributeSticker withMask(boolean value) {
        if (this.mask == value) {
            return this;
        }
        return new ImmutableDocumentAttributeSticker(this.identifier, this.flags, value, this.alt, this.stickerset, this.maskCoords);
    }

    public final ImmutableDocumentAttributeSticker withAlt(String value) {
        String newValue = Objects.requireNonNull(value, "alt");
        if (this.alt.equals(newValue)) {
            return this;
        }
        return new ImmutableDocumentAttributeSticker(this.identifier, this.flags, this.mask, newValue, this.stickerset, this.maskCoords);
    }

    public final ImmutableDocumentAttributeSticker withStickerset(InputStickerSet value) {
        if (this.stickerset == value) {
            return this;
        }
        InputStickerSet newValue = Objects.requireNonNull(value, "stickerset");
        return new ImmutableDocumentAttributeSticker(this.identifier, this.flags, this.mask, this.alt, newValue, this.maskCoords);
    }

    public final ImmutableDocumentAttributeSticker withMaskCoords(@Nullable MaskCoords value) {
        if (this.maskCoords == value) {
            return this;
        }
        return new ImmutableDocumentAttributeSticker(this.identifier, this.flags, this.mask, this.alt, this.stickerset, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDocumentAttributeSticker && this.equalTo(0, (ImmutableDocumentAttributeSticker)another);
    }

    private boolean equalTo(int synthetic, ImmutableDocumentAttributeSticker another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.mask == another.mask && this.alt.equals(another.alt) && this.stickerset.equals(another.stickerset) && Objects.equals(this.maskCoords, another.maskCoords);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.mask);
        h += (h << 5) + this.alt.hashCode();
        h += (h << 5) + this.stickerset.hashCode();
        h += (h << 5) + Objects.hashCode(this.maskCoords);
        return h;
    }

    public String toString() {
        return "DocumentAttributeSticker{identifier=" + this.identifier + ", flags=" + this.flags + ", mask=" + this.mask + ", alt=" + this.alt + ", stickerset=" + this.stickerset + ", maskCoords=" + this.maskCoords + "}";
    }

    public static ImmutableDocumentAttributeSticker of(String alt, InputStickerSet stickerset) {
        return new ImmutableDocumentAttributeSticker(alt, stickerset);
    }

    public static ImmutableDocumentAttributeSticker copyOf(DocumentAttributeSticker instance) {
        if (instance instanceof ImmutableDocumentAttributeSticker) {
            return (ImmutableDocumentAttributeSticker)instance;
        }
        return ImmutableDocumentAttributeSticker.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ALT = 1L;
        private static final long INIT_BIT_STICKERSET = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_MASK = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean mask;
        private String alt;
        private InputStickerSet stickerset;
        private MaskCoords maskCoords;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DocumentAttribute instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DocumentAttributeSticker instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DocumentAttribute) {
                instance = (DocumentAttribute)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DocumentAttributeSticker) {
                instance = (DocumentAttributeSticker)object;
                MaskCoords maskCoordsValue = instance.maskCoords();
                if (maskCoordsValue != null) {
                    this.maskCoords(maskCoordsValue);
                }
                this.flags(instance.flags());
                this.alt(instance.alt());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.stickerset(instance.stickerset());
                this.mask(instance.mask());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder mask(boolean mask) {
            this.mask = mask;
            this.optBits |= 4L;
            return this;
        }

        public final Builder alt(String alt) {
            this.alt = Objects.requireNonNull(alt, "alt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder stickerset(InputStickerSet stickerset) {
            this.stickerset = Objects.requireNonNull(stickerset, "stickerset");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder maskCoords(@Nullable MaskCoords maskCoords) {
            this.maskCoords = maskCoords;
            return this;
        }

        public ImmutableDocumentAttributeSticker build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDocumentAttributeSticker(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean maskIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("alt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("stickerset");
            }
            return "Cannot build DocumentAttributeSticker, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte maskBuildStage = 0;
        private boolean mask;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDocumentAttributeSticker.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableDocumentAttributeSticker.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean mask() {
            if (this.maskBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maskBuildStage == 0) {
                this.maskBuildStage = (byte)-1;
                this.mask = ImmutableDocumentAttributeSticker.this.maskInitialize();
                this.maskBuildStage = 1;
            }
            return this.mask;
        }

        void mask(boolean mask) {
            this.mask = mask;
            this.maskBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.maskBuildStage == -1) {
                attributes.add("mask");
            }
            return "Cannot build DocumentAttributeSticker, attribute initializers form cycle " + attributes;
        }
    }
}

