/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.DocumentAttribute;
import telegram4j.tl.DocumentAttributeVideo;
import telegram4j.tl.api.TlObject;

public final class ImmutableDocumentAttributeVideo
implements DocumentAttributeVideo {
    private final int identifier;
    private final int flags;
    private final boolean roundMessage;
    private final boolean supportsStreaming;
    private final int duration;
    private final int w;
    private final int h;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDocumentAttributeVideo(int duration, int w, int h) {
        this.duration = duration;
        this.w = w;
        this.h = h;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.roundMessage = this.initShim.roundMessage();
        this.supportsStreaming = this.initShim.supportsStreaming();
        this.initShim = null;
    }

    private ImmutableDocumentAttributeVideo(Builder builder) {
        this.duration = builder.duration;
        this.w = builder.w;
        this.h = builder.h;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.roundMessageIsSet()) {
            this.initShim.roundMessage(builder.roundMessage);
        }
        if (builder.supportsStreamingIsSet()) {
            this.initShim.supportsStreaming(builder.supportsStreaming);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.roundMessage = this.initShim.roundMessage();
        this.supportsStreaming = this.initShim.supportsStreaming();
        this.initShim = null;
    }

    private ImmutableDocumentAttributeVideo(int identifier, int flags, boolean roundMessage, boolean supportsStreaming, int duration, int w, int h) {
        this.identifier = identifier;
        this.flags = flags;
        this.roundMessage = roundMessage;
        this.supportsStreaming = supportsStreaming;
        this.duration = duration;
        this.w = w;
        this.h = h;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DocumentAttributeVideo.super.identifier();
    }

    private int flagsInitialize() {
        return DocumentAttributeVideo.super.flags();
    }

    private boolean roundMessageInitialize() {
        return DocumentAttributeVideo.super.roundMessage();
    }

    private boolean supportsStreamingInitialize() {
        return DocumentAttributeVideo.super.supportsStreaming();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean roundMessage() {
        InitShim shim = this.initShim;
        return shim != null ? shim.roundMessage() : this.roundMessage;
    }

    @Override
    public boolean supportsStreaming() {
        InitShim shim = this.initShim;
        return shim != null ? shim.supportsStreaming() : this.supportsStreaming;
    }

    @Override
    public int duration() {
        return this.duration;
    }

    @Override
    public int w() {
        return this.w;
    }

    @Override
    public int h() {
        return this.h;
    }

    public final ImmutableDocumentAttributeVideo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDocumentAttributeVideo(value, this.flags, this.roundMessage, this.supportsStreaming, this.duration, this.w, this.h);
    }

    public final ImmutableDocumentAttributeVideo withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableDocumentAttributeVideo(this.identifier, value, this.roundMessage, this.supportsStreaming, this.duration, this.w, this.h);
    }

    public final ImmutableDocumentAttributeVideo withRoundMessage(boolean value) {
        if (this.roundMessage == value) {
            return this;
        }
        return new ImmutableDocumentAttributeVideo(this.identifier, this.flags, value, this.supportsStreaming, this.duration, this.w, this.h);
    }

    public final ImmutableDocumentAttributeVideo withSupportsStreaming(boolean value) {
        if (this.supportsStreaming == value) {
            return this;
        }
        return new ImmutableDocumentAttributeVideo(this.identifier, this.flags, this.roundMessage, value, this.duration, this.w, this.h);
    }

    public final ImmutableDocumentAttributeVideo withDuration(int value) {
        if (this.duration == value) {
            return this;
        }
        return new ImmutableDocumentAttributeVideo(this.identifier, this.flags, this.roundMessage, this.supportsStreaming, value, this.w, this.h);
    }

    public final ImmutableDocumentAttributeVideo withW(int value) {
        if (this.w == value) {
            return this;
        }
        return new ImmutableDocumentAttributeVideo(this.identifier, this.flags, this.roundMessage, this.supportsStreaming, this.duration, value, this.h);
    }

    public final ImmutableDocumentAttributeVideo withH(int value) {
        if (this.h == value) {
            return this;
        }
        return new ImmutableDocumentAttributeVideo(this.identifier, this.flags, this.roundMessage, this.supportsStreaming, this.duration, this.w, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDocumentAttributeVideo && this.equalTo(0, (ImmutableDocumentAttributeVideo)another);
    }

    private boolean equalTo(int synthetic, ImmutableDocumentAttributeVideo another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.roundMessage == another.roundMessage && this.supportsStreaming == another.supportsStreaming && this.duration == another.duration && this.w == another.w && this.h == another.h;
    }

    public int hashCode() {
        int h$$ = 5381;
        h$$ += (h$$ << 5) + this.identifier;
        h$$ += (h$$ << 5) + this.flags;
        h$$ += (h$$ << 5) + Boolean.hashCode(this.roundMessage);
        h$$ += (h$$ << 5) + Boolean.hashCode(this.supportsStreaming);
        h$$ += (h$$ << 5) + this.duration;
        h$$ += (h$$ << 5) + this.w;
        h$$ += (h$$ << 5) + this.h;
        return h$$;
    }

    public String toString() {
        return "DocumentAttributeVideo{identifier=" + this.identifier + ", flags=" + this.flags + ", roundMessage=" + this.roundMessage + ", supportsStreaming=" + this.supportsStreaming + ", duration=" + this.duration + ", w=" + this.w + ", h=" + this.h + "}";
    }

    public static ImmutableDocumentAttributeVideo of(int duration, int w, int h) {
        return new ImmutableDocumentAttributeVideo(duration, w, h);
    }

    public static ImmutableDocumentAttributeVideo copyOf(DocumentAttributeVideo instance) {
        if (instance instanceof ImmutableDocumentAttributeVideo) {
            return (ImmutableDocumentAttributeVideo)instance;
        }
        return ImmutableDocumentAttributeVideo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DURATION = 1L;
        private static final long INIT_BIT_W = 2L;
        private static final long INIT_BIT_H = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_ROUND_MESSAGE = 4L;
        private static final long OPT_BIT_SUPPORTS_STREAMING = 8L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean roundMessage;
        private boolean supportsStreaming;
        private int duration;
        private int w;
        private int h;

        private Builder() {
        }

        public final Builder from(DocumentAttributeVideo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DocumentAttribute instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DocumentAttribute instance;
            long bits = 0L;
            if (object instanceof DocumentAttributeVideo) {
                instance = (DocumentAttributeVideo)object;
                this.duration(instance.duration());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.supportsStreaming(instance.supportsStreaming());
                this.w(instance.w());
                this.flags(instance.flags());
                this.h(instance.h());
                this.roundMessage(instance.roundMessage());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DocumentAttribute) {
                instance = (DocumentAttribute)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder roundMessage(boolean roundMessage) {
            this.roundMessage = roundMessage;
            this.optBits |= 4L;
            return this;
        }

        public final Builder supportsStreaming(boolean supportsStreaming) {
            this.supportsStreaming = supportsStreaming;
            this.optBits |= 8L;
            return this;
        }

        public final Builder duration(int duration) {
            this.duration = duration;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder w(int w) {
            this.w = w;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder h(int h) {
            this.h = h;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableDocumentAttributeVideo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDocumentAttributeVideo(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean roundMessageIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean supportsStreamingIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("duration");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("w");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("h");
            }
            return "Cannot build DocumentAttributeVideo, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte roundMessageBuildStage = 0;
        private boolean roundMessage;
        private byte supportsStreamingBuildStage = 0;
        private boolean supportsStreaming;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDocumentAttributeVideo.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableDocumentAttributeVideo.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean roundMessage() {
            if (this.roundMessageBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.roundMessageBuildStage == 0) {
                this.roundMessageBuildStage = (byte)-1;
                this.roundMessage = ImmutableDocumentAttributeVideo.this.roundMessageInitialize();
                this.roundMessageBuildStage = 1;
            }
            return this.roundMessage;
        }

        void roundMessage(boolean roundMessage) {
            this.roundMessage = roundMessage;
            this.roundMessageBuildStage = 1;
        }

        boolean supportsStreaming() {
            if (this.supportsStreamingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.supportsStreamingBuildStage == 0) {
                this.supportsStreamingBuildStage = (byte)-1;
                this.supportsStreaming = ImmutableDocumentAttributeVideo.this.supportsStreamingInitialize();
                this.supportsStreamingBuildStage = 1;
            }
            return this.supportsStreaming;
        }

        void supportsStreaming(boolean supportsStreaming) {
            this.supportsStreaming = supportsStreaming;
            this.supportsStreamingBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.roundMessageBuildStage == -1) {
                attributes.add("roundMessage");
            }
            if (this.supportsStreamingBuildStage == -1) {
                attributes.add("supportsStreaming");
            }
            return "Cannot build DocumentAttributeVideo, attribute initializers form cycle " + attributes;
        }
    }
}

