/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.EmojiKeyword;
import telegram4j.tl.EmojiKeywordDeleted;
import telegram4j.tl.api.TlObject;

public final class ImmutableEmojiKeywordDeleted
implements EmojiKeywordDeleted {
    private final int identifier;
    private final String keyword;
    private final List<String> emoticons;

    private ImmutableEmojiKeywordDeleted(String keyword) {
        this.keyword = Objects.requireNonNull(keyword, "keyword");
        this.emoticons = Collections.emptyList();
        this.identifier = EmojiKeywordDeleted.super.identifier();
    }

    private ImmutableEmojiKeywordDeleted(Builder builder) {
        this.keyword = builder.keyword;
        this.emoticons = ImmutableEmojiKeywordDeleted.createUnmodifiableList(true, builder.emoticons);
        this.identifier = builder.identifierIsSet() ? builder.identifier : EmojiKeywordDeleted.super.identifier();
    }

    private ImmutableEmojiKeywordDeleted(int identifier, String keyword, List<String> emoticons) {
        this.identifier = identifier;
        this.keyword = keyword;
        this.emoticons = emoticons;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String keyword() {
        return this.keyword;
    }

    @Override
    public List<String> emoticons() {
        return this.emoticons;
    }

    public final ImmutableEmojiKeywordDeleted withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEmojiKeywordDeleted(value, this.keyword, this.emoticons);
    }

    public final ImmutableEmojiKeywordDeleted withKeyword(String value) {
        String newValue = Objects.requireNonNull(value, "keyword");
        if (this.keyword.equals(newValue)) {
            return this;
        }
        return new ImmutableEmojiKeywordDeleted(this.identifier, newValue, this.emoticons);
    }

    public final ImmutableEmojiKeywordDeleted withEmoticons(String ... elements) {
        List<String> newValue = ImmutableEmojiKeywordDeleted.createUnmodifiableList(false, ImmutableEmojiKeywordDeleted.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEmojiKeywordDeleted(this.identifier, this.keyword, newValue);
    }

    public final ImmutableEmojiKeywordDeleted withEmoticons(Iterable<String> elements) {
        if (this.emoticons == elements) {
            return this;
        }
        List<String> newValue = ImmutableEmojiKeywordDeleted.createUnmodifiableList(false, ImmutableEmojiKeywordDeleted.createSafeList(elements, true, false));
        return new ImmutableEmojiKeywordDeleted(this.identifier, this.keyword, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEmojiKeywordDeleted && this.equalTo(0, (ImmutableEmojiKeywordDeleted)another);
    }

    private boolean equalTo(int synthetic, ImmutableEmojiKeywordDeleted another) {
        return this.identifier == another.identifier && this.keyword.equals(another.keyword) && this.emoticons.equals(another.emoticons);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.keyword.hashCode();
        h += (h << 5) + this.emoticons.hashCode();
        return h;
    }

    public String toString() {
        return "EmojiKeywordDeleted{identifier=" + this.identifier + ", keyword=" + this.keyword + ", emoticons=" + this.emoticons + "}";
    }

    public static ImmutableEmojiKeywordDeleted of(String keyword) {
        return new ImmutableEmojiKeywordDeleted(keyword);
    }

    public static ImmutableEmojiKeywordDeleted copyOf(EmojiKeywordDeleted instance) {
        if (instance instanceof ImmutableEmojiKeywordDeleted) {
            return (ImmutableEmojiKeywordDeleted)instance;
        }
        return ImmutableEmojiKeywordDeleted.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_KEYWORD = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String keyword;
        private List<String> emoticons = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmojiKeywordDeleted instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmojiKeyword instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmojiKeywordDeleted) {
                instance = (EmojiKeywordDeleted)object;
                if ((bits & 4L) == 0L) {
                    this.keyword(instance.keyword());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllEmoticons(instance.emoticons());
                    bits |= 2L;
                }
            }
            if (object instanceof EmojiKeyword) {
                instance = (EmojiKeyword)object;
                if ((bits & 4L) == 0L) {
                    this.keyword(instance.keyword());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllEmoticons(instance.emoticons());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder keyword(String keyword) {
            this.keyword = Objects.requireNonNull(keyword, "keyword");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addEmoticon(String element) {
            this.emoticons.add(Objects.requireNonNull(element, "emoticons element"));
            return this;
        }

        public final Builder addEmoticons(String ... elements) {
            for (String element : elements) {
                this.emoticons.add(Objects.requireNonNull(element, "emoticons element"));
            }
            return this;
        }

        public final Builder emoticons(Iterable<String> elements) {
            this.emoticons.clear();
            return this.addAllEmoticons(elements);
        }

        public final Builder addAllEmoticons(Iterable<String> elements) {
            for (String element : elements) {
                this.emoticons.add(Objects.requireNonNull(element, "emoticons element"));
            }
            return this;
        }

        public ImmutableEmojiKeywordDeleted build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEmojiKeywordDeleted(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("keyword");
            }
            return "Cannot build EmojiKeywordDeleted, some of required attributes are not set " + attributes;
        }
    }
}

