/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.EmojiKeyword;
import telegram4j.tl.EmojiKeywordsDifference;
import telegram4j.tl.api.TlObject;

public final class ImmutableEmojiKeywordsDifference
implements EmojiKeywordsDifference {
    private final int identifier;
    private final String langCode;
    private final int fromVersion;
    private final int version;
    private final List<EmojiKeyword> keywords;

    private ImmutableEmojiKeywordsDifference(String langCode, int fromVersion, int version) {
        this.langCode = Objects.requireNonNull(langCode, "langCode");
        this.fromVersion = fromVersion;
        this.version = version;
        this.keywords = Collections.emptyList();
        this.identifier = EmojiKeywordsDifference.super.identifier();
    }

    private ImmutableEmojiKeywordsDifference(Builder builder) {
        this.langCode = builder.langCode;
        this.fromVersion = builder.fromVersion;
        this.version = builder.version;
        this.keywords = ImmutableEmojiKeywordsDifference.createUnmodifiableList(true, builder.keywords);
        this.identifier = builder.identifierIsSet() ? builder.identifier : EmojiKeywordsDifference.super.identifier();
    }

    private ImmutableEmojiKeywordsDifference(int identifier, String langCode, int fromVersion, int version, List<EmojiKeyword> keywords) {
        this.identifier = identifier;
        this.langCode = langCode;
        this.fromVersion = fromVersion;
        this.version = version;
        this.keywords = keywords;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String langCode() {
        return this.langCode;
    }

    @Override
    public int fromVersion() {
        return this.fromVersion;
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public List<EmojiKeyword> keywords() {
        return this.keywords;
    }

    public final ImmutableEmojiKeywordsDifference withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEmojiKeywordsDifference(value, this.langCode, this.fromVersion, this.version, this.keywords);
    }

    public final ImmutableEmojiKeywordsDifference withLangCode(String value) {
        String newValue = Objects.requireNonNull(value, "langCode");
        if (this.langCode.equals(newValue)) {
            return this;
        }
        return new ImmutableEmojiKeywordsDifference(this.identifier, newValue, this.fromVersion, this.version, this.keywords);
    }

    public final ImmutableEmojiKeywordsDifference withFromVersion(int value) {
        if (this.fromVersion == value) {
            return this;
        }
        return new ImmutableEmojiKeywordsDifference(this.identifier, this.langCode, value, this.version, this.keywords);
    }

    public final ImmutableEmojiKeywordsDifference withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableEmojiKeywordsDifference(this.identifier, this.langCode, this.fromVersion, value, this.keywords);
    }

    public final ImmutableEmojiKeywordsDifference withKeywords(EmojiKeyword ... elements) {
        List<EmojiKeyword> newValue = ImmutableEmojiKeywordsDifference.createUnmodifiableList(false, ImmutableEmojiKeywordsDifference.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEmojiKeywordsDifference(this.identifier, this.langCode, this.fromVersion, this.version, newValue);
    }

    public final ImmutableEmojiKeywordsDifference withKeywords(Iterable<? extends EmojiKeyword> elements) {
        if (this.keywords == elements) {
            return this;
        }
        List<EmojiKeyword> newValue = ImmutableEmojiKeywordsDifference.createUnmodifiableList(false, ImmutableEmojiKeywordsDifference.createSafeList(elements, true, false));
        return new ImmutableEmojiKeywordsDifference(this.identifier, this.langCode, this.fromVersion, this.version, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEmojiKeywordsDifference && this.equalTo(0, (ImmutableEmojiKeywordsDifference)another);
    }

    private boolean equalTo(int synthetic, ImmutableEmojiKeywordsDifference another) {
        return this.identifier == another.identifier && this.langCode.equals(another.langCode) && this.fromVersion == another.fromVersion && this.version == another.version && this.keywords.equals(another.keywords);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.langCode.hashCode();
        h += (h << 5) + this.fromVersion;
        h += (h << 5) + this.version;
        h += (h << 5) + this.keywords.hashCode();
        return h;
    }

    public String toString() {
        return "EmojiKeywordsDifference{identifier=" + this.identifier + ", langCode=" + this.langCode + ", fromVersion=" + this.fromVersion + ", version=" + this.version + ", keywords=" + this.keywords + "}";
    }

    public static ImmutableEmojiKeywordsDifference of(String langCode, int fromVersion, int version) {
        return new ImmutableEmojiKeywordsDifference(langCode, fromVersion, version);
    }

    public static ImmutableEmojiKeywordsDifference copyOf(EmojiKeywordsDifference instance) {
        if (instance instanceof ImmutableEmojiKeywordsDifference) {
            return (ImmutableEmojiKeywordsDifference)instance;
        }
        return ImmutableEmojiKeywordsDifference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_LANG_CODE = 1L;
        private static final long INIT_BIT_FROM_VERSION = 2L;
        private static final long INIT_BIT_VERSION = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private String langCode;
        private int fromVersion;
        private int version;
        private List<EmojiKeyword> keywords = new ArrayList<EmojiKeyword>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmojiKeywordsDifference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmojiKeywordsDifference) {
                instance = (EmojiKeywordsDifference)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.fromVersion(instance.fromVersion());
                this.addAllKeywords(instance.keywords());
                this.version(instance.version());
                this.langCode(instance.langCode());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder langCode(String langCode) {
            this.langCode = Objects.requireNonNull(langCode, "langCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fromVersion(int fromVersion) {
            this.fromVersion = fromVersion;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addKeyword(EmojiKeyword element) {
            this.keywords.add(Objects.requireNonNull(element, "keywords element"));
            return this;
        }

        public final Builder addKeywords(EmojiKeyword ... elements) {
            for (EmojiKeyword element : elements) {
                this.keywords.add(Objects.requireNonNull(element, "keywords element"));
            }
            return this;
        }

        public final Builder keywords(Iterable<? extends EmojiKeyword> elements) {
            this.keywords.clear();
            return this.addAllKeywords(elements);
        }

        public final Builder addAllKeywords(Iterable<? extends EmojiKeyword> elements) {
            for (EmojiKeyword emojiKeyword : elements) {
                this.keywords.add(Objects.requireNonNull(emojiKeyword, "keywords element"));
            }
            return this;
        }

        public ImmutableEmojiKeywordsDifference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEmojiKeywordsDifference(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("langCode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fromVersion");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build EmojiKeywordsDifference, some of required attributes are not set " + attributes;
        }
    }
}

