/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.EncryptedChat;
import telegram4j.tl.EncryptedChatDiscarded;
import telegram4j.tl.api.TlObject;

public final class ImmutableEncryptedChatDiscarded
implements EncryptedChatDiscarded {
    private final int identifier;
    private final int flags;
    private final boolean historyDeleted;
    private final int id;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableEncryptedChatDiscarded(int id) {
        this.id = id;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.historyDeleted = this.initShim.historyDeleted();
        this.initShim = null;
    }

    private ImmutableEncryptedChatDiscarded(Builder builder) {
        this.id = builder.id;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.historyDeletedIsSet()) {
            this.initShim.historyDeleted(builder.historyDeleted);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.historyDeleted = this.initShim.historyDeleted();
        this.initShim = null;
    }

    private ImmutableEncryptedChatDiscarded(int identifier, int flags, boolean historyDeleted, int id) {
        this.identifier = identifier;
        this.flags = flags;
        this.historyDeleted = historyDeleted;
        this.id = id;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return EncryptedChatDiscarded.super.identifier();
    }

    private int flagsInitialize() {
        return EncryptedChatDiscarded.super.flags();
    }

    private boolean historyDeletedInitialize() {
        return EncryptedChatDiscarded.super.historyDeleted();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean historyDeleted() {
        InitShim shim = this.initShim;
        return shim != null ? shim.historyDeleted() : this.historyDeleted;
    }

    @Override
    public int id() {
        return this.id;
    }

    public final ImmutableEncryptedChatDiscarded withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEncryptedChatDiscarded(value, this.flags, this.historyDeleted, this.id);
    }

    public final ImmutableEncryptedChatDiscarded withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableEncryptedChatDiscarded(this.identifier, value, this.historyDeleted, this.id);
    }

    public final ImmutableEncryptedChatDiscarded withHistoryDeleted(boolean value) {
        if (this.historyDeleted == value) {
            return this;
        }
        return new ImmutableEncryptedChatDiscarded(this.identifier, this.flags, value, this.id);
    }

    public final ImmutableEncryptedChatDiscarded withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableEncryptedChatDiscarded(this.identifier, this.flags, this.historyDeleted, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEncryptedChatDiscarded && this.equalTo(0, (ImmutableEncryptedChatDiscarded)another);
    }

    private boolean equalTo(int synthetic, ImmutableEncryptedChatDiscarded another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.historyDeleted == another.historyDeleted && this.id == another.id;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.historyDeleted);
        h += (h << 5) + this.id;
        return h;
    }

    public String toString() {
        return "EncryptedChatDiscarded{identifier=" + this.identifier + ", flags=" + this.flags + ", historyDeleted=" + this.historyDeleted + ", id=" + this.id + "}";
    }

    public static ImmutableEncryptedChatDiscarded of(int id) {
        return new ImmutableEncryptedChatDiscarded(id);
    }

    public static ImmutableEncryptedChatDiscarded copyOf(EncryptedChatDiscarded instance) {
        if (instance instanceof ImmutableEncryptedChatDiscarded) {
            return (ImmutableEncryptedChatDiscarded)instance;
        }
        return ImmutableEncryptedChatDiscarded.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_HISTORY_DELETED = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean historyDeleted;
        private int id;

        private Builder() {
        }

        public final Builder from(EncryptedChat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EncryptedChatDiscarded instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EncryptedChat instance;
            long bits = 0L;
            if (object instanceof EncryptedChat) {
                instance = (EncryptedChat)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EncryptedChatDiscarded) {
                instance = (EncryptedChatDiscarded)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
                this.historyDeleted(instance.historyDeleted());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder historyDeleted(boolean historyDeleted) {
            this.historyDeleted = historyDeleted;
            this.optBits |= 4L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableEncryptedChatDiscarded build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEncryptedChatDiscarded(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean historyDeletedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build EncryptedChatDiscarded, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte historyDeletedBuildStage = 0;
        private boolean historyDeleted;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableEncryptedChatDiscarded.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableEncryptedChatDiscarded.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean historyDeleted() {
            if (this.historyDeletedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.historyDeletedBuildStage == 0) {
                this.historyDeletedBuildStage = (byte)-1;
                this.historyDeleted = ImmutableEncryptedChatDiscarded.this.historyDeletedInitialize();
                this.historyDeletedBuildStage = 1;
            }
            return this.historyDeleted;
        }

        void historyDeleted(boolean historyDeleted) {
            this.historyDeleted = historyDeleted;
            this.historyDeletedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.historyDeletedBuildStage == -1) {
                attributes.add("historyDeleted");
            }
            return "Cannot build EncryptedChatDiscarded, attribute initializers form cycle " + attributes;
        }
    }
}

