/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.EncryptedChat;
import telegram4j.tl.EncryptedChatEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableEncryptedChatEmpty
implements EncryptedChatEmpty {
    private final int identifier;
    private final int id;

    private ImmutableEncryptedChatEmpty(int id) {
        this.id = id;
        this.identifier = EncryptedChatEmpty.super.identifier();
    }

    private ImmutableEncryptedChatEmpty(Builder builder) {
        this.id = builder.id;
        this.identifier = builder.identifierIsSet() ? builder.identifier : EncryptedChatEmpty.super.identifier();
    }

    private ImmutableEncryptedChatEmpty(int identifier, int id) {
        this.identifier = identifier;
        this.id = id;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int id() {
        return this.id;
    }

    public final ImmutableEncryptedChatEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEncryptedChatEmpty(value, this.id);
    }

    public final ImmutableEncryptedChatEmpty withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableEncryptedChatEmpty(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEncryptedChatEmpty && this.equalTo(0, (ImmutableEncryptedChatEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableEncryptedChatEmpty another) {
        return this.identifier == another.identifier && this.id == another.id;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id;
        return h;
    }

    public String toString() {
        return "EncryptedChatEmpty{identifier=" + this.identifier + ", id=" + this.id + "}";
    }

    public static ImmutableEncryptedChatEmpty of(int id) {
        return new ImmutableEncryptedChatEmpty(id);
    }

    public static ImmutableEncryptedChatEmpty copyOf(EncryptedChatEmpty instance) {
        if (instance instanceof ImmutableEncryptedChatEmpty) {
            return (ImmutableEncryptedChatEmpty)instance;
        }
        return ImmutableEncryptedChatEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int id;

        private Builder() {
        }

        public final Builder from(EncryptedChatEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EncryptedChat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EncryptedChat instance;
            long bits = 0L;
            if (object instanceof EncryptedChatEmpty) {
                instance = (EncryptedChatEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof EncryptedChat) {
                instance = (EncryptedChat)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableEncryptedChatEmpty build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEncryptedChatEmpty(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build EncryptedChatEmpty, some of required attributes are not set " + attributes;
        }
    }
}

