/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.EncryptedChat;
import telegram4j.tl.EncryptedChatRequested;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableEncryptedChatRequested
implements EncryptedChatRequested {
    private final int identifier;
    private final int flags;
    @Nullable
    private final Integer folderId;
    private final int id;
    private final long accessHash;
    private final int date;
    private final long adminId;
    private final long participantId;
    private final ByteBuf gA;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableEncryptedChatRequested(int id, long accessHash, int date, long adminId, long participantId) {
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.adminId = adminId;
        this.participantId = participantId;
        this.folderId = null;
        this.gA = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableEncryptedChatRequested(Builder builder) {
        this.folderId = builder.folderId;
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.date = builder.date;
        this.adminId = builder.adminId;
        this.participantId = builder.participantId;
        this.gA = builder.gA_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableEncryptedChatRequested(int identifier, int flags, @Nullable Integer folderId, int id, long accessHash, int date, long adminId, long participantId, ByteBuf gA) {
        this.identifier = identifier;
        this.flags = flags;
        this.folderId = folderId;
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.adminId = adminId;
        this.participantId = participantId;
        this.gA = gA;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return EncryptedChatRequested.super.identifier();
    }

    private int flagsInitialize() {
        return EncryptedChatRequested.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public Integer folderId() {
        return this.folderId;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public long adminId() {
        return this.adminId;
    }

    @Override
    public long participantId() {
        return this.participantId;
    }

    @Override
    public ByteBuf gA() {
        return this.gA.duplicate();
    }

    public final ImmutableEncryptedChatRequested withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEncryptedChatRequested(value, this.flags, this.folderId, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gA);
    }

    public final ImmutableEncryptedChatRequested withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableEncryptedChatRequested(this.identifier, value, this.folderId, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gA);
    }

    public final ImmutableEncryptedChatRequested withFolderId(@Nullable Integer value) {
        if (Objects.equals(this.folderId, value)) {
            return this;
        }
        return new ImmutableEncryptedChatRequested(this.identifier, this.flags, value, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gA);
    }

    public final ImmutableEncryptedChatRequested withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableEncryptedChatRequested(this.identifier, this.flags, this.folderId, value, this.accessHash, this.date, this.adminId, this.participantId, this.gA);
    }

    public final ImmutableEncryptedChatRequested withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableEncryptedChatRequested(this.identifier, this.flags, this.folderId, this.id, value, this.date, this.adminId, this.participantId, this.gA);
    }

    public final ImmutableEncryptedChatRequested withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableEncryptedChatRequested(this.identifier, this.flags, this.folderId, this.id, this.accessHash, value, this.adminId, this.participantId, this.gA);
    }

    public final ImmutableEncryptedChatRequested withAdminId(long value) {
        if (this.adminId == value) {
            return this;
        }
        return new ImmutableEncryptedChatRequested(this.identifier, this.flags, this.folderId, this.id, this.accessHash, this.date, value, this.participantId, this.gA);
    }

    public final ImmutableEncryptedChatRequested withParticipantId(long value) {
        if (this.participantId == value) {
            return this;
        }
        return new ImmutableEncryptedChatRequested(this.identifier, this.flags, this.folderId, this.id, this.accessHash, this.date, this.adminId, value, this.gA);
    }

    public ImmutableEncryptedChatRequested withGA(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.gA == newValue) {
            return this;
        }
        return new ImmutableEncryptedChatRequested(this.identifier, this.flags, this.folderId, this.id, this.accessHash, this.date, this.adminId, this.participantId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEncryptedChatRequested && this.equalTo(0, (ImmutableEncryptedChatRequested)another);
    }

    private boolean equalTo(int synthetic, ImmutableEncryptedChatRequested another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.folderId, another.folderId) && this.id == another.id && this.accessHash == another.accessHash && this.date == another.date && this.adminId == another.adminId && this.participantId == another.participantId && this.gA().equals((Object)another.gA());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.folderId);
        h += (h << 5) + this.id;
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.date;
        h += (h << 5) + Long.hashCode(this.adminId);
        h += (h << 5) + Long.hashCode(this.participantId);
        h += (h << 5) + this.gA().hashCode();
        return h;
    }

    public String toString() {
        return "EncryptedChatRequested{identifier=" + this.identifier + ", flags=" + this.flags + ", folderId=" + this.folderId + ", id=" + this.id + ", accessHash=" + this.accessHash + ", date=" + this.date + ", adminId=" + this.adminId + ", participantId=" + this.participantId + ", gA=" + ByteBufUtil.hexDump((ByteBuf)this.gA) + "}";
    }

    public static ImmutableEncryptedChatRequested of(int id, long accessHash, int date, long adminId, long participantId) {
        return new ImmutableEncryptedChatRequested(id, accessHash, date, adminId, participantId);
    }

    public static ImmutableEncryptedChatRequested copyOf(EncryptedChatRequested instance) {
        if (instance instanceof ImmutableEncryptedChatRequested) {
            return (ImmutableEncryptedChatRequested)instance;
        }
        return ImmutableEncryptedChatRequested.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long INIT_BIT_ADMIN_ID = 8L;
        private static final long INIT_BIT_PARTICIPANT_ID = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 31L;
        private long optBits;
        private ByteBuf gA_value = null;
        private int identifier;
        private int flags;
        private Integer folderId;
        private int id;
        private long accessHash;
        private int date;
        private long adminId;
        private long participantId;

        private Builder() {
        }

        public final Builder from(EncryptedChat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EncryptedChatRequested instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EncryptedChat instance;
            long bits = 0L;
            if (object instanceof EncryptedChat) {
                instance = (EncryptedChat)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof EncryptedChatRequested) {
                Integer folderIdValue;
                instance = (EncryptedChatRequested)object;
                this.date(instance.date());
                this.participantId(instance.participantId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.flags(instance.flags());
                this.adminId(instance.adminId());
                this.accessHash(instance.accessHash());
                this.gA(instance.gA());
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
                if ((folderIdValue = instance.folderId()) != null) {
                    this.folderId(folderIdValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder folderId(@Nullable Integer folderId) {
            this.folderId = folderId;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder adminId(long adminId) {
            this.adminId = adminId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder participantId(long participantId) {
            this.participantId = participantId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder gA(ByteBuf value) {
            this.gA_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableEncryptedChatRequested build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEncryptedChatRequested(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("adminId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("participantId");
            }
            return "Cannot build EncryptedChatRequested, some of required attributes are not set " + attributes;
        }

        private ByteBuf gA_build() {
            return Objects.requireNonNull(this.gA_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableEncryptedChatRequested.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableEncryptedChatRequested.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build EncryptedChatRequested, attribute initializers form cycle " + attributes;
        }
    }
}

