/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.EncryptedChat;
import telegram4j.tl.EncryptedChatWaiting;
import telegram4j.tl.api.TlObject;

public final class ImmutableEncryptedChatWaiting
implements EncryptedChatWaiting {
    private final int identifier;
    private final int id;
    private final long accessHash;
    private final int date;
    private final long adminId;
    private final long participantId;

    private ImmutableEncryptedChatWaiting(int id, long accessHash, int date, long adminId, long participantId) {
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.adminId = adminId;
        this.participantId = participantId;
        this.identifier = EncryptedChatWaiting.super.identifier();
    }

    private ImmutableEncryptedChatWaiting(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.date = builder.date;
        this.adminId = builder.adminId;
        this.participantId = builder.participantId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : EncryptedChatWaiting.super.identifier();
    }

    private ImmutableEncryptedChatWaiting(int identifier, int id, long accessHash, int date, long adminId, long participantId) {
        this.identifier = identifier;
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.adminId = adminId;
        this.participantId = participantId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public long adminId() {
        return this.adminId;
    }

    @Override
    public long participantId() {
        return this.participantId;
    }

    public final ImmutableEncryptedChatWaiting withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEncryptedChatWaiting(value, this.id, this.accessHash, this.date, this.adminId, this.participantId);
    }

    public final ImmutableEncryptedChatWaiting withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableEncryptedChatWaiting(this.identifier, value, this.accessHash, this.date, this.adminId, this.participantId);
    }

    public final ImmutableEncryptedChatWaiting withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableEncryptedChatWaiting(this.identifier, this.id, value, this.date, this.adminId, this.participantId);
    }

    public final ImmutableEncryptedChatWaiting withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableEncryptedChatWaiting(this.identifier, this.id, this.accessHash, value, this.adminId, this.participantId);
    }

    public final ImmutableEncryptedChatWaiting withAdminId(long value) {
        if (this.adminId == value) {
            return this;
        }
        return new ImmutableEncryptedChatWaiting(this.identifier, this.id, this.accessHash, this.date, value, this.participantId);
    }

    public final ImmutableEncryptedChatWaiting withParticipantId(long value) {
        if (this.participantId == value) {
            return this;
        }
        return new ImmutableEncryptedChatWaiting(this.identifier, this.id, this.accessHash, this.date, this.adminId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEncryptedChatWaiting && this.equalTo(0, (ImmutableEncryptedChatWaiting)another);
    }

    private boolean equalTo(int synthetic, ImmutableEncryptedChatWaiting another) {
        return this.identifier == another.identifier && this.id == another.id && this.accessHash == another.accessHash && this.date == another.date && this.adminId == another.adminId && this.participantId == another.participantId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id;
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.date;
        h += (h << 5) + Long.hashCode(this.adminId);
        h += (h << 5) + Long.hashCode(this.participantId);
        return h;
    }

    public String toString() {
        return "EncryptedChatWaiting{identifier=" + this.identifier + ", id=" + this.id + ", accessHash=" + this.accessHash + ", date=" + this.date + ", adminId=" + this.adminId + ", participantId=" + this.participantId + "}";
    }

    public static ImmutableEncryptedChatWaiting of(int id, long accessHash, int date, long adminId, long participantId) {
        return new ImmutableEncryptedChatWaiting(id, accessHash, date, adminId, participantId);
    }

    public static ImmutableEncryptedChatWaiting copyOf(EncryptedChatWaiting instance) {
        if (instance instanceof ImmutableEncryptedChatWaiting) {
            return (ImmutableEncryptedChatWaiting)instance;
        }
        return ImmutableEncryptedChatWaiting.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long INIT_BIT_ADMIN_ID = 8L;
        private static final long INIT_BIT_PARTICIPANT_ID = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 31L;
        private long optBits;
        private int identifier;
        private int id;
        private long accessHash;
        private int date;
        private long adminId;
        private long participantId;

        private Builder() {
        }

        public final Builder from(EncryptedChat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EncryptedChatWaiting instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EncryptedChat instance;
            long bits = 0L;
            if (object instanceof EncryptedChat) {
                instance = (EncryptedChat)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof EncryptedChatWaiting) {
                instance = (EncryptedChatWaiting)object;
                this.date(instance.date());
                this.participantId(instance.participantId());
                this.adminId(instance.adminId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.accessHash(instance.accessHash());
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder adminId(long adminId) {
            this.adminId = adminId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder participantId(long participantId) {
            this.participantId = participantId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableEncryptedChatWaiting build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEncryptedChatWaiting(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("adminId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("participantId");
            }
            return "Cannot build EncryptedChatWaiting, some of required attributes are not set " + attributes;
        }
    }
}

