/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.EncryptedFile;
import telegram4j.tl.EncryptedFileEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableEncryptedFileEmpty
implements EncryptedFileEmpty {
    private final int identifier;
    private static final ImmutableEncryptedFileEmpty INSTANCE = ImmutableEncryptedFileEmpty.validate(new ImmutableEncryptedFileEmpty());

    private ImmutableEncryptedFileEmpty() {
        this.identifier = EncryptedFileEmpty.super.identifier();
    }

    private ImmutableEncryptedFileEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : EncryptedFileEmpty.super.identifier();
    }

    private ImmutableEncryptedFileEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableEncryptedFileEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableEncryptedFileEmpty.validate(new ImmutableEncryptedFileEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEncryptedFileEmpty && this.equalTo(0, (ImmutableEncryptedFileEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableEncryptedFileEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "EncryptedFileEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableEncryptedFileEmpty of() {
        return INSTANCE;
    }

    private static ImmutableEncryptedFileEmpty validate(ImmutableEncryptedFileEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableEncryptedFileEmpty copyOf(EncryptedFileEmpty instance) {
        if (instance instanceof ImmutableEncryptedFileEmpty) {
            return (ImmutableEncryptedFileEmpty)instance;
        }
        return ImmutableEncryptedFileEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(EncryptedFileEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EncryptedFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EncryptedFile instance;
            long bits = 0L;
            if (object instanceof EncryptedFileEmpty) {
                instance = (EncryptedFileEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EncryptedFile) {
                instance = (EncryptedFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableEncryptedFileEmpty build() {
            return ImmutableEncryptedFileEmpty.validate(new ImmutableEncryptedFileEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

