/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.EncryptedMessage;
import telegram4j.tl.EncryptedMessageService;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableEncryptedMessageService
implements EncryptedMessageService {
    private final int identifier;
    private final long randomId;
    private final int chatId;
    private final int date;
    private final ByteBuf bytes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableEncryptedMessageService(long randomId, int chatId, int date) {
        this.randomId = randomId;
        this.chatId = chatId;
        this.date = date;
        this.bytes = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableEncryptedMessageService(Builder builder) {
        this.randomId = builder.randomId;
        this.chatId = builder.chatId;
        this.date = builder.date;
        this.bytes = builder.bytes_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableEncryptedMessageService(int identifier, long randomId, int chatId, int date, ByteBuf bytes) {
        this.identifier = identifier;
        this.randomId = randomId;
        this.chatId = chatId;
        this.date = date;
        this.bytes = bytes;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return EncryptedMessageService.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long randomId() {
        return this.randomId;
    }

    @Override
    public int chatId() {
        return this.chatId;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public ByteBuf bytes() {
        return this.bytes.duplicate();
    }

    public final ImmutableEncryptedMessageService withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableEncryptedMessageService(value, this.randomId, this.chatId, this.date, this.bytes);
    }

    public final ImmutableEncryptedMessageService withRandomId(long value) {
        if (this.randomId == value) {
            return this;
        }
        return new ImmutableEncryptedMessageService(this.identifier, value, this.chatId, this.date, this.bytes);
    }

    public final ImmutableEncryptedMessageService withChatId(int value) {
        if (this.chatId == value) {
            return this;
        }
        return new ImmutableEncryptedMessageService(this.identifier, this.randomId, value, this.date, this.bytes);
    }

    public final ImmutableEncryptedMessageService withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableEncryptedMessageService(this.identifier, this.randomId, this.chatId, value, this.bytes);
    }

    public ImmutableEncryptedMessageService withBytes(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.bytes == newValue) {
            return this;
        }
        return new ImmutableEncryptedMessageService(this.identifier, this.randomId, this.chatId, this.date, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEncryptedMessageService && this.equalTo(0, (ImmutableEncryptedMessageService)another);
    }

    private boolean equalTo(int synthetic, ImmutableEncryptedMessageService another) {
        return this.identifier == another.identifier && this.randomId == another.randomId && this.chatId == another.chatId && this.date == another.date && this.bytes().equals((Object)another.bytes());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.randomId);
        h += (h << 5) + this.chatId;
        h += (h << 5) + this.date;
        h += (h << 5) + this.bytes().hashCode();
        return h;
    }

    public String toString() {
        return "EncryptedMessageService{identifier=" + this.identifier + ", randomId=" + this.randomId + ", chatId=" + this.chatId + ", date=" + this.date + ", bytes=" + ByteBufUtil.hexDump((ByteBuf)this.bytes) + "}";
    }

    public static ImmutableEncryptedMessageService of(long randomId, int chatId, int date) {
        return new ImmutableEncryptedMessageService(randomId, chatId, date);
    }

    public static ImmutableEncryptedMessageService copyOf(EncryptedMessageService instance) {
        if (instance instanceof ImmutableEncryptedMessageService) {
            return (ImmutableEncryptedMessageService)instance;
        }
        return ImmutableEncryptedMessageService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_RANDOM_ID = 1L;
        private static final long INIT_BIT_CHAT_ID = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf bytes_value = null;
        private int identifier;
        private long randomId;
        private int chatId;
        private int date;

        private Builder() {
        }

        public final Builder from(EncryptedMessageService instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EncryptedMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            EncryptedMessage instance;
            long bits = 0L;
            if (object instanceof EncryptedMessageService) {
                instance = (EncryptedMessageService)object;
                if ((bits & 1L) == 0L) {
                    this.date(instance.date());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.randomId(instance.randomId());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.chatId(instance.chatId());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.bytes(instance.bytes());
                    bits |= 0x10L;
                }
            }
            if (object instanceof EncryptedMessage) {
                instance = (EncryptedMessage)object;
                if ((bits & 1L) == 0L) {
                    this.date(instance.date());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.randomId(instance.randomId());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.chatId(instance.chatId());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.bytes(instance.bytes());
                    bits |= 0x10L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder randomId(long randomId) {
            this.randomId = randomId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder chatId(int chatId) {
            this.chatId = chatId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder bytes(ByteBuf value) {
            this.bytes_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableEncryptedMessageService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEncryptedMessageService(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("randomId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("chatId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build EncryptedMessageService, some of required attributes are not set " + attributes;
        }

        private ByteBuf bytes_build() {
            return Objects.requireNonNull(this.bytes_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableEncryptedMessageService.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build EncryptedMessageService, attribute initializers form cycle " + attributes;
        }
    }
}

