/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Error;
import telegram4j.tl.api.TlObject;

public final class ImmutableError
implements Error {
    private final int identifier;
    private final int code;
    private final String text;

    private ImmutableError(int code, String text) {
        this.code = code;
        this.text = Objects.requireNonNull(text, "text");
        this.identifier = Error.super.identifier();
    }

    private ImmutableError(Builder builder) {
        this.code = builder.code;
        this.text = builder.text;
        this.identifier = builder.identifierIsSet() ? builder.identifier : Error.super.identifier();
    }

    private ImmutableError(int identifier, int code, String text) {
        this.identifier = identifier;
        this.code = code;
        this.text = text;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public String text() {
        return this.text;
    }

    public final ImmutableError withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableError(value, this.code, this.text);
    }

    public final ImmutableError withCode(int value) {
        if (this.code == value) {
            return this;
        }
        return new ImmutableError(this.identifier, value, this.text);
    }

    public final ImmutableError withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableError(this.identifier, this.code, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableError && this.equalTo(0, (ImmutableError)another);
    }

    private boolean equalTo(int synthetic, ImmutableError another) {
        return this.identifier == another.identifier && this.code == another.code && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.code;
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return "Error{identifier=" + this.identifier + ", code=" + this.code + ", text=" + this.text + "}";
    }

    public static ImmutableError of(int code, String text) {
        return new ImmutableError(code, text);
    }

    public static ImmutableError copyOf(Error instance) {
        if (instance instanceof ImmutableError) {
            return (ImmutableError)instance;
        }
        return ImmutableError.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CODE = 1L;
        private static final long INIT_BIT_TEXT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int code;
        private String text;

        private Builder() {
        }

        public final Builder from(Error instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Error instance;
            long bits = 0L;
            if (object instanceof Error) {
                instance = (Error)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.code(instance.code());
                this.text(instance.text());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder code(int code) {
            this.code = code;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableError build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableError(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("code");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build Error, some of required attributes are not set " + attributes;
        }
    }
}

