/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ExportedMessageLink;
import telegram4j.tl.api.TlObject;

public final class ImmutableExportedMessageLink
implements ExportedMessageLink {
    private final int identifier;
    private final String link;
    private final String html;

    private ImmutableExportedMessageLink(String link, String html) {
        this.link = Objects.requireNonNull(link, "link");
        this.html = Objects.requireNonNull(html, "html");
        this.identifier = ExportedMessageLink.super.identifier();
    }

    private ImmutableExportedMessageLink(Builder builder) {
        this.link = builder.link;
        this.html = builder.html;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ExportedMessageLink.super.identifier();
    }

    private ImmutableExportedMessageLink(int identifier, String link, String html) {
        this.identifier = identifier;
        this.link = link;
        this.html = html;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String link() {
        return this.link;
    }

    @Override
    public String html() {
        return this.html;
    }

    public final ImmutableExportedMessageLink withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableExportedMessageLink(value, this.link, this.html);
    }

    public final ImmutableExportedMessageLink withLink(String value) {
        String newValue = Objects.requireNonNull(value, "link");
        if (this.link.equals(newValue)) {
            return this;
        }
        return new ImmutableExportedMessageLink(this.identifier, newValue, this.html);
    }

    public final ImmutableExportedMessageLink withHtml(String value) {
        String newValue = Objects.requireNonNull(value, "html");
        if (this.html.equals(newValue)) {
            return this;
        }
        return new ImmutableExportedMessageLink(this.identifier, this.link, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExportedMessageLink && this.equalTo(0, (ImmutableExportedMessageLink)another);
    }

    private boolean equalTo(int synthetic, ImmutableExportedMessageLink another) {
        return this.identifier == another.identifier && this.link.equals(another.link) && this.html.equals(another.html);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.link.hashCode();
        h += (h << 5) + this.html.hashCode();
        return h;
    }

    public String toString() {
        return "ExportedMessageLink{identifier=" + this.identifier + ", link=" + this.link + ", html=" + this.html + "}";
    }

    public static ImmutableExportedMessageLink of(String link, String html) {
        return new ImmutableExportedMessageLink(link, html);
    }

    public static ImmutableExportedMessageLink copyOf(ExportedMessageLink instance) {
        if (instance instanceof ImmutableExportedMessageLink) {
            return (ImmutableExportedMessageLink)instance;
        }
        return ImmutableExportedMessageLink.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LINK = 1L;
        private static final long INIT_BIT_HTML = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String link;
        private String html;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ExportedMessageLink instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ExportedMessageLink) {
                instance = (ExportedMessageLink)object;
                this.link(instance.link());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.html(instance.html());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder link(String link) {
            this.link = Objects.requireNonNull(link, "link");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder html(String html) {
            this.html = Objects.requireNonNull(html, "html");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableExportedMessageLink build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExportedMessageLink(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("link");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("html");
            }
            return "Cannot build ExportedMessageLink, some of required attributes are not set " + attributes;
        }
    }
}

