/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.FileHash;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableFileHash
implements FileHash {
    private final int identifier;
    private final long offset;
    private final int limit;
    private final ByteBuf hash;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFileHash(long offset, int limit) {
        this.offset = offset;
        this.limit = limit;
        this.hash = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableFileHash(Builder builder) {
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.hash = builder.hash_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableFileHash(int identifier, long offset, int limit, ByteBuf hash) {
        this.identifier = identifier;
        this.offset = offset;
        this.limit = limit;
        this.hash = hash;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return FileHash.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public ByteBuf hash() {
        return this.hash.duplicate();
    }

    public final ImmutableFileHash withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableFileHash(value, this.offset, this.limit, this.hash);
    }

    public final ImmutableFileHash withOffset(long value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableFileHash(this.identifier, value, this.limit, this.hash);
    }

    public final ImmutableFileHash withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        return new ImmutableFileHash(this.identifier, this.offset, value, this.hash);
    }

    public ImmutableFileHash withHash(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.hash == newValue) {
            return this;
        }
        return new ImmutableFileHash(this.identifier, this.offset, this.limit, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileHash && this.equalTo(0, (ImmutableFileHash)another);
    }

    private boolean equalTo(int synthetic, ImmutableFileHash another) {
        return this.identifier == another.identifier && this.offset == another.offset && this.limit == another.limit && this.hash().equals((Object)another.hash());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.offset);
        h += (h << 5) + this.limit;
        h += (h << 5) + this.hash().hashCode();
        return h;
    }

    public String toString() {
        return "FileHash{identifier=" + this.identifier + ", offset=" + this.offset + ", limit=" + this.limit + ", hash=" + ByteBufUtil.hexDump((ByteBuf)this.hash) + "}";
    }

    public static ImmutableFileHash of(long offset, int limit) {
        return new ImmutableFileHash(offset, limit);
    }

    public static ImmutableFileHash copyOf(FileHash instance) {
        if (instance instanceof ImmutableFileHash) {
            return (ImmutableFileHash)instance;
        }
        return ImmutableFileHash.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OFFSET = 1L;
        private static final long INIT_BIT_LIMIT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf hash_value = null;
        private int identifier;
        private long offset;
        private int limit;

        private Builder() {
        }

        public final Builder from(FileHash instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            FileHash instance;
            long bits = 0L;
            if (object instanceof FileHash) {
                instance = (FileHash)object;
                this.limit(instance.limit());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.offset(instance.offset());
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder offset(long offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder hash(ByteBuf value) {
            this.hash_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableFileHash build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileHash(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("offset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build FileHash, some of required attributes are not set " + attributes;
        }

        private ByteBuf hash_build() {
            return Objects.requireNonNull(this.hash_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableFileHash.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build FileHash, attribute initializers form cycle " + attributes;
        }
    }
}

