/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.ChatPhoto;
import telegram4j.tl.Folder;
import telegram4j.tl.api.TlObject;

public final class ImmutableFolder
implements Folder {
    private final int identifier;
    private final int flags;
    private final boolean autofillNewBroadcasts;
    private final boolean autofillPublicGroups;
    private final boolean autofillNewCorrespondents;
    private final int id;
    private final String title;
    @Nullable
    private final ChatPhoto photo;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFolder(int id, String title) {
        this.id = id;
        this.title = Objects.requireNonNull(title, "title");
        this.photo = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.autofillNewBroadcasts = this.initShim.autofillNewBroadcasts();
        this.autofillPublicGroups = this.initShim.autofillPublicGroups();
        this.autofillNewCorrespondents = this.initShim.autofillNewCorrespondents();
        this.initShim = null;
    }

    private ImmutableFolder(Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.photo = builder.photo;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.autofillNewBroadcastsIsSet()) {
            this.initShim.autofillNewBroadcasts(builder.autofillNewBroadcasts);
        }
        if (builder.autofillPublicGroupsIsSet()) {
            this.initShim.autofillPublicGroups(builder.autofillPublicGroups);
        }
        if (builder.autofillNewCorrespondentsIsSet()) {
            this.initShim.autofillNewCorrespondents(builder.autofillNewCorrespondents);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.autofillNewBroadcasts = this.initShim.autofillNewBroadcasts();
        this.autofillPublicGroups = this.initShim.autofillPublicGroups();
        this.autofillNewCorrespondents = this.initShim.autofillNewCorrespondents();
        this.initShim = null;
    }

    private ImmutableFolder(int identifier, int flags, boolean autofillNewBroadcasts, boolean autofillPublicGroups, boolean autofillNewCorrespondents, int id, String title, @Nullable ChatPhoto photo) {
        this.identifier = identifier;
        this.flags = flags;
        this.autofillNewBroadcasts = autofillNewBroadcasts;
        this.autofillPublicGroups = autofillPublicGroups;
        this.autofillNewCorrespondents = autofillNewCorrespondents;
        this.id = id;
        this.title = title;
        this.photo = photo;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return Folder.super.identifier();
    }

    private int flagsInitialize() {
        return Folder.super.flags();
    }

    private boolean autofillNewBroadcastsInitialize() {
        return Folder.super.autofillNewBroadcasts();
    }

    private boolean autofillPublicGroupsInitialize() {
        return Folder.super.autofillPublicGroups();
    }

    private boolean autofillNewCorrespondentsInitialize() {
        return Folder.super.autofillNewCorrespondents();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean autofillNewBroadcasts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.autofillNewBroadcasts() : this.autofillNewBroadcasts;
    }

    @Override
    public boolean autofillPublicGroups() {
        InitShim shim = this.initShim;
        return shim != null ? shim.autofillPublicGroups() : this.autofillPublicGroups;
    }

    @Override
    public boolean autofillNewCorrespondents() {
        InitShim shim = this.initShim;
        return shim != null ? shim.autofillNewCorrespondents() : this.autofillNewCorrespondents;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public ChatPhoto photo() {
        return this.photo;
    }

    public final ImmutableFolder withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableFolder(value, this.flags, this.autofillNewBroadcasts, this.autofillPublicGroups, this.autofillNewCorrespondents, this.id, this.title, this.photo);
    }

    public final ImmutableFolder withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableFolder(this.identifier, value, this.autofillNewBroadcasts, this.autofillPublicGroups, this.autofillNewCorrespondents, this.id, this.title, this.photo);
    }

    public final ImmutableFolder withAutofillNewBroadcasts(boolean value) {
        if (this.autofillNewBroadcasts == value) {
            return this;
        }
        return new ImmutableFolder(this.identifier, this.flags, value, this.autofillPublicGroups, this.autofillNewCorrespondents, this.id, this.title, this.photo);
    }

    public final ImmutableFolder withAutofillPublicGroups(boolean value) {
        if (this.autofillPublicGroups == value) {
            return this;
        }
        return new ImmutableFolder(this.identifier, this.flags, this.autofillNewBroadcasts, value, this.autofillNewCorrespondents, this.id, this.title, this.photo);
    }

    public final ImmutableFolder withAutofillNewCorrespondents(boolean value) {
        if (this.autofillNewCorrespondents == value) {
            return this;
        }
        return new ImmutableFolder(this.identifier, this.flags, this.autofillNewBroadcasts, this.autofillPublicGroups, value, this.id, this.title, this.photo);
    }

    public final ImmutableFolder withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableFolder(this.identifier, this.flags, this.autofillNewBroadcasts, this.autofillPublicGroups, this.autofillNewCorrespondents, value, this.title, this.photo);
    }

    public final ImmutableFolder withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableFolder(this.identifier, this.flags, this.autofillNewBroadcasts, this.autofillPublicGroups, this.autofillNewCorrespondents, this.id, newValue, this.photo);
    }

    public final ImmutableFolder withPhoto(@Nullable ChatPhoto value) {
        if (this.photo == value) {
            return this;
        }
        return new ImmutableFolder(this.identifier, this.flags, this.autofillNewBroadcasts, this.autofillPublicGroups, this.autofillNewCorrespondents, this.id, this.title, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFolder && this.equalTo(0, (ImmutableFolder)another);
    }

    private boolean equalTo(int synthetic, ImmutableFolder another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.autofillNewBroadcasts == another.autofillNewBroadcasts && this.autofillPublicGroups == another.autofillPublicGroups && this.autofillNewCorrespondents == another.autofillNewCorrespondents && this.id == another.id && this.title.equals(another.title) && Objects.equals(this.photo, another.photo);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.autofillNewBroadcasts);
        h += (h << 5) + Boolean.hashCode(this.autofillPublicGroups);
        h += (h << 5) + Boolean.hashCode(this.autofillNewCorrespondents);
        h += (h << 5) + this.id;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.photo);
        return h;
    }

    public String toString() {
        return "Folder{identifier=" + this.identifier + ", flags=" + this.flags + ", autofillNewBroadcasts=" + this.autofillNewBroadcasts + ", autofillPublicGroups=" + this.autofillPublicGroups + ", autofillNewCorrespondents=" + this.autofillNewCorrespondents + ", id=" + this.id + ", title=" + this.title + ", photo=" + this.photo + "}";
    }

    public static ImmutableFolder of(int id, String title) {
        return new ImmutableFolder(id, title);
    }

    public static ImmutableFolder copyOf(Folder instance) {
        if (instance instanceof ImmutableFolder) {
            return (ImmutableFolder)instance;
        }
        return ImmutableFolder.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_AUTOFILL_NEW_BROADCASTS = 4L;
        private static final long OPT_BIT_AUTOFILL_PUBLIC_GROUPS = 8L;
        private static final long OPT_BIT_AUTOFILL_NEW_CORRESPONDENTS = 16L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean autofillNewBroadcasts;
        private boolean autofillPublicGroups;
        private boolean autofillNewCorrespondents;
        private int id;
        private String title;
        private ChatPhoto photo;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Folder instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Folder) {
                instance = (Folder)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.autofillNewBroadcasts(instance.autofillNewBroadcasts());
                this.flags(instance.flags());
                ChatPhoto photoValue = instance.photo();
                if (photoValue != null) {
                    this.photo(photoValue);
                }
                this.autofillPublicGroups(instance.autofillPublicGroups());
                this.id(instance.id());
                this.title(instance.title());
                this.autofillNewCorrespondents(instance.autofillNewCorrespondents());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder autofillNewBroadcasts(boolean autofillNewBroadcasts) {
            this.autofillNewBroadcasts = autofillNewBroadcasts;
            this.optBits |= 4L;
            return this;
        }

        public final Builder autofillPublicGroups(boolean autofillPublicGroups) {
            this.autofillPublicGroups = autofillPublicGroups;
            this.optBits |= 8L;
            return this;
        }

        public final Builder autofillNewCorrespondents(boolean autofillNewCorrespondents) {
            this.autofillNewCorrespondents = autofillNewCorrespondents;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder photo(@Nullable ChatPhoto photo) {
            this.photo = photo;
            return this;
        }

        public ImmutableFolder build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFolder(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean autofillNewBroadcastsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean autofillPublicGroupsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean autofillNewCorrespondentsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build Folder, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte autofillNewBroadcastsBuildStage = 0;
        private boolean autofillNewBroadcasts;
        private byte autofillPublicGroupsBuildStage = 0;
        private boolean autofillPublicGroups;
        private byte autofillNewCorrespondentsBuildStage = 0;
        private boolean autofillNewCorrespondents;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableFolder.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableFolder.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean autofillNewBroadcasts() {
            if (this.autofillNewBroadcastsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.autofillNewBroadcastsBuildStage == 0) {
                this.autofillNewBroadcastsBuildStage = (byte)-1;
                this.autofillNewBroadcasts = ImmutableFolder.this.autofillNewBroadcastsInitialize();
                this.autofillNewBroadcastsBuildStage = 1;
            }
            return this.autofillNewBroadcasts;
        }

        void autofillNewBroadcasts(boolean autofillNewBroadcasts) {
            this.autofillNewBroadcasts = autofillNewBroadcasts;
            this.autofillNewBroadcastsBuildStage = 1;
        }

        boolean autofillPublicGroups() {
            if (this.autofillPublicGroupsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.autofillPublicGroupsBuildStage == 0) {
                this.autofillPublicGroupsBuildStage = (byte)-1;
                this.autofillPublicGroups = ImmutableFolder.this.autofillPublicGroupsInitialize();
                this.autofillPublicGroupsBuildStage = 1;
            }
            return this.autofillPublicGroups;
        }

        void autofillPublicGroups(boolean autofillPublicGroups) {
            this.autofillPublicGroups = autofillPublicGroups;
            this.autofillPublicGroupsBuildStage = 1;
        }

        boolean autofillNewCorrespondents() {
            if (this.autofillNewCorrespondentsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.autofillNewCorrespondentsBuildStage == 0) {
                this.autofillNewCorrespondentsBuildStage = (byte)-1;
                this.autofillNewCorrespondents = ImmutableFolder.this.autofillNewCorrespondentsInitialize();
                this.autofillNewCorrespondentsBuildStage = 1;
            }
            return this.autofillNewCorrespondents;
        }

        void autofillNewCorrespondents(boolean autofillNewCorrespondents) {
            this.autofillNewCorrespondents = autofillNewCorrespondents;
            this.autofillNewCorrespondentsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.autofillNewBroadcastsBuildStage == -1) {
                attributes.add("autofillNewBroadcasts");
            }
            if (this.autofillPublicGroupsBuildStage == -1) {
                attributes.add("autofillPublicGroups");
            }
            if (this.autofillNewCorrespondentsBuildStage == -1) {
                attributes.add("autofillNewCorrespondents");
            }
            return "Cannot build Folder, attribute initializers form cycle " + attributes;
        }
    }
}

