/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.FolderPeer;
import telegram4j.tl.Peer;
import telegram4j.tl.api.TlObject;

public final class ImmutableFolderPeer
implements FolderPeer {
    private final int identifier;
    private final Peer peer;
    private final int folderId;

    private ImmutableFolderPeer(Peer peer, int folderId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.folderId = folderId;
        this.identifier = FolderPeer.super.identifier();
    }

    private ImmutableFolderPeer(Builder builder) {
        this.peer = builder.peer;
        this.folderId = builder.folderId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : FolderPeer.super.identifier();
    }

    private ImmutableFolderPeer(int identifier, Peer peer, int folderId) {
        this.identifier = identifier;
        this.peer = peer;
        this.folderId = folderId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public int folderId() {
        return this.folderId;
    }

    public final ImmutableFolderPeer withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableFolderPeer(value, this.peer, this.folderId);
    }

    public final ImmutableFolderPeer withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableFolderPeer(this.identifier, newValue, this.folderId);
    }

    public final ImmutableFolderPeer withFolderId(int value) {
        if (this.folderId == value) {
            return this;
        }
        return new ImmutableFolderPeer(this.identifier, this.peer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFolderPeer && this.equalTo(0, (ImmutableFolderPeer)another);
    }

    private boolean equalTo(int synthetic, ImmutableFolderPeer another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.folderId == another.folderId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.folderId;
        return h;
    }

    public String toString() {
        return "FolderPeer{identifier=" + this.identifier + ", peer=" + this.peer + ", folderId=" + this.folderId + "}";
    }

    public static ImmutableFolderPeer of(Peer peer, int folderId) {
        return new ImmutableFolderPeer(peer, folderId);
    }

    public static ImmutableFolderPeer copyOf(FolderPeer instance) {
        if (instance instanceof ImmutableFolderPeer) {
            return (ImmutableFolderPeer)instance;
        }
        return ImmutableFolderPeer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_FOLDER_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private Peer peer;
        private int folderId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FolderPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof FolderPeer) {
                instance = (FolderPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
                this.folderId(instance.folderId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder folderId(int folderId) {
            this.folderId = folderId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableFolderPeer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFolderPeer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("folderId");
            }
            return "Cannot build FolderPeer, some of required attributes are not set " + attributes;
        }
    }
}

