/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Document;
import telegram4j.tl.Game;
import telegram4j.tl.Photo;
import telegram4j.tl.api.TlObject;

public final class ImmutableGame
implements Game {
    private final int identifier;
    private final int flags;
    private final long id;
    private final long accessHash;
    private final String shortName;
    private final String title;
    private final String description;
    private final Photo photo;
    @Nullable
    private final Document document;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGame(long id, long accessHash, String shortName, String title, String description, Photo photo) {
        this.id = id;
        this.accessHash = accessHash;
        this.shortName = Objects.requireNonNull(shortName, "shortName");
        this.title = Objects.requireNonNull(title, "title");
        this.description = Objects.requireNonNull(description, "description");
        this.photo = Objects.requireNonNull(photo, "photo");
        this.document = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGame(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.shortName = builder.shortName;
        this.title = builder.title;
        this.description = builder.description;
        this.photo = builder.photo;
        this.document = builder.document;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGame(int identifier, int flags, long id, long accessHash, String shortName, String title, String description, Photo photo, @Nullable Document document) {
        this.identifier = identifier;
        this.flags = flags;
        this.id = id;
        this.accessHash = accessHash;
        this.shortName = shortName;
        this.title = title;
        this.description = description;
        this.photo = photo;
        this.document = document;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return Game.super.identifier();
    }

    private int flagsInitialize() {
        return Game.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Photo photo() {
        return this.photo;
    }

    @Override
    @Nullable
    public Document document() {
        return this.document;
    }

    public final ImmutableGame withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGame(value, this.flags, this.id, this.accessHash, this.shortName, this.title, this.description, this.photo, this.document);
    }

    public final ImmutableGame withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableGame(this.identifier, value, this.id, this.accessHash, this.shortName, this.title, this.description, this.photo, this.document);
    }

    public final ImmutableGame withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableGame(this.identifier, this.flags, value, this.accessHash, this.shortName, this.title, this.description, this.photo, this.document);
    }

    public final ImmutableGame withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableGame(this.identifier, this.flags, this.id, value, this.shortName, this.title, this.description, this.photo, this.document);
    }

    public final ImmutableGame withShortName(String value) {
        String newValue = Objects.requireNonNull(value, "shortName");
        if (this.shortName.equals(newValue)) {
            return this;
        }
        return new ImmutableGame(this.identifier, this.flags, this.id, this.accessHash, newValue, this.title, this.description, this.photo, this.document);
    }

    public final ImmutableGame withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableGame(this.identifier, this.flags, this.id, this.accessHash, this.shortName, newValue, this.description, this.photo, this.document);
    }

    public final ImmutableGame withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableGame(this.identifier, this.flags, this.id, this.accessHash, this.shortName, this.title, newValue, this.photo, this.document);
    }

    public final ImmutableGame withPhoto(Photo value) {
        if (this.photo == value) {
            return this;
        }
        Photo newValue = Objects.requireNonNull(value, "photo");
        return new ImmutableGame(this.identifier, this.flags, this.id, this.accessHash, this.shortName, this.title, this.description, newValue, this.document);
    }

    public final ImmutableGame withDocument(@Nullable Document value) {
        if (this.document == value) {
            return this;
        }
        return new ImmutableGame(this.identifier, this.flags, this.id, this.accessHash, this.shortName, this.title, this.description, this.photo, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGame && this.equalTo(0, (ImmutableGame)another);
    }

    private boolean equalTo(int synthetic, ImmutableGame another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.id == another.id && this.accessHash == another.accessHash && this.shortName.equals(another.shortName) && this.title.equals(another.title) && this.description.equals(another.description) && this.photo.equals(another.photo) && Objects.equals(this.document, another.document);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.shortName.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.photo.hashCode();
        h += (h << 5) + Objects.hashCode(this.document);
        return h;
    }

    public String toString() {
        return "Game{identifier=" + this.identifier + ", flags=" + this.flags + ", id=" + this.id + ", accessHash=" + this.accessHash + ", shortName=" + this.shortName + ", title=" + this.title + ", description=" + this.description + ", photo=" + this.photo + ", document=" + this.document + "}";
    }

    public static ImmutableGame of(long id, long accessHash, String shortName, String title, String description, Photo photo) {
        return new ImmutableGame(id, accessHash, shortName, title, description, photo);
    }

    public static ImmutableGame copyOf(Game instance) {
        if (instance instanceof ImmutableGame) {
            return (ImmutableGame)instance;
        }
        return ImmutableGame.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_SHORT_NAME = 4L;
        private static final long INIT_BIT_TITLE = 8L;
        private static final long INIT_BIT_DESCRIPTION = 16L;
        private static final long INIT_BIT_PHOTO = 32L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 63L;
        private long optBits;
        private int identifier;
        private int flags;
        private long id;
        private long accessHash;
        private String shortName;
        private String title;
        private String description;
        private Photo photo;
        private Document document;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Game instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Game) {
                Document documentValue;
                instance = (Game)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((documentValue = instance.document()) != null) {
                    this.document(documentValue);
                }
                this.flags(instance.flags());
                this.description(instance.description());
                this.photo(instance.photo());
                this.accessHash(instance.accessHash());
                this.id(instance.id());
                this.shortName(instance.shortName());
                this.title(instance.title());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder shortName(String shortName) {
            this.shortName = Objects.requireNonNull(shortName, "shortName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder photo(Photo photo) {
            this.photo = Objects.requireNonNull(photo, "photo");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder document(@Nullable Document document) {
            this.document = document;
            return this;
        }

        public ImmutableGame build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGame(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("shortName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("photo");
            }
            return "Cannot build Game, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGame.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGame.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build Game, attribute initializers form cycle " + attributes;
        }
    }
}

