/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.GeoPoint;
import telegram4j.tl.GeoPointEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableGeoPointEmpty
implements GeoPointEmpty {
    private final int identifier;
    private static final ImmutableGeoPointEmpty INSTANCE = ImmutableGeoPointEmpty.validate(new ImmutableGeoPointEmpty());

    private ImmutableGeoPointEmpty() {
        this.identifier = GeoPointEmpty.super.identifier();
    }

    private ImmutableGeoPointEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : GeoPointEmpty.super.identifier();
    }

    private ImmutableGeoPointEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableGeoPointEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableGeoPointEmpty.validate(new ImmutableGeoPointEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGeoPointEmpty && this.equalTo(0, (ImmutableGeoPointEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableGeoPointEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "GeoPointEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableGeoPointEmpty of() {
        return INSTANCE;
    }

    private static ImmutableGeoPointEmpty validate(ImmutableGeoPointEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableGeoPointEmpty copyOf(GeoPointEmpty instance) {
        if (instance instanceof ImmutableGeoPointEmpty) {
            return (ImmutableGeoPointEmpty)instance;
        }
        return ImmutableGeoPointEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(GeoPoint instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GeoPointEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GeoPoint instance;
            long bits = 0L;
            if (object instanceof GeoPoint) {
                instance = (GeoPoint)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GeoPointEmpty) {
                instance = (GeoPointEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableGeoPointEmpty build() {
            return ImmutableGeoPointEmpty.validate(new ImmutableGeoPointEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

