/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.GlobalPrivacySettings;
import telegram4j.tl.api.TlObject;

public final class ImmutableGlobalPrivacySettings
implements GlobalPrivacySettings {
    private final int identifier;
    private final int flags;
    @Nullable
    private final Boolean archiveAndMuteNewNoncontactPeers;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableGlobalPrivacySettings INSTANCE = ImmutableGlobalPrivacySettings.validate(new ImmutableGlobalPrivacySettings());

    private ImmutableGlobalPrivacySettings() {
        this.archiveAndMuteNewNoncontactPeers = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGlobalPrivacySettings(Builder builder) {
        this.archiveAndMuteNewNoncontactPeers = builder.archiveAndMuteNewNoncontactPeers;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableGlobalPrivacySettings(int identifier, int flags, @Nullable Boolean archiveAndMuteNewNoncontactPeers) {
        this.identifier = identifier;
        this.flags = flags;
        this.archiveAndMuteNewNoncontactPeers = archiveAndMuteNewNoncontactPeers;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GlobalPrivacySettings.super.identifier();
    }

    private int flagsInitialize() {
        return GlobalPrivacySettings.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public Boolean archiveAndMuteNewNoncontactPeers() {
        return this.archiveAndMuteNewNoncontactPeers;
    }

    public final ImmutableGlobalPrivacySettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableGlobalPrivacySettings.validate(new ImmutableGlobalPrivacySettings(value, this.flags, this.archiveAndMuteNewNoncontactPeers));
    }

    public final ImmutableGlobalPrivacySettings withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableGlobalPrivacySettings.validate(new ImmutableGlobalPrivacySettings(this.identifier, value, this.archiveAndMuteNewNoncontactPeers));
    }

    public final ImmutableGlobalPrivacySettings withArchiveAndMuteNewNoncontactPeers(@Nullable Boolean value) {
        if (Objects.equals(this.archiveAndMuteNewNoncontactPeers, value)) {
            return this;
        }
        return ImmutableGlobalPrivacySettings.validate(new ImmutableGlobalPrivacySettings(this.identifier, this.flags, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGlobalPrivacySettings && this.equalTo(0, (ImmutableGlobalPrivacySettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableGlobalPrivacySettings another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.archiveAndMuteNewNoncontactPeers, another.archiveAndMuteNewNoncontactPeers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.archiveAndMuteNewNoncontactPeers);
        return h;
    }

    public String toString() {
        return "GlobalPrivacySettings{identifier=" + this.identifier + ", flags=" + this.flags + ", archiveAndMuteNewNoncontactPeers=" + this.archiveAndMuteNewNoncontactPeers + "}";
    }

    public static ImmutableGlobalPrivacySettings of() {
        return INSTANCE;
    }

    private static ImmutableGlobalPrivacySettings validate(ImmutableGlobalPrivacySettings instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableGlobalPrivacySettings copyOf(GlobalPrivacySettings instance) {
        if (instance instanceof ImmutableGlobalPrivacySettings) {
            return (ImmutableGlobalPrivacySettings)instance;
        }
        return ImmutableGlobalPrivacySettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private Boolean archiveAndMuteNewNoncontactPeers;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GlobalPrivacySettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GlobalPrivacySettings) {
                Boolean archiveAndMuteNewNoncontactPeersValue;
                instance = (GlobalPrivacySettings)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((archiveAndMuteNewNoncontactPeersValue = instance.archiveAndMuteNewNoncontactPeers()) != null) {
                    this.archiveAndMuteNewNoncontactPeers(archiveAndMuteNewNoncontactPeersValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder archiveAndMuteNewNoncontactPeers(@Nullable Boolean archiveAndMuteNewNoncontactPeers) {
            this.archiveAndMuteNewNoncontactPeers = archiveAndMuteNewNoncontactPeers;
            return this;
        }

        public ImmutableGlobalPrivacySettings build() {
            return ImmutableGlobalPrivacySettings.validate(new ImmutableGlobalPrivacySettings(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGlobalPrivacySettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGlobalPrivacySettings.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build GlobalPrivacySettings, attribute initializers form cycle " + attributes;
        }
    }
}

