/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.GroupCall;
import telegram4j.tl.GroupCallDiscarded;
import telegram4j.tl.api.TlObject;

public final class ImmutableGroupCallDiscarded
implements GroupCallDiscarded {
    private final int identifier;
    private final long id;
    private final long accessHash;
    private final int duration;

    private ImmutableGroupCallDiscarded(long id, long accessHash, int duration) {
        this.id = id;
        this.accessHash = accessHash;
        this.duration = duration;
        this.identifier = GroupCallDiscarded.super.identifier();
    }

    private ImmutableGroupCallDiscarded(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.duration = builder.duration;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GroupCallDiscarded.super.identifier();
    }

    private ImmutableGroupCallDiscarded(int identifier, long id, long accessHash, int duration) {
        this.identifier = identifier;
        this.id = id;
        this.accessHash = accessHash;
        this.duration = duration;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public int duration() {
        return this.duration;
    }

    public final ImmutableGroupCallDiscarded withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGroupCallDiscarded(value, this.id, this.accessHash, this.duration);
    }

    public final ImmutableGroupCallDiscarded withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableGroupCallDiscarded(this.identifier, value, this.accessHash, this.duration);
    }

    public final ImmutableGroupCallDiscarded withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableGroupCallDiscarded(this.identifier, this.id, value, this.duration);
    }

    public final ImmutableGroupCallDiscarded withDuration(int value) {
        if (this.duration == value) {
            return this;
        }
        return new ImmutableGroupCallDiscarded(this.identifier, this.id, this.accessHash, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGroupCallDiscarded && this.equalTo(0, (ImmutableGroupCallDiscarded)another);
    }

    private boolean equalTo(int synthetic, ImmutableGroupCallDiscarded another) {
        return this.identifier == another.identifier && this.id == another.id && this.accessHash == another.accessHash && this.duration == another.duration;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.duration;
        return h;
    }

    public String toString() {
        return "GroupCallDiscarded{identifier=" + this.identifier + ", id=" + this.id + ", accessHash=" + this.accessHash + ", duration=" + this.duration + "}";
    }

    public static ImmutableGroupCallDiscarded of(long id, long accessHash, int duration) {
        return new ImmutableGroupCallDiscarded(id, accessHash, duration);
    }

    public static ImmutableGroupCallDiscarded copyOf(GroupCallDiscarded instance) {
        if (instance instanceof ImmutableGroupCallDiscarded) {
            return (ImmutableGroupCallDiscarded)instance;
        }
        return ImmutableGroupCallDiscarded.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_DURATION = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long id;
        private long accessHash;
        private int duration;

        private Builder() {
        }

        public final Builder from(GroupCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GroupCallDiscarded instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GroupCall instance;
            long bits = 0L;
            if (object instanceof GroupCall) {
                instance = (GroupCall)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.accessHash(instance.accessHash());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.id(instance.id());
                    bits |= 4L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GroupCallDiscarded) {
                instance = (GroupCallDiscarded)object;
                this.duration(instance.duration());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.accessHash(instance.accessHash());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.id(instance.id());
                    bits |= 4L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder duration(int duration) {
            this.duration = duration;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGroupCallDiscarded build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGroupCallDiscarded(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("duration");
            }
            return "Cannot build GroupCallDiscarded, some of required attributes are not set " + attributes;
        }
    }
}

